/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.util.SchemaUtil;

public class ChangePermsStatement
implements BindableStatement {
    private Permission.Action[] permsList;
    private TableName tableName;
    private String schemaName;
    private String name;
    private boolean isGrantStatement;

    public ChangePermsStatement(String permsString, boolean isSchemaName, TableName tableName, String schemaName, boolean isGroupName, LiteralParseNode ugNode, boolean isGrantStatement) {
        if (permsString != null) {
            Permission permission = new Permission(permsString.getBytes(StandardCharsets.UTF_8));
            this.permsList = permission.getActions();
        }
        if (isSchemaName) {
            this.schemaName = SchemaUtil.normalizeIdentifier(schemaName);
        } else {
            this.tableName = tableName;
        }
        this.name = SchemaUtil.normalizeLiteral(ugNode);
        this.name = isGroupName ? AuthUtil.toGroupEntry((String)this.name) : this.name;
        this.isGrantStatement = isGrantStatement;
    }

    public Permission.Action[] getPermsList() {
        return this.permsList;
    }

    public String getName() {
        return this.name;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean isGrantStatement() {
        return this.isGrantStatement;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer = this.isGrantStatement() ? buffer.append("GRANT ") : buffer.append("REVOKE ");
        buffer.append("permissions requested for user/group: " + this.getName());
        if (this.getSchemaName() != null) {
            buffer.append(" for Schema: " + this.getSchemaName());
        } else if (this.getTableName() != null) {
            buffer.append(" for Table: " + this.getTableName());
        }
        buffer.append(" Permissions: " + Arrays.toString(this.getPermsList()));
        return buffer.toString();
    }

    @Override
    public int getBindCount() {
        return 0;
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return PhoenixStatement.Operation.ADMIN;
    }
}

