/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.MetricUtil;
import org.apache.phoenix.monitoring.MetricsStopWatch;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public class OverAllQueryMetrics {
    private final MetricsStopWatch queryWatch;
    private final MetricsStopWatch resultSetWatch;
    private final CombinableMetric numParallelScans;
    private final CombinableMetric wallClockTimeMS;
    private final CombinableMetric resultSetTimeMS;
    private final CombinableMetric queryTimedOut;
    private final CombinableMetric queryFailed;
    private final CombinableMetric cacheRefreshedDueToSplits;

    public OverAllQueryMetrics(boolean isRequestMetricsEnabled, LogLevel connectionLogLevel) {
        this.queryWatch = MetricUtil.getMetricsStopWatch(isRequestMetricsEnabled, connectionLogLevel, MetricType.WALL_CLOCK_TIME_MS);
        this.resultSetWatch = MetricUtil.getMetricsStopWatch(isRequestMetricsEnabled, connectionLogLevel, MetricType.RESULT_SET_TIME_MS);
        this.numParallelScans = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.NUM_PARALLEL_SCANS);
        this.wallClockTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.WALL_CLOCK_TIME_MS);
        this.resultSetTimeMS = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.RESULT_SET_TIME_MS);
        this.queryTimedOut = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_TIMEOUT_COUNTER);
        this.queryFailed = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.QUERY_FAILED_COUNTER);
        this.cacheRefreshedDueToSplits = MetricUtil.getCombinableMetric(isRequestMetricsEnabled, connectionLogLevel, MetricType.CACHE_REFRESH_SPLITS_COUNTER);
    }

    public void updateNumParallelScans(long numParallelScans) {
        this.numParallelScans.change(numParallelScans);
    }

    public void queryTimedOut() {
        this.queryTimedOut.increment();
    }

    public void queryFailed() {
        this.queryFailed.increment();
    }

    public void cacheRefreshedDueToSplits() {
        this.cacheRefreshedDueToSplits.increment();
    }

    public void startQuery() {
        if (!this.queryWatch.isRunning()) {
            this.queryWatch.start();
        }
    }

    public void endQuery() {
        boolean wasRunning = this.queryWatch.isRunning();
        this.queryWatch.stop();
        if (wasRunning) {
            this.wallClockTimeMS.change(this.queryWatch.getElapsedTimeInMs());
        }
    }

    public void startResultSetWatch() {
        this.resultSetWatch.start();
    }

    public void stopResultSetWatch() {
        boolean wasRunning = this.resultSetWatch.isRunning();
        this.resultSetWatch.stop();
        if (wasRunning) {
            this.resultSetTimeMS.change(this.resultSetWatch.getElapsedTimeInMs());
        }
    }

    @VisibleForTesting
    long getWallClockTimeMs() {
        return this.wallClockTimeMS.getValue();
    }

    @VisibleForTesting
    long getResultSetTimeMs() {
        return this.resultSetTimeMS.getValue();
    }

    public Map<MetricType, Long> publish() {
        HashMap<MetricType, Long> metricsForPublish = new HashMap<MetricType, Long>();
        metricsForPublish.put(this.numParallelScans.getMetricType(), this.numParallelScans.getValue());
        metricsForPublish.put(this.wallClockTimeMS.getMetricType(), this.wallClockTimeMS.getValue());
        metricsForPublish.put(this.resultSetTimeMS.getMetricType(), this.resultSetTimeMS.getValue());
        metricsForPublish.put(this.queryTimedOut.getMetricType(), this.queryTimedOut.getValue());
        metricsForPublish.put(this.queryFailed.getMetricType(), this.queryFailed.getValue());
        metricsForPublish.put(this.cacheRefreshedDueToSplits.getMetricType(), this.cacheRefreshedDueToSplits.getValue());
        return metricsForPublish;
    }

    public void reset() {
        this.numParallelScans.reset();
        this.wallClockTimeMS.reset();
        this.resultSetTimeMS.reset();
        this.queryTimedOut.reset();
        this.queryFailed.reset();
        this.cacheRefreshedDueToSplits.reset();
        this.queryWatch.stop();
        this.resultSetWatch.stop();
    }

    public OverAllQueryMetrics combine(OverAllQueryMetrics metric) {
        this.cacheRefreshedDueToSplits.combine(metric.cacheRefreshedDueToSplits);
        this.queryFailed.combine(metric.queryFailed);
        this.queryTimedOut.combine(metric.queryTimedOut);
        this.numParallelScans.combine(metric.numParallelScans);
        return this;
    }
}

