/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.phoenix.monitoring.MetricUtil;
import org.apache.phoenix.query.QueryServicesOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMetricRegistriesAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalMetricRegistriesAdapter.class);
    private static GlobalMetricRegistriesAdapter INSTANCE = new GlobalMetricRegistriesAdapter();

    private GlobalMetricRegistriesAdapter() {
        if (MetricUtil.isDefaultMetricsInitialized()) {
            LOGGER.info("HBase metrics is already initialized. Skipping Phoenix metrics initialization.");
            return;
        }
        DefaultMetricsSystem.initialize((String)"Phoenix");
        JvmMetrics.initSingleton((String)"Phoenix", (String)"");
    }

    public static GlobalMetricRegistriesAdapter getInstance() {
        return INSTANCE;
    }

    public void registerMetricRegistry(MetricRegistry registry) {
        if (registry == null) {
            LOGGER.warn("Registry cannot be registered with Hadoop Metrics 2 since it is null.");
            return;
        }
        HBaseMetrics2HadoopMetricsAdapter adapter = new HBaseMetrics2HadoopMetricsAdapter(registry);
        adapter.registerToDefaultMetricsSystem();
    }

    private static class HBaseMetrics2HadoopMetricsAdapter
    implements MetricsSource {
        private static final Logger LOGGER = LoggerFactory.getLogger(HBaseMetrics2HadoopMetricsAdapter.class);
        private final MetricRegistry registry;
        private final String metricTag;

        private HBaseMetrics2HadoopMetricsAdapter(MetricRegistry registry) {
            this.registry = registry;
            this.metricTag = QueryServicesOptions.withDefaults().getClientMetricTag();
        }

        private void registerToDefaultMetricsSystem() {
            MetricRegistryInfo info = this.registry.getMetricRegistryInfo();
            LOGGER.info("Registering " + info.getMetricsJmxContext() + " " + info.getMetricsDescription() + " into DefaultMetricsSystem");
            DefaultMetricsSystem.instance().register(info.getMetricsJmxContext(), info.getMetricsDescription(), (Object)this);
        }

        private void snapshotAllMetrics(MetricRegistry metricRegistry, MetricsCollector collector) {
            MetricRegistryInfo hbaseMetricRegistryInfo = metricRegistry.getMetricRegistryInfo();
            MetricsInfo hadoopMetricsInfo = Interns.info((String)hbaseMetricRegistryInfo.getMetricsName(), (String)hbaseMetricRegistryInfo.getMetricsDescription());
            MetricsRecordBuilder builder = collector.addRecord(hadoopMetricsInfo);
            builder.setContext(hbaseMetricRegistryInfo.getMetricsContext());
            builder.tag(hadoopMetricsInfo, this.metricTag);
            this.snapshotAllMetrics(metricRegistry, builder);
        }

        private void snapshotAllMetrics(MetricRegistry metricRegistry, MetricsRecordBuilder builder) {
            Map metrics = metricRegistry.getMetrics();
            for (Map.Entry e : metrics.entrySet()) {
                String name = StringUtils.capitalize((String)((String)e.getKey()));
                Metric metric = (Metric)e.getValue();
                if (metric instanceof Gauge) {
                    this.addGauge(name, (Gauge)metric, builder);
                    continue;
                }
                if (metric instanceof Counter) {
                    this.addCounter(name, (Counter)metric, builder);
                    continue;
                }
                if (metric instanceof Histogram) {
                    this.addHistogram(name, (Histogram)metric, builder);
                    continue;
                }
                if (metric instanceof Meter) {
                    this.addMeter(name, (Meter)metric, builder);
                    continue;
                }
                if (metric instanceof Timer) {
                    this.addTimer(name, (Timer)metric, builder);
                    continue;
                }
                LOGGER.info("Ignoring unknown Metric class " + metric.getClass().getName());
            }
        }

        private void addGauge(String name, Gauge<?> gauge, MetricsRecordBuilder builder) {
            MetricsInfo info = Interns.info((String)name, (String)"");
            Object o = gauge.getValue();
            if (o instanceof Integer) {
                builder.addGauge(info, ((Integer)o).intValue());
            } else if (o instanceof Long) {
                builder.addGauge(info, ((Long)o).longValue());
            } else if (o instanceof Float) {
                builder.addGauge(info, ((Float)o).floatValue());
            } else if (o instanceof Double) {
                builder.addGauge(info, ((Double)o).doubleValue());
            } else {
                LOGGER.warn("Ignoring Gauge (" + name + ") with unhandled type: " + o.getClass());
            }
        }

        private void addCounter(String name, Counter counter, MetricsRecordBuilder builder) {
            MetricsInfo info = Interns.info((String)name, (String)"");
            builder.addCounter(info, counter.getCount());
        }

        private void addHistogram(String name, Histogram histogram, MetricsRecordBuilder builder) {
            MutableHistogram.snapshot((String)name, (String)"", (Histogram)histogram, (MetricsRecordBuilder)builder, (boolean)true);
        }

        private void addMeter(String name, Meter meter, MetricsRecordBuilder builder) {
            builder.addGauge(Interns.info((String)(name + "_count"), (String)""), meter.getCount());
            builder.addGauge(Interns.info((String)(name + "_mean_rate"), (String)""), meter.getMeanRate());
            builder.addGauge(Interns.info((String)(name + "_1min_rate"), (String)""), meter.getOneMinuteRate());
            builder.addGauge(Interns.info((String)(name + "_5min_rate"), (String)""), meter.getFiveMinuteRate());
            builder.addGauge(Interns.info((String)(name + "_15min_rate"), (String)""), meter.getFifteenMinuteRate());
        }

        private void addTimer(String name, Timer timer, MetricsRecordBuilder builder) {
            this.addMeter(name, timer.getMeter(), builder);
            this.addHistogram(name, timer.getHistogram(), builder);
        }

        public void getMetrics(MetricsCollector metricsCollector, boolean b) {
            this.snapshotAllMetrics(this.registry, metricsCollector);
        }
    }
}

