/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;

public class ViewInfoTracker
implements ViewInfoWritable {
    String tenantId;
    String viewName;
    String relationName;
    long phoenixTtl;
    boolean isIndexRelation;

    public ViewInfoTracker() {
    }

    public ViewInfoTracker(String tenantId, String viewName, long phoenixTtl, String relationName, boolean isIndexRelation) {
        this.setTenantId(tenantId);
        this.viewName = viewName;
        this.phoenixTtl = phoenixTtl;
        this.relationName = relationName;
        this.isIndexRelation = isIndexRelation;
    }

    private void setTenantId(String tenantId) {
        if (tenantId != null) {
            this.tenantId = tenantId;
        }
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public String getRelationName() {
        return this.relationName;
    }

    @Override
    public boolean isIndexRelation() {
        return this.isIndexRelation;
    }

    public long getPhoenixTtl() {
        return this.phoenixTtl;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeString((DataOutput)output, (String)this.tenantId);
        WritableUtils.writeString((DataOutput)output, (String)this.viewName);
        WritableUtils.writeVLong((DataOutput)output, (long)this.phoenixTtl);
        WritableUtils.writeString((DataOutput)output, (String)this.relationName);
        WritableUtils.writeString((DataOutput)output, (String)(this.isIndexRelation ? "true" : "false"));
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.setTenantId(WritableUtils.readString((DataInput)input));
        this.viewName = WritableUtils.readString((DataInput)input);
        this.phoenixTtl = WritableUtils.readVLong((DataInput)input);
        this.relationName = WritableUtils.readString((DataInput)input);
        this.isIndexRelation = WritableUtils.readString((DataInput)input).equals("true");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ViewName" + this.viewName);
        if (this.tenantId != null) {
            sb.append(", Tenant:" + this.tenantId);
        }
        if (this.isIndexRelation) {
            sb.append(", IndexName:" + this.relationName);
        } else {
            sb.append(", BaseTableName:" + this.relationName);
        }
        return sb.toString();
    }
}

