/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoenixConfigurationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixConfigurationUtil.class);
    public static final String SESSION_ID = "phoenix.sessionid";
    public static final String UPSERT_STATEMENT = "phoenix.upsert.stmt";
    public static final String SELECT_STATEMENT = "phoenix.select.stmt";
    public static final String UPSERT_BATCH_SIZE = "phoenix.upsert.batch.size";
    public static final String SCHEMA_TYPE = "phoenix.select.schema.type";
    public static final String MAPREDUCE_SELECT_COLUMN_VALUE_PREFIX = "phoenix.mr.select.column.value";
    public static final String MAPREDUCE_SELECT_COLUMN_COUNT = "phoenix.mr.select.column.count";
    public static final String MAPREDUCE_UPSERT_COLUMN_VALUE_PREFIX = "phoenix.mr.upsert.column.value";
    public static final String MAPREDUCE_UPSERT_COLUMN_COUNT = "phoenix.mr.upsert.column.count";
    public static final String INPUT_TABLE_NAME = "phoenix.input.table.name";
    public static final String OUTPUT_TABLE_NAME = "phoenix.colinfo.table.name";
    public static final String INPUT_TABLE_CONDITIONS = "phoenix.input.table.conditions";
    public static final String PHYSICAL_TABLE_NAME = "phoenix.output.table.name";
    public static final long DEFAULT_UPSERT_BATCH_SIZE = 1000L;
    public static final String INPUT_CLASS = "phoenix.input.class";
    public static final String CURRENT_SCN_VALUE = "phoenix.mr.currentscn.value";
    public static final String TX_SCN_VALUE = "phoenix.mr.txscn.value";
    public static final String TX_PROVIDER = "phoenix.mr.txprovider";
    public static final String UPSERT_HOOK_CLASS_CONFKEY = "phoenix.mapreduce.import.kvprocessor";
    public static final String MAPREDUCE_INPUT_CLUSTER_QUORUM = "phoenix.mapreduce.input.cluster.quorum";
    public static final String MAPREDUCE_OUTPUT_CLUSTER_QUORUM = "phoneix.mapreduce.output.cluster.quorum";
    public static final String INDEX_DISABLED_TIMESTAMP_VALUE = "phoenix.mr.index.disableTimestamp";
    public static final String INDEX_MAINTAINERS = "phoenix.mr.index.maintainers";
    public static final String SCRUTINY_DATA_TABLE_NAME = "phoenix.mr.scrutiny.data.table.name";
    public static final String SCRUTINY_INDEX_TABLE_NAME = "phoenix.mr.scrutiny.index.table.name";
    public static final String INDEX_TOOL_DATA_TABLE_NAME = "phoenix.mr.index_tool.data.table.name";
    public static final String INDEX_TOOL_INDEX_TABLE_NAME = "phoenix.mr.index_tool.index.table.name";
    public static final String INDEX_TOOL_SOURCE_TABLE = "phoenix.mr.index_tool.source.table";
    public static final String SCRUTINY_SOURCE_TABLE = "phoenix.mr.scrutiny.source.table";
    public static final String SCRUTINY_BATCH_SIZE = "phoenix.mr.scrutiny.batch.size";
    public static final String SCRUTINY_OUTPUT_INVALID_ROWS = "phoenix.mr.scrutiny.output.invalid.rows";
    public static final boolean DEFAULT_SCRUTINY_OUTPUT_INVALID_ROWS = false;
    public static final String SCRUTINY_OUTPUT_FORMAT = "phoenix.mr.scrutiny.output.format";
    public static final String SCRUTINY_EXECUTE_TIMESTAMP = "phoenix.mr.scrutiny.execute.timestamp";
    public static final String SCRUTINY_OUTPUT_MAX = "phoenix.mr.scrutiny.output.max";
    public static final long DEFAULT_SCRUTINY_BATCH_SIZE = 1000L;
    public static final String DISABLED_INDEXES = "phoenix.mr.index.disabledIndexes";
    public static final String VERIFY_INDEX = "phoenix.mr.index.verifyIndex";
    public static final String ONLY_VERIFY_INDEX = "phoenix.mr.index.onlyVerifyIndex";
    public static final String INDEX_VERIFY_TYPE = "phoenix.mr.index.IndexVerifyType";
    public static final String DISABLE_LOGGING_TYPE = "phoenix.mr.index.IndexDisableLoggingType";
    public static final String MAPREDUCE_SPLIT_BY_STATS = "phoenix.mapreduce.split.by.stats";
    public static final boolean DEFAULT_SPLIT_BY_STATS = true;
    public static final String SNAPSHOT_NAME_KEY = "phoenix.mapreduce.snapshot.name";
    public static final String RESTORE_DIR_KEY = "phoenix.tableSnapshot.restore.dir";
    public static final String MAPREDUCE_TENANT_ID = "phoenix.mapreduce.tenantid";
    private static final String INDEX_TOOL_END_TIME = "phoenix.mr.index.endtime";
    private static final String INDEX_TOOL_START_TIME = "phoenix.mr.index.starttime";
    private static final String INDEX_TOOL_LAST_VERIFY_TIME = "phoenix.mr.index.last.verify.time";
    public static final String MAPREDUCE_JOB_TYPE = "phoenix.mapreduce.jobtype";
    public static final String MAPREDUCE_MULTI_INPUT_MAPPER_SPLIT_SIZE = "phoenix.mapreduce.multi.input.split.size";
    public static final String MAPREDUCE_MULTI_INPUT_QUERY_BATCH_SIZE = "phoenix.mapreduce.multi.input.batch.size";
    public static final String MAPREDUCE_PHOENIX_TTL_DELETE_JOB_PER_VIEW = "phoenix.mapreduce.phoenix_ttl.per_view";
    public static final String MAPREDUCE_PHOENIX_TTL_DELETE_JOB_ALL_VIEWS = "phoenix.mapreduce.phoenix_ttl.all";
    public static final String MAPREDUCE_MULTI_INPUT_STRATEGY_CLAZZ = "phoenix.mapreduce.multi.input.strategy.path";
    public static final String MAPREDUCE_MULTI_INPUT_SPLIT_STRATEGY_CLAZZ = "phoenix.mapreduce.multi.split.strategy.path";
    public static final String MAPREDUCE_MULTI_INPUT_MAPPER_TRACKER_CLAZZ = "phoenix.mapreduce.multi.mapper.tracker.path";
    public static final String MAPREDUCE_EXTERNAL_SNAPSHOT_RESTORE = "phoenix.mapreduce.external.snapshot.restore";
    public static final boolean DEFAULT_MAPREDUCE_EXTERNAL_SNAPSHOT_RESTORE = false;

    private PhoenixConfigurationUtil() {
    }

    public static void setInputTableName(Configuration configuration, String tableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)tableName);
        configuration.set(INPUT_TABLE_NAME, tableName);
    }

    public static void setInputTableConditions(Configuration configuration, String conditions) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)conditions);
        configuration.set(INPUT_TABLE_CONDITIONS, conditions);
    }

    private static void setValues(Configuration configuration, String[] columns, String VALUE_COUNT, String VALUE_NAME) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setInt(VALUE_COUNT, columns.length);
        for (int i = 0; i < columns.length; ++i) {
            configuration.set(String.format("%s_%d", VALUE_NAME, i), columns[i]);
        }
    }

    private static List<String> getValues(Configuration configuration, String VALUE_COUNT, String VALUE_NAME) {
        Preconditions.checkNotNull((Object)configuration);
        int numCols = configuration.getInt(VALUE_COUNT, 0);
        ArrayList cols = Lists.newArrayListWithExpectedSize((int)numCols);
        for (int i = 0; i < numCols; ++i) {
            cols.add(configuration.get(String.format("%s_%d", VALUE_NAME, i)));
        }
        return cols;
    }

    public static void setSelectColumnNames(Configuration configuration, String[] columns) {
        PhoenixConfigurationUtil.setValues(configuration, columns, MAPREDUCE_SELECT_COLUMN_COUNT, MAPREDUCE_SELECT_COLUMN_VALUE_PREFIX);
    }

    public static List<String> getSelectColumnNames(Configuration configuration) {
        return PhoenixConfigurationUtil.getValues(configuration, MAPREDUCE_SELECT_COLUMN_COUNT, MAPREDUCE_SELECT_COLUMN_VALUE_PREFIX);
    }

    public static void setInputClass(Configuration configuration, Class<? extends DBWritable> inputClass) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setClass(INPUT_CLASS, inputClass, DBWritable.class);
    }

    public static void setInputQuery(Configuration configuration, String inputQuery) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)inputQuery);
        configuration.set(SELECT_STATEMENT, inputQuery);
    }

    public static void setPropertyPolicyProviderDisabled(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set("phoenix.property.policy.provider.enabled", "false");
    }

    public static void setSchemaType(Configuration configuration, SchemaType schemaType) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(SCHEMA_TYPE, schemaType.name());
    }

    public static void setMRJobType(Configuration configuration, MRJobType mrJobType) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_JOB_TYPE, mrJobType.name());
    }

    public static void setPhysicalTableName(Configuration configuration, String tableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)tableName);
        configuration.set(PHYSICAL_TABLE_NAME, tableName);
    }

    public static void setOutputTableName(Configuration configuration, String tableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)tableName);
        configuration.set(OUTPUT_TABLE_NAME, tableName);
    }

    public static void setUpsertColumnNames(Configuration configuration, String[] columns) {
        PhoenixConfigurationUtil.setValues(configuration, columns, MAPREDUCE_UPSERT_COLUMN_COUNT, MAPREDUCE_UPSERT_COLUMN_VALUE_PREFIX);
    }

    public static void setSnapshotNameKey(Configuration configuration, String snapshotName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)snapshotName);
        configuration.set(SNAPSHOT_NAME_KEY, snapshotName);
    }

    public static void setRestoreDirKey(Configuration configuration, String restoreDir) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)restoreDir);
        configuration.set(RESTORE_DIR_KEY, restoreDir);
    }

    public static void setIndexToolStartTime(Configuration configuration, Long startTime) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)startTime);
        configuration.set(INDEX_TOOL_START_TIME, Long.toString(startTime));
    }

    public static void setIndexToolLastVerifyTime(Configuration configuration, Long lastVerifyTime) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)lastVerifyTime);
        configuration.set(INDEX_TOOL_LAST_VERIFY_TIME, Long.toString(lastVerifyTime));
    }

    public static void setCurrentScnValue(Configuration configuration, Long scn) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)scn);
        configuration.set(CURRENT_SCN_VALUE, Long.toString(scn));
    }

    public static String getIndexToolStartTime(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(INDEX_TOOL_START_TIME);
    }

    public static String getCurrentScnValue(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(CURRENT_SCN_VALUE);
    }

    public static String getIndexToolLastVerifyTime(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(INDEX_TOOL_LAST_VERIFY_TIME);
    }

    public static List<String> getUpsertColumnNames(Configuration configuration) {
        return PhoenixConfigurationUtil.getValues(configuration, MAPREDUCE_UPSERT_COLUMN_COUNT, MAPREDUCE_UPSERT_COLUMN_VALUE_PREFIX);
    }

    public static void setBatchSize(Configuration configuration, Long batchSize) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setLong(UPSERT_BATCH_SIZE, batchSize.longValue());
    }

    public static void setInputCluster(Configuration configuration, String quorum) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_INPUT_CLUSTER_QUORUM, quorum);
    }

    public static void setOutputCluster(Configuration configuration, String quorum) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_OUTPUT_CLUSTER_QUORUM, quorum);
    }

    public static Class<?> getInputClass(Configuration configuration) {
        return configuration.getClass(INPUT_CLASS, DBInputFormat.NullDBWritable.class);
    }

    public static SchemaType getSchemaType(Configuration configuration) {
        String schemaTp = configuration.get(SCHEMA_TYPE);
        Preconditions.checkNotNull((Object)schemaTp);
        return SchemaType.valueOf(schemaTp);
    }

    public static MRJobType getMRJobType(Configuration configuration, String defaultMRJobType) {
        String mrJobType = configuration.get(MAPREDUCE_JOB_TYPE, defaultMRJobType);
        Preconditions.checkNotNull((Object)mrJobType);
        return MRJobType.valueOf(mrJobType);
    }

    public static List<ColumnInfo> getUpsertColumnMetadataList(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        List<ColumnInfo> columnMetadataList = null;
        columnMetadataList = ColumnInfoToStringEncoderDecoder.decode(configuration);
        if (columnMetadataList != null && !columnMetadataList.isEmpty()) {
            return columnMetadataList;
        }
        String tableName = PhoenixConfigurationUtil.getOutputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        try (Connection connection = ConnectionUtil.getOutputConnection(configuration);){
            List<String> upsertColumnList = PhoenixConfigurationUtil.getUpsertColumnNames(configuration);
            if (!upsertColumnList.isEmpty()) {
                LOGGER.info(String.format("UseUpsertColumns=%s, upsertColumnList.size()=%s, upsertColumnList=%s ", !upsertColumnList.isEmpty(), upsertColumnList.size(), Joiner.on((String)",").join(upsertColumnList)));
            }
            columnMetadataList = PhoenixRuntime.generateColumnInfo(connection, tableName, upsertColumnList);
            ColumnInfoToStringEncoderDecoder.encode(configuration, columnMetadataList);
        }
        return columnMetadataList;
    }

    public static String getUpsertStatement(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        String upsertStmt = configuration.get(UPSERT_STATEMENT);
        if (StringUtils.isNotEmpty((CharSequence)upsertStmt)) {
            return upsertStmt;
        }
        String tableName = PhoenixConfigurationUtil.getOutputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        List<String> upsertColumnNames = PhoenixConfigurationUtil.getUpsertColumnNames(configuration);
        List<ColumnInfo> columnMetadataList = PhoenixConfigurationUtil.getUpsertColumnMetadataList(configuration);
        if (!upsertColumnNames.isEmpty()) {
            upsertStmt = QueryUtil.constructUpsertStatement(tableName, columnMetadataList);
            LOGGER.info("Phoenix Custom Upsert Statement: " + upsertStmt);
        } else {
            upsertStmt = QueryUtil.constructGenericUpsertStatement(tableName, columnMetadataList.size());
            LOGGER.info("Phoenix Generic Upsert Statement: " + upsertStmt);
        }
        configuration.set(UPSERT_STATEMENT, upsertStmt);
        return upsertStmt;
    }

    public static void setUpsertStatement(Configuration configuration, String upsertStmt) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)upsertStmt);
        configuration.set(UPSERT_STATEMENT, upsertStmt);
    }

    public static void setMultiInputMapperSplitSize(Configuration configuration, int splitSize) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_MULTI_INPUT_MAPPER_SPLIT_SIZE, String.valueOf(splitSize));
    }

    public static void setMultiViewQueryMoreSplitSize(Configuration configuration, int batchSize) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_MULTI_INPUT_QUERY_BATCH_SIZE, String.valueOf(batchSize));
    }

    public static int getMultiViewQueryMoreSplitSize(Configuration configuration) {
        String batchSize = configuration.get(MAPREDUCE_MULTI_INPUT_QUERY_BATCH_SIZE);
        Preconditions.checkNotNull((Object)batchSize);
        return Integer.parseInt(batchSize);
    }

    public static List<ColumnInfo> getSelectColumnMetadataList(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        List<ColumnInfo> columnMetadataList = null;
        columnMetadataList = ColumnInfoToStringEncoderDecoder.decode(configuration);
        if (columnMetadataList != null && !columnMetadataList.isEmpty()) {
            return columnMetadataList;
        }
        String tableName = PhoenixConfigurationUtil.getInputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        Properties props = new Properties();
        String tenantId = configuration.get(MAPREDUCE_TENANT_ID);
        if (tenantId != null) {
            props.setProperty("TenantId", tenantId);
        }
        try (Connection connection = ConnectionUtil.getInputConnection(configuration, props);){
            List<String> selectColumnList = PhoenixConfigurationUtil.getSelectColumnList(configuration);
            columnMetadataList = PhoenixRuntime.generateColumnInfo(connection, tableName, selectColumnList);
            ColumnInfoToStringEncoderDecoder.encode(configuration, columnMetadataList);
        }
        return columnMetadataList;
    }

    public static int getMultiViewSplitSize(Configuration configuration) {
        String splitSize = configuration.get(MAPREDUCE_MULTI_INPUT_MAPPER_SPLIT_SIZE);
        Preconditions.checkNotNull((Object)splitSize);
        return Integer.parseInt(splitSize);
    }

    private static List<String> getSelectColumnList(Configuration configuration) {
        List<String> selectColumnList = PhoenixConfigurationUtil.getSelectColumnNames(configuration);
        if (!selectColumnList.isEmpty()) {
            LOGGER.info(String.format("UseSelectColumns=%s, selectColumnList.size()=%s, selectColumnList=%s ", !selectColumnList.isEmpty(), selectColumnList.size(), Joiner.on((String)",").join(selectColumnList)));
        }
        return selectColumnList;
    }

    public static String getSelectStatement(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        String selectStmt = configuration.get(SELECT_STATEMENT);
        if (StringUtils.isNotEmpty((CharSequence)selectStmt)) {
            LOGGER.info("Select Statement: " + selectStmt);
            return selectStmt;
        }
        String tableName = PhoenixConfigurationUtil.getInputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        List<ColumnInfo> columnMetadataList = PhoenixConfigurationUtil.getSelectColumnMetadataList(configuration);
        String conditions = configuration.get(INPUT_TABLE_CONDITIONS);
        LOGGER.info("Building select statement from input conditions: " + conditions);
        selectStmt = QueryUtil.constructSelectStatement(tableName, columnMetadataList, conditions);
        LOGGER.info("Select Statement: " + selectStmt);
        configuration.set(SELECT_STATEMENT, selectStmt);
        return selectStmt;
    }

    public static long getBatchSize(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        long batchSize = configuration.getLong(UPSERT_BATCH_SIZE, 1000L);
        if (batchSize <= 0L) {
            try (Connection conn = ConnectionUtil.getOutputConnection(configuration);){
                batchSize = ((PhoenixConnection)conn).getMutateBatchSize();
            }
        }
        configuration.setLong(UPSERT_BATCH_SIZE, batchSize);
        return batchSize;
    }

    public static int getSelectColumnsCount(Configuration configuration, String tableName) throws SQLException {
        List<ColumnInfo> columnInfos;
        List<String> selectedColumnList;
        Preconditions.checkNotNull((Object)configuration);
        String schemaTp = configuration.get(SCHEMA_TYPE);
        SchemaType schemaType = SchemaType.valueOf(schemaTp);
        int count = 0;
        count = SchemaType.QUERY.equals((Object)schemaType) ? ((selectedColumnList = PhoenixConfigurationUtil.getSelectColumnList(configuration)) == null ? 0 : selectedColumnList.size()) : ((columnInfos = PhoenixConfigurationUtil.getSelectColumnMetadataList(configuration)) == null ? 0 : columnInfos.size());
        return count;
    }

    public static String getInputTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(INPUT_TABLE_NAME);
    }

    public static String getPhysicalTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(PHYSICAL_TABLE_NAME);
    }

    public static String getOutputTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(OUTPUT_TABLE_NAME);
    }

    public static String getInputCluster(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_INPUT_CLUSTER_QUORUM);
        if (quorum == null) {
            quorum = configuration.get("hbase.zookeeper.quorum");
        }
        return quorum;
    }

    public static String getOutputCluster(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_OUTPUT_CLUSTER_QUORUM);
        if (quorum == null) {
            quorum = configuration.get("hbase.zookeeper.quorum");
        }
        return quorum;
    }

    public static Integer getClientPort(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String clientPortString = configuration.get("hbase.zookeeper.property.clientPort");
        return clientPortString == null ? null : Integer.valueOf(Integer.parseInt(clientPortString));
    }

    public static String getZNodeParent(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get("zookeeper.znode.parent");
    }

    public static void loadHBaseConfiguration(Job job) throws IOException {
        Configuration hbaseConf = HBaseConfiguration.create();
        for (Map.Entry entry : hbaseConf) {
            if (job.getConfiguration().get((String)entry.getKey()) != null) continue;
            job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
        }
        TableMapReduceUtil.initCredentials((Job)job);
    }

    public static ImportPreUpsertKeyValueProcessor loadPreUpsertProcessor(Configuration conf) {
        Class processorClass = null;
        try {
            processorClass = conf.getClass(UPSERT_HOOK_CLASS_CONFKEY, FormatToBytesWritableMapper.DefaultImportPreUpsertKeyValueProcessor.class, ImportPreUpsertKeyValueProcessor.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load upsert hook class", e);
        }
        return (ImportPreUpsertKeyValueProcessor)ReflectionUtils.newInstance((Class)processorClass, (Configuration)conf);
    }

    public static byte[] getIndexMaintainers(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return Base64.getDecoder().decode(configuration.get(INDEX_MAINTAINERS));
    }

    public static void setIndexMaintainers(Configuration configuration, ImmutableBytesWritable indexMetaDataPtr) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)indexMetaDataPtr);
        configuration.set(INDEX_MAINTAINERS, Bytes.toString((byte[])Base64.getEncoder().encode(indexMetaDataPtr.get())));
    }

    public static void setDisableIndexes(Configuration configuration, String indexName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)indexName);
        configuration.set(DISABLED_INDEXES, indexName);
    }

    public static void setVerifyIndex(Configuration configuration, boolean verify) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setBoolean(VERIFY_INDEX, verify);
    }

    public static void setOnlyVerifyIndex(Configuration configuration, boolean verify) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setBoolean(ONLY_VERIFY_INDEX, verify);
    }

    public static void setIndexVerifyType(Configuration configuration, IndexTool.IndexVerifyType verifyType) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(INDEX_VERIFY_TYPE, verifyType.getValue());
    }

    public static void setDisableLoggingVerifyType(Configuration configuration, IndexTool.IndexDisableLoggingType disableLoggingType) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(DISABLE_LOGGING_TYPE, disableLoggingType.getValue());
    }

    public static String getScrutinyDataTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(SCRUTINY_DATA_TABLE_NAME);
    }

    public static void setScrutinyDataTable(Configuration configuration, String qDataTableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)qDataTableName);
        configuration.set(SCRUTINY_DATA_TABLE_NAME, qDataTableName);
    }

    public static String getScrutinyIndexTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(SCRUTINY_INDEX_TABLE_NAME);
    }

    public static void setIndexToolDataTableName(Configuration configuration, String qDataTableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)qDataTableName);
        configuration.set(INDEX_TOOL_DATA_TABLE_NAME, qDataTableName);
    }

    public static String getIndexToolDataTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(INDEX_TOOL_DATA_TABLE_NAME);
    }

    public static void setScrutinyIndexTable(Configuration configuration, String qIndexTableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)qIndexTableName);
        configuration.set(SCRUTINY_INDEX_TABLE_NAME, qIndexTableName);
    }

    public static IndexScrutinyTool.SourceTable getScrutinySourceTable(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return IndexScrutinyTool.SourceTable.valueOf(configuration.get(SCRUTINY_SOURCE_TABLE));
    }

    public static void setIndexToolIndexTableName(Configuration configuration, String qIndexTableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)qIndexTableName);
        configuration.set(INDEX_TOOL_INDEX_TABLE_NAME, qIndexTableName);
    }

    public static String getIndexToolIndexTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(INDEX_TOOL_INDEX_TABLE_NAME);
    }

    public static void setIndexToolSourceTable(Configuration configuration, IndexScrutinyTool.SourceTable sourceTable) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)((Object)sourceTable));
        configuration.set(INDEX_TOOL_SOURCE_TABLE, sourceTable.name());
    }

    public static IndexScrutinyTool.SourceTable getIndexToolSourceTable(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return IndexScrutinyTool.SourceTable.valueOf(configuration.get(INDEX_TOOL_SOURCE_TABLE, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.name()));
    }

    public static void setScrutinySourceTable(Configuration configuration, IndexScrutinyTool.SourceTable sourceTable) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)((Object)sourceTable));
        configuration.set(SCRUTINY_SOURCE_TABLE, sourceTable.name());
    }

    public static boolean getScrutinyOutputInvalidRows(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.getBoolean(SCRUTINY_OUTPUT_INVALID_ROWS, false);
    }

    public static void setScrutinyOutputInvalidRows(Configuration configuration, boolean outputInvalidRows) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setBoolean(SCRUTINY_OUTPUT_INVALID_ROWS, outputInvalidRows);
    }

    public static long getScrutinyBatchSize(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.getLong(SCRUTINY_BATCH_SIZE, 1000L);
    }

    public static void setScrutinyBatchSize(Configuration configuration, long batchSize) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setLong(SCRUTINY_BATCH_SIZE, batchSize);
    }

    public static IndexScrutinyTool.OutputFormat getScrutinyOutputFormat(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return IndexScrutinyTool.OutputFormat.valueOf(configuration.get(SCRUTINY_OUTPUT_FORMAT, IndexScrutinyTool.OutputFormat.FILE.name()));
    }

    public static void setScrutinyOutputFormat(Configuration configuration, IndexScrutinyTool.OutputFormat outputFormat) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)((Object)outputFormat));
        configuration.set(SCRUTINY_OUTPUT_FORMAT, outputFormat.name());
    }

    public static long getScrutinyExecuteTimestamp(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        long ts = configuration.getLong(SCRUTINY_EXECUTE_TIMESTAMP, -1L);
        Preconditions.checkArgument((ts != -1L ? 1 : 0) != 0);
        return ts;
    }

    public static void setScrutinyOutputMax(Configuration configuration, long outputMaxRows) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setLong(SCRUTINY_OUTPUT_MAX, outputMaxRows);
    }

    public static long getScrutinyOutputMax(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        long maxRows = configuration.getLong(SCRUTINY_OUTPUT_MAX, -1L);
        Preconditions.checkArgument((maxRows != -1L ? 1 : 0) != 0);
        return maxRows;
    }

    public static void setScrutinyExecuteTimestamp(Configuration configuration, long ts) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setLong(SCRUTINY_EXECUTE_TIMESTAMP, ts);
    }

    public static void setSplitByStats(Configuration configuration, boolean value) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setBoolean(MAPREDUCE_SPLIT_BY_STATS, value);
    }

    public static String getDisableIndexes(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(DISABLED_INDEXES);
    }

    public static boolean getVerifyIndex(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.getBoolean(VERIFY_INDEX, false);
    }

    public static boolean getOnlyVerifyIndex(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.getBoolean(ONLY_VERIFY_INDEX, false);
    }

    public static IndexTool.IndexVerifyType getIndexVerifyType(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String value = configuration.get(INDEX_VERIFY_TYPE, IndexTool.IndexVerifyType.NONE.getValue());
        return IndexTool.IndexVerifyType.fromValue(value);
    }

    public static IndexTool.IndexVerifyType getDisableLoggingVerifyType(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String value = configuration.get(DISABLE_LOGGING_TYPE, IndexTool.IndexVerifyType.NONE.getValue());
        return IndexTool.IndexVerifyType.fromValue(value);
    }

    public static boolean getSplitByStats(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        boolean split = configuration.getBoolean(MAPREDUCE_SPLIT_BY_STATS, true);
        return split;
    }

    public static boolean getStatsForParallelizationProp(PhoenixConnection conn, PTable table) {
        Boolean useStats = table.useStatsForParallelization();
        if (useStats != null) {
            return useStats;
        }
        PName tenantId = conn.getTenantId();
        int retryCount = 0;
        while (retryCount++ < 2) {
            if (table.getType() != PTableType.INDEX || table.getParentName() == null) continue;
            String parentTableName = table.getParentName().getString();
            try {
                PTable parentTable = conn.getTable(new PTableKey(tenantId, parentTableName));
                useStats = parentTable.useStatsForParallelization();
                if (useStats == null) continue;
                return useStats;
            }
            catch (TableNotFoundException e) {
                if (tenantId != null) {
                    tenantId = null;
                    continue;
                }
                LOGGER.warn("Unable to find parent table \"" + parentTableName + "\" of table \"" + table.getName().getString() + "\" to determine USE_STATS_FOR_PARALLELIZATION", (Throwable)e);
            }
        }
        return conn.getQueryServices().getConfiguration().getBoolean("phoenix.use.stats.parallelization", true);
    }

    public static void setTenantId(Configuration configuration, String tenantId) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_TENANT_ID, tenantId);
    }

    public static void setMRSnapshotManagedExternally(Configuration configuration, Boolean isSnapshotRestoreManagedExternally) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)isSnapshotRestoreManagedExternally);
        configuration.setBoolean(MAPREDUCE_EXTERNAL_SNAPSHOT_RESTORE, isSnapshotRestoreManagedExternally.booleanValue());
    }

    public static boolean isMRSnapshotManagedExternally(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        boolean isSnapshotRestoreManagedExternally = configuration.getBoolean(MAPREDUCE_EXTERNAL_SNAPSHOT_RESTORE, false);
        return isSnapshotRestoreManagedExternally;
    }

    public static enum SchemaType {
        TABLE,
        QUERY;

    }

    public static enum MRJobType {
        QUERY,
        UPDATE_STATS;

    }
}

