/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.phoenix.mapreduce.PhoenixMultiViewInputSplit;
import org.apache.phoenix.mapreduce.util.MultiViewSplitStrategy;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

public class DefaultMultiViewSplitStrategy
implements MultiViewSplitStrategy {
    @Override
    public List<InputSplit> generateSplits(List<ViewInfoWritable> views, Configuration configuration) {
        int numViewsInSplit = PhoenixConfigurationUtil.getMultiViewSplitSize(configuration);
        if (numViewsInSplit < 1) {
            numViewsInSplit = 10;
        }
        int numberOfMappers = this.getNumberOfMappers(views.size(), numViewsInSplit);
        ArrayList pSplits = Lists.newArrayListWithExpectedSize((int)numberOfMappers);
        for (int i = 0; i < numberOfMappers; ++i) {
            pSplits.add(new PhoenixMultiViewInputSplit(views.subList(i * numViewsInSplit, this.getUpperBound(numViewsInSplit, i, views.size()))));
        }
        return pSplits;
    }

    public int getNumberOfMappers(int viewSize, int numViewsInSplit) {
        int numberOfMappers = viewSize / numViewsInSplit;
        if (viewSize % numViewsInSplit > 0) {
            ++numberOfMappers;
        }
        return numberOfMappers;
    }

    public int getUpperBound(int numViewsInSplit, int i, int viewSize) {
        int upper = (i + 1) * numViewsInSplit;
        if (viewSize < upper) {
            upper = viewSize;
        }
        return upper;
    }
}

