/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexToolUtil;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexImportDirectReducer
extends Reducer<ImmutableBytesWritable, IntWritable, NullWritable, NullWritable> {
    private AtomicBoolean calledOnce = new AtomicBoolean(false);
    private IndexVerificationResultRepository resultRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixIndexImportDirectReducer.class);
    private String indexTableName;
    private byte[] indexTableNameBytes;

    private void updateCounters(IndexTool.IndexVerifyType verifyType, Reducer.Context context) throws IOException {
        Configuration configuration = context.getConfiguration();
        try (Connection connection = ConnectionUtil.getInputConnection(configuration);){
            long ts = Long.parseLong(configuration.get("phoenix.mr.currentscn.value"));
            IndexToolVerificationResult verificationResult = this.resultRepository.getVerificationResult(connection, ts, this.indexTableNameBytes);
            context.getCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).setValue(verificationResult.getScannedDataRowCount());
            context.getCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).setValue(verificationResult.getRebuiltIndexRowCount());
            if (verifyType == IndexTool.IndexVerifyType.ONLY || verifyType == IndexTool.IndexVerifyType.BEFORE || verifyType == IndexTool.IndexVerifyType.BOTH) {
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildValidIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildExpiredIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildMissingIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildInvalidIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildBeyondMaxLookBackMissingIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildBeyondMaxLookBackInvalidIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS).setValue(verificationResult.getBeforeIndexHasExtraCellsCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS).setValue(verificationResult.getBeforeIndexHasMissingCellsCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildUnverifiedIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildOldIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRebuildUnknownIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRepairExtraVerifiedIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT).setValue(verificationResult.getBeforeRepairExtraUnverifiedIndexRowCount());
            }
            if (verifyType == IndexTool.IndexVerifyType.BOTH || verifyType == IndexTool.IndexVerifyType.AFTER) {
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_VALID_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRebuildValidIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRebuildExpiredIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_MISSING_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRebuildMissingIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRebuildInvalidIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRebuildBeyondMaxLookBackMissingIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRebuildBeyondMaxLookBackInvalidIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS).setValue(verificationResult.getAfterIndexHasExtraCellsCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS).setValue(verificationResult.getAfterIndexHasMissingCellsCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRepairExtraVerifiedIndexRowCount());
                context.getCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT).setValue(verificationResult.getAfterRepairExtraUnverifiedIndexRowCount());
            }
            if (verificationResult.isVerificationFailed()) {
                throw new IOException("Index verification failed! " + verificationResult);
            }
        }
        catch (Exception e) {
            throw new IOException("Fail to get index verification result", e);
        }
    }

    protected void setup(Reducer.Context context) throws IOException {
        this.resultRepository = new IndexVerificationResultRepository();
        this.indexTableName = PhoenixConfigurationUtil.getPhysicalTableName(context.getConfiguration());
        this.indexTableNameBytes = Bytes.toBytes((String)this.indexTableName);
    }

    protected void reduce(ImmutableBytesWritable arg0, Iterable<IntWritable> arg1, Reducer.Context context) throws IOException, InterruptedException {
        if (!this.calledOnce.compareAndSet(false, true)) {
            return;
        }
        IndexTool.IndexVerifyType verifyType = PhoenixConfigurationUtil.getIndexVerifyType(context.getConfiguration());
        if (verifyType != IndexTool.IndexVerifyType.NONE) {
            this.updateCounters(verifyType, context);
        }
        if (verifyType != IndexTool.IndexVerifyType.ONLY) {
            try {
                IndexToolUtil.updateIndexState(context.getConfiguration(), PIndexState.ACTIVE);
            }
            catch (SQLException e) {
                LOGGER.error(" Failed to update the status to Active", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        try {
            this.updateTasksTable(context);
            this.resultRepository.close();
        }
        catch (SQLException e) {
            LOGGER.error(" Failed to update the tasks table");
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTasksTable(Reducer.Context context) throws SQLException, IOException {
        Properties overrideProps = new Properties();
        try (Connection connection = ConnectionUtil.getOutputConnection(context.getConfiguration(), overrideProps);){
            String fullTableName = PhoenixConfigurationUtil.getInputTableName(context.getConfiguration());
            String tenantId = context.getConfiguration().get("phoenix.mapreduce.tenantid", null);
            String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
            String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
            String indexName = PhoenixConfigurationUtil.getDisableIndexes(context.getConfiguration());
            List<Task.TaskRecord> taskRecords = Task.queryTaskTable(connection, null, schemaName, tableName, PTable.TaskType.INDEX_REBUILD, tenantId, indexName);
            if (taskRecords != null && taskRecords.size() > 0) {
                for (Task.TaskRecord taskRecord : taskRecords) {
                    TaskRegionObserver.SelfHealingTask.setEndTaskStatus(connection.unwrap(PhoenixConnection.class), taskRecord, PTable.TaskStatus.COMPLETED.toString());
                }
            }
        }
    }
}

