/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.util.Arrays;
import java.util.Objects;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;

public class IndexVerificationOutputRow {
    public static final String SCAN_MAX_TIMESTAMP = "ScanMaxTimestamp: ";
    private String dataTableName;
    private String indexTableName;
    private Long scanMaxTimestamp;
    private byte[] dataTableRowKey;
    private byte[] indexTableRowKey;
    private Long dataTableRowTimestamp;
    private Long indexTableRowTimestamp;
    private String errorMessage;
    private byte[] expectedValue;
    private byte[] actualValue;
    private byte[] phaseValue;
    private IndexVerificationOutputRepository.IndexVerificationErrorType errorType;

    private IndexVerificationOutputRow(String dataTableName, String indexTableName, byte[] dataTableRowKey, Long scanMaxTimestamp, byte[] indexTableRowKey, long dataTableRowTimestamp, long indexTableRowTimestamp, String errorMessage, byte[] expectedValue, byte[] actualValue, byte[] phaseValue, IndexVerificationOutputRepository.IndexVerificationErrorType errorType) {
        this.dataTableName = dataTableName;
        this.indexTableName = indexTableName;
        this.scanMaxTimestamp = scanMaxTimestamp;
        this.dataTableRowKey = dataTableRowKey;
        this.indexTableRowKey = indexTableRowKey;
        this.dataTableRowTimestamp = dataTableRowTimestamp;
        this.indexTableRowTimestamp = indexTableRowTimestamp;
        this.errorMessage = errorMessage;
        this.expectedValue = expectedValue;
        this.actualValue = actualValue;
        this.phaseValue = phaseValue;
        this.errorType = errorType;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public String getIndexTableName() {
        return this.indexTableName;
    }

    public Long getScanMaxTimestamp() {
        return this.scanMaxTimestamp;
    }

    public byte[] getIndexTableRowKey() {
        return this.indexTableRowKey;
    }

    public long getIndexTableRowTimestamp() {
        return this.indexTableRowTimestamp;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public byte[] getExpectedValue() {
        return this.expectedValue;
    }

    public byte[] getActualValue() {
        return this.actualValue;
    }

    public byte[] getPhaseValue() {
        return this.phaseValue;
    }

    public byte[] getDataTableRowKey() {
        return this.dataTableRowKey;
    }

    public Long getDataTableRowTimestamp() {
        return this.dataTableRowTimestamp;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IndexVerificationOutputRow)) {
            return false;
        }
        IndexVerificationOutputRow otherRow = (IndexVerificationOutputRow)o;
        return Objects.equals(this.dataTableName, otherRow.getDataTableName()) && Objects.equals(this.indexTableName, otherRow.getIndexTableName()) && Objects.equals(this.scanMaxTimestamp, otherRow.getScanMaxTimestamp()) && Arrays.equals(this.dataTableRowKey, otherRow.getDataTableRowKey()) && Arrays.equals(this.indexTableRowKey, otherRow.getIndexTableRowKey()) && Objects.equals(this.dataTableRowTimestamp, otherRow.getDataTableRowTimestamp()) && Objects.equals(this.indexTableRowTimestamp, otherRow.getIndexTableRowTimestamp()) && Objects.equals(this.errorMessage, otherRow.getErrorMessage()) && Arrays.equals(this.expectedValue, otherRow.getExpectedValue()) && Arrays.equals(this.actualValue, otherRow.getActualValue()) && Arrays.equals(this.phaseValue, otherRow.getPhaseValue()) && Objects.equals((Object)this.errorType, (Object)otherRow.getErrorType());
    }

    public int hashCode() {
        return Objects.hashCode(this.scanMaxTimestamp) ^ Objects.hashCode(this.indexTableName) ^ Arrays.hashCode(this.dataTableRowKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DTName: ").append(this.dataTableName).append(",");
        sb.append("ITName: ").append(this.indexTableName).append(",");
        sb.append(SCAN_MAX_TIMESTAMP).append(": ").append(this.scanMaxTimestamp).append(",");
        sb.append("DTRowKey: ").append(Bytes.toString((byte[])this.dataTableRowKey)).append(",");
        sb.append("ITRowKey: ").append(Bytes.toString((byte[])this.indexTableRowKey)).append(",");
        sb.append("DTTS: ").append(this.dataTableRowTimestamp).append(",");
        sb.append("ITTS: ").append(this.indexTableRowTimestamp).append(",");
        sb.append("Error: ").append(this.errorMessage).append(",");
        sb.append("ExpectedValue: ").append(Bytes.toString((byte[])this.expectedValue)).append(",");
        sb.append("ActualValue: ").append(Bytes.toString((byte[])this.actualValue)).append(",");
        sb.append("Phase: ").append(Bytes.toString((byte[])this.phaseValue));
        sb.append("ErrorType: ").append(Objects.toString((Object)this.errorType));
        return sb.toString();
    }

    public IndexVerificationOutputRepository.IndexVerificationErrorType getErrorType() {
        return this.errorType;
    }

    public static class IndexVerificationOutputRowBuilder {
        private String dataTableName;
        private String indexTableName;
        private Long scanMaxTimestamp;
        private byte[] dataTableRowKey;
        private byte[] indexTableRowKey;
        private long dataTableRowTimestamp;
        private long indexTableRowTimestamp;
        private String errorMessage;
        private byte[] expectedValue;
        private byte[] actualValue;
        private byte[] phaseValue;
        private IndexVerificationOutputRepository.IndexVerificationErrorType errorType;

        public IndexVerificationOutputRowBuilder setDataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
            return this;
        }

        public IndexVerificationOutputRowBuilder setIndexTableName(String indexTableName) {
            this.indexTableName = indexTableName;
            return this;
        }

        public IndexVerificationOutputRowBuilder setScanMaxTimestamp(Long scanMaxTimestamp) {
            this.scanMaxTimestamp = scanMaxTimestamp;
            return this;
        }

        public IndexVerificationOutputRowBuilder setIndexTableRowKey(byte[] indexTableRowKey) {
            this.indexTableRowKey = indexTableRowKey;
            return this;
        }

        public IndexVerificationOutputRowBuilder setDataTableRowKey(byte[] dataTableRowKey) {
            this.dataTableRowKey = dataTableRowKey;
            return this;
        }

        public IndexVerificationOutputRowBuilder setDataTableRowTimestamp(long dataTableRowTimestamp) {
            this.dataTableRowTimestamp = dataTableRowTimestamp;
            return this;
        }

        public IndexVerificationOutputRowBuilder setIndexTableRowTimestamp(long indexTableRowTimestamp) {
            this.indexTableRowTimestamp = indexTableRowTimestamp;
            return this;
        }

        public IndexVerificationOutputRowBuilder setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public IndexVerificationOutputRowBuilder setExpectedValue(byte[] expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public IndexVerificationOutputRowBuilder setActualValue(byte[] actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public IndexVerificationOutputRowBuilder setPhaseValue(byte[] phaseValue) {
            this.phaseValue = phaseValue;
            return this;
        }

        public IndexVerificationOutputRowBuilder setErrorType(IndexVerificationOutputRepository.IndexVerificationErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public IndexVerificationOutputRow build() {
            return new IndexVerificationOutputRow(this.dataTableName, this.indexTableName, this.dataTableRowKey, this.scanMaxTimestamp, this.indexTableRowKey, this.dataTableRowTimestamp, this.indexTableRowTimestamp, this.errorMessage, this.expectedValue, this.actualValue, this.phaseValue, this.errorType);
        }
    }
}

