/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;

public enum TimeUnit {
    DAY("day"),
    HOUR("hour"),
    MINUTE("minute"),
    SECOND("second"),
    MILLISECOND("millisecond"),
    WEEK("week"),
    MONTH("month"),
    YEAR("year");

    private String value;
    public static final String VALID_VALUES;

    private TimeUnit(String value) {
        this.value = value;
    }

    public static TimeUnit getTimeUnit(String timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("No time unit value specified. Only a time unit value that belongs to one of these : " + VALID_VALUES + " is allowed.");
        }
        for (TimeUnit tu : TimeUnit.values()) {
            if (!timeUnit.equalsIgnoreCase(tu.value)) continue;
            return tu;
        }
        throw new IllegalArgumentException("Invalid value of time unit " + timeUnit + ". Only a time unit value that belongs to one of these : " + VALID_VALUES + " is allowed.");
    }

    static {
        VALID_VALUES = Joiner.on((String)", ").join((Object[])TimeUnit.values());
    }
}

