/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;

public class DefaultValueExpression
extends ScalarFunction {
    public static final String NAME = "DEFAULT";

    public DefaultValueExpression() {
    }

    public DefaultValueExpression(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression secondChild;
        Expression firstChild = (Expression)this.children.get(0);
        boolean evaluated = firstChild instanceof SingleCellColumnExpression ? ((SingleCellColumnExpression)firstChild).evaluateUnsafe(tuple, ptr) : (firstChild instanceof KeyValueColumnExpression ? ((KeyValueColumnExpression)firstChild).evaluateUnsafe(tuple, ptr) : ((Expression)this.children.get(0)).evaluate(tuple, ptr));
        if (evaluated) {
            return true;
        }
        if (tuple.isImmutable() && (secondChild = (Expression)this.children.get(1)).evaluate(tuple, ptr)) {
            this.getDataType().coerceBytes(ptr, null, secondChild.getDataType(), secondChild.getMaxLength(), secondChild.getScale(), secondChild.getSortOrder(), this.getMaxLength(), this.getScale(), this.getSortOrder());
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public Integer getMaxLength() {
        return ((Expression)this.children.get(0)).getMaxLength();
    }

    @Override
    public boolean isNullable() {
        return ((Expression)this.children.get(0)).isNullable() && ((Expression)this.children.get(1)).isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }
}

