/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;

public class DoubleSumAggregator
extends BaseAggregator {
    private double sum = 0.0;
    private byte[] buffer;

    public DoubleSumAggregator(SortOrder sortOrder, ImmutableBytesWritable ptr) {
        super(sortOrder);
        if (ptr != null) {
            this.initBuffer();
            this.sum = PDouble.INSTANCE.getCodec().decodeDouble(ptr, sortOrder);
        }
    }

    protected PDataType getInputDataType() {
        return PDouble.INSTANCE;
    }

    private void initBuffer() {
        this.buffer = new byte[this.getDataType().getByteSize().intValue()];
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        double value = this.getInputDataType().getCodec().decodeDouble(ptr, this.sortOrder);
        this.sum += value;
        if (this.buffer == null) {
            this.initBuffer();
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.buffer == null) {
            if (this.isNullable()) {
                return false;
            }
            this.initBuffer();
        }
        this.getDataType().getCodec().encodeDouble(this.sum, this.buffer, 0);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDouble.INSTANCE;
    }

    public String toString() {
        return "SUM [sum=" + this.sum + "]";
    }

    @Override
    public void reset() {
        this.sum = 0.0;
        this.buffer = null;
        super.reset();
    }

    @Override
    public int getSize() {
        return super.getSize() + 8 + 24 + this.getDataType().getByteSize();
    }
}

