/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UncoveredIndexRegionScanner
extends BaseRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredIndexRegionScanner.class);
    protected State state = State.INITIAL;
    protected final byte[][] viewConstants;
    protected final RegionCoprocessorEnvironment env;
    protected byte[][] regionEndKeys;
    protected final int pageSizeInRows;
    protected final Scan scan;
    protected final Scan dataTableScan;
    protected final RegionScanner innerScanner;
    protected final Region region;
    protected final IndexMaintainer indexMaintainer;
    protected final TupleProjector tupleProjector;
    protected final ImmutableBytesWritable ptr;
    protected String exceptionMessage;
    protected List<List<Cell>> indexRows = null;
    protected Map<ImmutableBytesPtr, Result> dataRows = null;
    protected Iterator<List<Cell>> indexRowIterator = null;
    protected Map<byte[], byte[]> indexToDataRowKeyMap = null;
    protected int indexRowCount = 0;
    protected final long pageSizeMs;
    protected byte[] lastIndexRowKey = null;

    public UncoveredIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, Scan dataTableScan, TupleProjector tupleProjector, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr, long pageSizeMs) {
        super(innerScanner);
        Configuration config = env.getConfiguration();
        byte[] pageSizeFromScan = scan.getAttribute("_IndexPageRows");
        this.pageSizeInRows = pageSizeFromScan != null ? (int)Bytes.toLong((byte[])pageSizeFromScan) : (int)config.getLong("phoenix.index.page_size_in_rows", 32768L);
        this.indexMaintainer = indexMaintainer;
        this.viewConstants = viewConstants;
        this.scan = scan;
        this.dataTableScan = dataTableScan;
        this.innerScanner = innerScanner;
        this.region = region;
        this.env = env;
        this.ptr = ptr;
        this.tupleProjector = tupleProjector;
        this.pageSizeMs = pageSizeMs;
    }

    @Override
    public long getMvccReadPoint() {
        return this.innerScanner.getMvccReadPoint();
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.innerScanner.close();
    }

    @Override
    public long getMaxResultSize() {
        return this.innerScanner.getMaxResultSize();
    }

    @Override
    public int getBatch() {
        return this.innerScanner.getBatch();
    }

    protected abstract void scanDataTableRows(long var1) throws IOException;

    protected Scan prepareDataTableScan(Collection<byte[]> dataRowKeys) throws IOException {
        ArrayList<KeyRange> keys = new ArrayList<KeyRange>(dataRowKeys.size());
        for (byte[] dataRowKey : dataRowKeys) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(dataRowKey));
        }
        ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
        Scan dataScan = new Scan(this.dataTableScan);
        dataScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        scanRanges.initializeScan(dataScan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        dataScan.setFilter((Filter)new SkipScanFilter(skipScanFilter, false));
        this.scan.setAttribute("_ServerPageSizeMs", Bytes.toBytes((long)this.pageSizeMs));
        return dataScan;
    }

    protected boolean scanIndexTableRows(List<Cell> result, long startTime, byte[] actualStartKey, int offset) throws IOException {
        boolean hasMore = false;
        if (actualStartKey != null) {
            do {
                hasMore = this.innerScanner.nextRaw(result);
                if (result.isEmpty()) {
                    return hasMore;
                }
                if (ScanUtil.isDummy(result)) {
                    return true;
                }
                Cell firstCell = result.get(0);
                if (Bytes.compareTo((byte[])firstCell.getRowArray(), (int)firstCell.getRowOffset(), (int)firstCell.getRowLength(), (byte[])actualStartKey, (int)0, (int)actualStartKey.length) >= 0) break;
                result.clear();
                if (EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
                byte[] rowKey = CellUtil.cloneRow((Cell)firstCell);
                ScanUtil.getDummyResult(rowKey, result);
                return true;
            } while (hasMore);
        }
        do {
            ArrayList<Cell> row = new ArrayList<Cell>();
            if (result.isEmpty()) {
                hasMore = this.innerScanner.nextRaw(row);
            } else {
                row.addAll(result);
                result.clear();
            }
            if (row.isEmpty()) continue;
            if (ScanUtil.isDummy(row)) {
                result.addAll(row);
                return true;
            }
            Cell firstCell = (Cell)row.get(0);
            byte[] indexRowKey = firstCell.getRowArray();
            this.ptr.set(indexRowKey, firstCell.getRowOffset() + offset, firstCell.getRowLength() - offset);
            this.lastIndexRowKey = this.ptr.copyBytes();
            this.indexToDataRowKeyMap.put(offset == 0 ? this.lastIndexRowKey : CellUtil.cloneRow((Cell)firstCell), this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(this.lastIndexRowKey), this.viewConstants));
            this.indexRows.add(row);
            ++this.indexRowCount;
            if (!hasMore || EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
            ScanUtil.getDummyResult(this.lastIndexRowKey, result);
            return true;
        } while (hasMore && this.indexRowCount < this.pageSizeInRows);
        return hasMore;
    }

    protected boolean scanIndexTableRows(List<Cell> result, long startTime) throws IOException {
        return this.scanIndexTableRows(result, startTime, null, 0);
    }

    private boolean getNextCoveredIndexRow(List<Cell> result) {
        if (this.indexRowIterator.hasNext()) {
            List<Cell> indexRow = this.indexRowIterator.next();
            result.addAll(indexRow);
            try {
                Result dataRow = this.dataRows.get((Object)new ImmutableBytesPtr(this.indexToDataRowKeyMap.get(CellUtil.cloneRow((Cell)indexRow.get(0)))));
                if (dataRow != null) {
                    IndexUtil.addTupleAsOneCell(result, new ResultTuple(dataRow), this.tupleProjector, this.ptr);
                }
            }
            catch (Throwable e) {
                LOGGER.error("Exception in UncoveredIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
                throw e;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean next(List<Cell> result) throws IOException {
        block13: {
            block12: {
                startTime = EnvironmentEdgeManager.currentTimeMillis();
                this.region.startRegionOperation();
                var5_3 = this.innerScanner;
                // MONITORENTER : var5_3
                if (this.state == State.READY && !this.indexRowIterator.hasNext()) {
                    this.state = State.INITIAL;
                }
                if (this.state == State.INITIAL) {
                    this.indexRowCount = 0;
                    this.indexRows = new ArrayList<List<Cell>>();
                    this.dataRows = Maps.newConcurrentMap();
                    this.indexToDataRowKeyMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
                    this.state = State.SCANNING_INDEX;
                }
                if (this.state != State.SCANNING_INDEX) ** GOTO lbl24
                hasMore = this.scanIndexTableRows(result, startTime);
                if (!ScanUtil.isDummy(result)) break block12;
                var6_6 = hasMore;
                // MONITOREXIT : var5_3
                this.region.closeRegionOperation();
                return var6_6;
            }
            this.state = State.SCANNING_DATA;
lbl24:
            // 2 sources

            if (this.state == State.SCANNING_DATA) {
                this.scanDataTableRows(startTime);
                this.indexRowIterator = this.indexRows.iterator();
            }
            if (this.state != State.READY) break block13;
            var6_7 = this.getNextCoveredIndexRow(result);
            // MONITOREXIT : var5_3
            {
                catch (Throwable e) {
                    UncoveredIndexRegionScanner.LOGGER.error("Exception in UncoveredIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
                    throw e;
                }
            }
            this.region.closeRegionOperation();
            return var6_7;
        }
        ScanUtil.getDummyResult(this.lastIndexRowKey, result);
        var6_8 = true;
        // MONITOREXIT : var5_3
        this.region.closeRegionOperation();
        return var6_8;
        catch (Throwable var8_9) {
            this.region.closeRegionOperation();
            throw var8_9;
        }
    }

    protected static enum State {
        INITIAL,
        SCANNING_INDEX,
        SCANNING_DATA,
        SCANNING_DATA_INTERRUPTED,
        READY;

    }
}

