/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.IndexRepairRegionScanner;
import org.apache.phoenix.coprocessor.UncoveredIndexRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncoveredGlobalIndexRegionScanner
extends UncoveredIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredGlobalIndexRegionScanner.class);
    public static final String NUM_CONCURRENT_INDEX_THREADS_CONF_KEY = "index.threads.max";
    public static final int DEFAULT_CONCURRENT_INDEX_THREADS = 16;
    public static final String INDEX_ROW_COUNTS_PER_TASK_CONF_KEY = "index.row.count.per.task";
    public static final int DEFAULT_INDEX_ROW_COUNTS_PER_TASK = 2048;
    protected byte[][] regionEndKeys;
    protected final Table dataHTable;
    protected final int rowCountPerTask;
    protected final TaskRunner pool;
    protected String exceptionMessage;
    protected final HTableFactory hTableFactory;

    public UncoveredGlobalIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, Scan dataTableScan, TupleProjector tupleProjector, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr, long pageSizeMs) throws IOException {
        super(innerScanner, region, scan, env, dataTableScan, tupleProjector, indexMaintainer, viewConstants, ptr, pageSizeMs);
        Configuration config = env.getConfiguration();
        this.hTableFactory = IndexWriterUtils.getDefaultDelegateHTableFactory(env);
        this.rowCountPerTask = config.getInt(INDEX_ROW_COUNTS_PER_TASK_CONF_KEY, 2048);
        this.pool = new WaitForCompletionTaskRunner(ThreadPoolManager.getExecutor(new ThreadPoolBuilder("Uncovered Global Index", env.getConfiguration()).setMaxThread(NUM_CONCURRENT_INDEX_THREADS_CONF_KEY, 16).setCoreTimeout("index.writer.threads.keepalivetime"), env));
        byte[] dataTableName = scan.getAttribute("_PhysicalDataTableName");
        this.dataHTable = this.hTableFactory.getTable(new ImmutableBytesPtr(dataTableName));
        try (Connection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(env.getConfiguration());){
            this.regionEndKeys = connection.getRegionLocator(this.dataHTable.getName()).getEndKeys();
        }
    }

    @Override
    public void close() throws IOException {
        this.innerScanner.close();
        this.hTableFactory.shutdown();
        if (this.dataHTable != null) {
            this.dataHTable.close();
        }
        this.pool.stop("UncoveredGlobalIndexRegionScanner is closing");
    }

    protected void scanDataRows(Collection<byte[]> dataRowKeys, long startTime) throws IOException {
        Scan dataScan = this.prepareDataTableScan(dataRowKeys);
        try (ResultScanner resultScanner = this.dataHTable.getScanner(dataScan);){
            Result result = resultScanner.next();
            while (result != null) {
                if (ScanUtil.isDummy(result)) {
                    this.state = UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED;
                    break;
                }
                this.dataRows.put(new ImmutableBytesPtr(result.getRow()), result);
                if (EnvironmentEdgeManager.currentTimeMillis() - startTime >= this.pageSizeMs) {
                    this.state = UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED;
                    break;
                }
                result = resultScanner.next();
            }
            if (this.state == UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED) {
                LOGGER.info("One of the scan tasks in UncoveredGlobalIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString() + " could not complete on time (in " + this.pageSizeMs + " ms) and will be resubmitted");
            }
        }
        catch (Throwable t) {
            this.exceptionMessage = "scanDataRows fails for at least one task";
            ServerUtil.throwIOException(this.dataHTable.getName().toString(), t);
        }
    }

    private void addTasksForScanningDataTableRowsInParallel(TaskBatch<Boolean> tasks, final Set<byte[]> dataRowKeys, final long startTime) {
        tasks.add(new Task<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (Thread.currentThread().isInterrupted()) {
                    UncoveredGlobalIndexRegionScanner.this.exceptionMessage = "Pool closed, not retrieving data table rows for " + UncoveredGlobalIndexRegionScanner.this.region.getRegionInfo().getRegionNameAsString();
                    throw new IOException(UncoveredGlobalIndexRegionScanner.this.exceptionMessage);
                }
                UncoveredGlobalIndexRegionScanner.this.scanDataRows(dataRowKeys, startTime);
                return Boolean.TRUE;
            }
        });
    }

    protected void submitTasks(TaskBatch<Boolean> tasks) throws IOException {
        Pair<List<Boolean>, List<Future<Boolean>>> resultsAndFutures = null;
        try {
            LOGGER.debug("Waiting on index tasks to complete...");
            resultsAndFutures = this.pool.submitUninterruptible(tasks);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Should not fail on the results while using a WaitForCompletionTaskRunner", e);
        }
        catch (EarlyExitFailure e) {
            throw new RuntimeException("Stopped while waiting for batch, quitting!", e);
        }
        int index = 0;
        for (Boolean result : (List)resultsAndFutures.getFirst()) {
            if (result == null) {
                Throwable cause = ServerUtil.getExceptionFromFailedFuture((Future)((List)resultsAndFutures.getSecond()).get(index));
                throw new IOException(this.exceptionMessage == null ? "" : this.exceptionMessage, cause);
            }
            ++index;
        }
    }

    @Override
    protected void scanDataTableRows(long startTime) throws IOException {
        if (this.indexToDataRowKeyMap.size() == 0) {
            this.state = UncoveredIndexRegionScanner.State.READY;
            return;
        }
        TreeSet<byte[]> dataRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (byte[] dataRowKey : this.indexToDataRowKeyMap.values()) {
            dataRowKeys.add(dataRowKey);
        }
        List<Set<byte[]>> setList = IndexRepairRegionScanner.getPerTaskDataRowKeys(dataRowKeys, this.regionEndKeys, this.rowCountPerTask);
        int taskCount = setList.size();
        TaskBatch<Boolean> tasks = new TaskBatch<Boolean>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            this.addTasksForScanningDataTableRowsInParallel(tasks, setList.get(i), startTime);
        }
        this.submitTasks(tasks);
        this.state = this.state == UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED ? UncoveredIndexRegionScanner.State.SCANNING_DATA : UncoveredIndexRegionScanner.State.READY;
    }
}

