/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class WhereOptimizer {
    private static final List<KeyRange> EVERYTHING_RANGES = Collections.singletonList(KeyRange.EVERYTHING_RANGE);
    private static final List<KeyRange> SALT_PLACEHOLDER = Collections.singletonList(PChar.INSTANCE.getKeyRange(QueryConstants.SEPARATOR_BYTE_ARRAY));

    private WhereOptimizer() {
    }

    public static Expression pushKeyExpressionsToScan(StatementContext context, Set<HintNode.Hint> hints, Expression whereClause) throws SQLException {
        return WhereOptimizer.pushKeyExpressionsToScan(context, hints, whereClause, null, (Optional<byte[]>)Optional.absent());
    }

    public static Expression pushKeyExpressionsToScan(StatementContext context, Set<HintNode.Hint> hints, Expression whereClause, Set<Expression> extractNodes, Optional<byte[]> minOffset) throws SQLException {
        PName tenantId = context.getConnection().getTenantId();
        byte[] tenantIdBytes = null;
        PTable table = context.getCurrentTable().getTable();
        Integer nBuckets = table.getBucketNum();
        boolean isSalted = nBuckets != null;
        RowKeySchema schema = table.getRowKeySchema();
        boolean isMultiTenant = tenantId != null && table.isMultiTenant();
        boolean isSharedIndex = table.getViewIndexId() != null;
        ImmutableBytesWritable ptr = context.getTempPtr();
        int maxInListSkipScanSize = context.getConnection().getQueryServices().getConfiguration().getInt("phoenix.max.inList.skipScan.size", 50000);
        if (isMultiTenant) {
            tenantIdBytes = ScanUtil.getTenantIdBytes(schema, isSalted, tenantId, isSharedIndex);
        }
        if (!(whereClause != null || tenantId != null && table.isMultiTenant() || table.getViewIndexId() != null || minOffset.isPresent())) {
            context.setScanRanges(ScanRanges.EVERYTHING);
            return whereClause;
        }
        if (LiteralExpression.isBooleanFalseOrNull(whereClause)) {
            context.setScanRanges(ScanRanges.NOTHING);
            return null;
        }
        KeyExpressionVisitor visitor = new KeyExpressionVisitor(context, table);
        KeyExpressionVisitor.KeySlots keySlots = null;
        if (whereClause != null) {
            keySlots = whereClause.accept(visitor);
            if (!(keySlots != null || tenantId != null && table.isMultiTenant() || table.getViewIndexId() != null || minOffset.isPresent())) {
                context.setScanRanges(ScanRanges.EVERYTHING);
                return whereClause;
            }
            if (keySlots == KeyExpressionVisitor.EMPTY_KEY_SLOTS) {
                context.setScanRanges(ScanRanges.NOTHING);
                return null;
            }
        }
        if (keySlots == null) {
            keySlots = KeyExpressionVisitor.EMPTY_KEY_SLOTS;
        }
        if (extractNodes == null) {
            extractNodes = new HashSet<Expression>(table.getPKColumns().size());
        }
        int pkPos = 0;
        int nPKColumns = table.getPKColumns().size();
        int[] slotSpanArray = new int[nPKColumns];
        ArrayList cnf = Lists.newArrayListWithExpectedSize((int)schema.getMaxFields());
        boolean hasViewIndex = table.getViewIndexId() != null;
        Iterator<KeyExpressionVisitor.KeySlot> iterator = keySlots.getSlots().iterator();
        if (isSalted) {
            cnf.add(SALT_PLACEHOLDER);
            ++pkPos;
        }
        if (hasViewIndex) {
            byte[] viewIndexBytes = table.getviewIndexIdType().toBytes(table.getViewIndexId());
            KeyRange indexIdKeyRange = KeyRange.getKeyRange(viewIndexBytes);
            cnf.add(Collections.singletonList(indexIdKeyRange));
            ++pkPos;
        }
        if (isMultiTenant) {
            KeyRange tenantIdKeyRange = KeyRange.getKeyRange(tenantIdBytes);
            cnf.add(Collections.singletonList(tenantIdKeyRange));
            ++pkPos;
        }
        boolean forcedSkipScan = hints.contains((Object)HintNode.Hint.SKIP_SCAN);
        boolean forcedRangeScan = hints.contains((Object)HintNode.Hint.RANGE_SCAN);
        boolean hasUnboundedRange = false;
        boolean hasMultiRanges = false;
        boolean hasRangeKey = false;
        boolean useSkipScan = false;
        boolean checkMaxSkipScanCardinality = false;
        BigInteger inListSkipScanCardinality = BigInteger.ONE;
        while (iterator.hasNext()) {
            KeyExpressionVisitor.KeySlot slot = iterator.next();
            if (slot == null || slot.getKeyRanges().isEmpty() || slot.getPKPosition() < pkPos) continue;
            if (slot.getPKPosition() != pkPos) {
                hasRangeKey = true;
                hasUnboundedRange = true;
                for (int i = pkPos; i < slot.getPKPosition(); ++i) {
                    cnf.add(Collections.singletonList(KeyRange.EVERYTHING_RANGE));
                }
            }
            KeyPart keyPart = slot.getKeyPart();
            List<KeyRange> keyRanges = slot.getKeyRanges();
            SortOrder prevSortOrder = null;
            int slotOffset = 0;
            int clipLeftSpan = 0;
            boolean onlySplittedRVCLeftValid = false;
            boolean stopExtracting = false;
            boolean areAllSingleKey = KeyRange.areAllSingleKey(keyRanges);
            boolean isInList = false;
            int cnfStartPos = cnf.size();
            if (keyPart.getExtractNodes() != null && keyPart.getExtractNodes().size() > 0 && keyPart.getExtractNodes().iterator().next() instanceof InListExpression) {
                isInList = true;
            }
            do {
                SortOrder sortOrder = schema.getField(slot.getPKPosition() + slotOffset).getSortOrder();
                if (prevSortOrder == null) {
                    prevSortOrder = sortOrder;
                } else if (prevSortOrder != sortOrder || prevSortOrder == SortOrder.DESC && isInList) {
                    List<KeyRange> leftRanges = WhereOptimizer.clipLeft(schema, slot.getPKPosition() + slotOffset - clipLeftSpan, clipLeftSpan, keyRanges, ptr);
                    keyRanges = WhereOptimizer.clipRight(schema, slot.getPKPosition() + slotOffset - 1, keyRanges, leftRanges, ptr);
                    leftRanges = KeyRange.coalesce(leftRanges);
                    keyRanges = KeyRange.coalesce(keyRanges);
                    if (prevSortOrder == SortOrder.DESC) {
                        leftRanges = WhereOptimizer.invertKeyRanges(leftRanges);
                    }
                    slotSpanArray[cnf.size()] = clipLeftSpan - 1;
                    cnf.add(leftRanges);
                    pkPos = slot.getPKPosition() + slotOffset;
                    clipLeftSpan = 0;
                    prevSortOrder = sortOrder;
                    checkMaxSkipScanCardinality |= isInList;
                    stopExtracting = true;
                    if (!areAllSingleKey) {
                        onlySplittedRVCLeftValid = true;
                        break;
                    }
                }
                ++clipLeftSpan;
            } while (++slotOffset < slot.getPKSpan());
            if (onlySplittedRVCLeftValid) {
                keyRanges = (List<KeyRange>)cnf.get(cnf.size() - 1);
            } else {
                if (schema.getField(slot.getPKPosition() + slotOffset - 1).getSortOrder() == SortOrder.DESC) {
                    keyRanges = WhereOptimizer.invertKeyRanges(keyRanges);
                }
                pkPos = slot.getPKPosition() + slotOffset;
                slotSpanArray[cnf.size()] = clipLeftSpan - 1;
                cnf.add(keyRanges);
            }
            if (checkMaxSkipScanCardinality) {
                for (int i = cnfStartPos; i < cnf.size(); ++i) {
                    inListSkipScanCardinality = inListSkipScanCardinality.multiply(BigInteger.valueOf(((List)cnf.get(i)).size()));
                }
                if (maxInListSkipScanSize > 0) {
                    forcedRangeScan = inListSkipScanCardinality.compareTo(BigInteger.valueOf(maxInListSkipScanSize)) == 1;
                }
                checkMaxSkipScanCardinality = false;
            }
            stopExtracting |= !(useSkipScan |= !(hasUnboundedRange && !forcedSkipScan || forcedRangeScan || !hasRangeKey && !hasMultiRanges)) && (hasUnboundedRange || hasRangeKey || (hasMultiRanges |= keyRanges.size() > 1));
            for (int i = 0; !(hasUnboundedRange && hasRangeKey || i >= keyRanges.size()); ++i) {
                KeyRange range = keyRanges.get(i);
                if (range.isUnbound()) {
                    hasRangeKey = true;
                    hasUnboundedRange = true;
                    continue;
                }
                if (range.isSingleKey()) continue;
                hasRangeKey = true;
            }
            if (stopExtracting) continue;
            Set<Expression> nodesToExtract = keyPart.getExtractNodes();
            extractNodes.addAll(nodesToExtract);
        }
        slotSpanArray = Arrays.copyOf(slotSpanArray, cnf.size());
        ScanRanges scanRanges = ScanRanges.create(schema, cnf, slotSpanArray, nBuckets, useSkipScan, table.getRowTimestampColPos(), minOffset);
        context.setScanRanges(scanRanges);
        if (whereClause == null) {
            return null;
        }
        return whereClause.accept(new RemoveExtractedNodesVisitor(extractNodes));
    }

    private static KeyRange getTrailingRange(RowKeySchema rowKeySchema, int clippedPkPos, KeyRange range, KeyRange clippedResult, ImmutableBytesWritable ptr) {
        int clippedSepLength = rowKeySchema.getField(clippedPkPos).getDataType().isFixedWidth() ? 0 : 1;
        byte[] lowerRange = KeyRange.UNBOUND;
        boolean lowerInclusive = false;
        if (!range.lowerUnbound() && range.getLowerRange().length > clippedResult.getLowerRange().length && Bytes.startsWith((byte[])range.getLowerRange(), (byte[])clippedResult.getLowerRange())) {
            lowerRange = range.getLowerRange();
            int offset = clippedResult.getLowerRange().length + clippedSepLength;
            ptr.set(lowerRange, offset, lowerRange.length - offset);
            lowerRange = ptr.copyBytes();
            lowerInclusive = range.isLowerInclusive();
        }
        byte[] upperRange = KeyRange.UNBOUND;
        boolean upperInclusive = false;
        if (!range.upperUnbound() && range.getUpperRange().length > clippedResult.getUpperRange().length && Bytes.startsWith((byte[])range.getUpperRange(), (byte[])clippedResult.getUpperRange())) {
            upperRange = range.getUpperRange();
            int offset = clippedResult.getUpperRange().length + clippedSepLength;
            ptr.set(upperRange, offset, upperRange.length - offset);
            upperRange = ptr.copyBytes();
            upperInclusive = range.isUpperInclusive();
        }
        return KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
    }

    private static List<KeyRange> clipRight(RowKeySchema schema, int pkPos, List<KeyRange> keyRanges, List<KeyRange> leftRanges, ImmutableBytesWritable ptr) {
        ArrayList clippedKeyRanges = Lists.newArrayListWithExpectedSize((int)keyRanges.size());
        for (int i = 0; i < leftRanges.size(); ++i) {
            KeyRange leftRange = leftRanges.get(i);
            KeyRange range = keyRanges.get(i);
            KeyRange clippedKeyRange = WhereOptimizer.getTrailingRange(schema, pkPos, range, leftRange, ptr);
            clippedKeyRanges.add(clippedKeyRange);
        }
        return clippedKeyRanges;
    }

    private static List<KeyRange> clipLeft(RowKeySchema schema, int pkPos, int clipLeftSpan, List<KeyRange> keyRanges, ImmutableBytesWritable ptr) {
        ArrayList clippedKeyRanges = Lists.newArrayListWithExpectedSize((int)keyRanges.size());
        for (KeyRange keyRange : keyRanges) {
            KeyRange clippedKeyRange = schema.clipLeft(pkPos, keyRange, clipLeftSpan, ptr);
            clippedKeyRanges.add(clippedKeyRange);
        }
        return clippedKeyRanges;
    }

    private static List<KeyRange> invertKeyRanges(List<KeyRange> keyRanges) {
        keyRanges = new ArrayList<KeyRange>(keyRanges);
        for (int i = 0; i < keyRanges.size(); ++i) {
            KeyRange range = keyRanges.get(i);
            range = range.invert();
            keyRanges.set(i, range);
        }
        return keyRanges;
    }

    public static boolean getKeyExpressionCombination(List<Expression> result, StatementContext context, FilterableStatement statement, List<Expression> expressions) throws SQLException {
        int count;
        ArrayList candidateIndexes = Lists.newArrayList();
        final ArrayList pkPositions = Lists.newArrayList();
        PTable table = context.getCurrentTable().getTable();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expression = expressions.get(i);
            KeyExpressionVisitor visitor = new KeyExpressionVisitor(context, table);
            KeyExpressionVisitor.KeySlots keySlots = expression.accept(visitor);
            int minPkPos = Integer.MAX_VALUE;
            if (keySlots == null) continue;
            for (KeyExpressionVisitor.KeySlot slot : keySlots.getSlots()) {
                if (slot.getPKPosition() >= minPkPos) continue;
                minPkPos = slot.getPKPosition();
            }
            if (minPkPos == Integer.MAX_VALUE) continue;
            candidateIndexes.add(i);
            pkPositions.add(minPkPos);
        }
        if (candidateIndexes.isEmpty()) {
            return false;
        }
        Collections.sort(candidateIndexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer left, Integer right) {
                return (Integer)pkPositions.get(left) - (Integer)pkPositions.get(right);
            }
        });
        ArrayList candidates = Lists.newArrayList();
        ArrayList sampleValues = Lists.newArrayList();
        for (Integer index : candidateIndexes) {
            candidates.add(expressions.get(index));
        }
        for (int i = 0; i < 2; ++i) {
            ArrayList group = Lists.newArrayList();
            for (Expression expression : candidates) {
                PDataType type = expression.getDataType();
                group.add(LiteralExpression.newConstant(type.getSampleValue(), type));
            }
            sampleValues.add(group);
        }
        int offset = table.getBucketNum() == null ? 0 : 1;
        int maxPkSpan = 0;
        Object remaining = null;
        for (count = 0; count < candidates.size(); ++count) {
            Expression lhs = count == 0 ? (Expression)candidates.get(0) : new RowValueConstructorExpression(candidates.subList(0, count + 1), false);
            Expression firstRhs = count == 0 ? (Expression)((List)sampleValues.get(0)).get(0) : new RowValueConstructorExpression(((List)sampleValues.get(0)).subList(0, count + 1), true);
            Expression secondRhs = count == 0 ? (Expression)((List)sampleValues.get(1)).get(0) : new RowValueConstructorExpression(((List)sampleValues.get(1)).subList(0, count + 1), true);
            Expression testExpression = InListExpression.create(Lists.newArrayList((Object[])new Expression[]{lhs, firstRhs, secondRhs}), false, context.getTempPtr(), context.getCurrentTable().getTable().rowKeyOrderOptimizable());
            Set<HintNode.Hint> hints = new HashSet<HintNode.Hint>();
            if (statement.getHint() != null) {
                hints = statement.getHint().getHints();
            }
            remaining = WhereOptimizer.pushKeyExpressionsToScan(context, hints, testExpression);
            if (context.getScanRanges().isPointLookup()) {
                ++count;
                break;
            }
            int pkSpan = context.getScanRanges().getBoundPkColumnCount() - offset;
            if (pkSpan <= maxPkSpan) break;
            maxPkSpan = pkSpan;
        }
        result.addAll(candidates.subList(0, count));
        return !(count != candidates.size() || !context.getScanRanges().isPointLookup() && !context.getScanRanges().useSkipScanFilter() || remaining != null && !remaining.equals(LiteralExpression.newConstant((Object)true, Determinism.ALWAYS)));
    }

    public static class KeyExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<KeySlots> {
        private static final KeySlots EMPTY_KEY_SLOTS = new KeySlots(){

            @Override
            public boolean isPartialExtraction() {
                return false;
            }

            @Override
            public List<KeySlot> getSlots() {
                return Collections.emptyList();
            }
        };
        public static final Comparator<Pair<KeyRange, List<KeyRange[]>>> KEY_RANGE_PAIR_COMPARATOR = new Comparator<Pair<KeyRange, List<KeyRange[]>>>(){

            @Override
            public int compare(Pair<KeyRange, List<KeyRange[]>> o1, Pair<KeyRange, List<KeyRange[]>> o2) {
                return KeyRange.COMPARATOR.compare((KeyRange)o1.getFirst(), (KeyRange)o2.getFirst());
            }
        };
        private final PTable table;
        private final StatementContext context;

        private static boolean isDegenerate(List<KeyRange> keyRanges) {
            return keyRanges == null || keyRanges.isEmpty() || keyRanges.size() == 1 && keyRanges.get(0) == KeyRange.EMPTY_RANGE;
        }

        private KeySlots newKeyParts(KeySlot slot, Expression extractNode, KeyRange keyRange) {
            if (keyRange == null) {
                return EMPTY_KEY_SLOTS;
            }
            List<KeyRange> keyRanges = Collections.singletonList(keyRange);
            return this.newKeyParts(slot, extractNode, keyRanges);
        }

        private KeySlots newKeyParts(KeySlot slot, Expression extractNode, List<KeyRange> keyRanges) {
            if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                return EMPTY_KEY_SLOTS;
            }
            LinkedHashSet<Expression> extractNodes = extractNode == null || slot.getKeyPart().getExtractNodes().isEmpty() ? Collections.emptySet() : new LinkedHashSet<Expression>(Collections.singleton(extractNode));
            return new SingleKeySlot(new BaseKeyPart(this.table, slot.getKeyPart().getColumn(), extractNodes), slot.getPKPosition(), slot.getPKSpan(), keyRanges, slot.getOrderPreserving());
        }

        private KeySlots newKeyParts(KeySlot slot, Set<Expression> extractNodes, List<KeyRange> keyRanges) {
            if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                return EMPTY_KEY_SLOTS;
            }
            return new SingleKeySlot(new BaseKeyPart(this.table, slot.getKeyPart().getColumn(), extractNodes), slot.getPKPosition(), slot.getPKSpan(), keyRanges, slot.getOrderPreserving());
        }

        private KeySlots newRowValueConstructorKeyParts(RowValueConstructorExpression rvc, List<KeySlots> childSlots) {
            int pkPosition;
            KeySlots slots;
            KeySlot keySlot;
            Set<Expression> childExtractNodes;
            if (childSlots.isEmpty() || rvc.isStateless()) {
                return null;
            }
            int position = -1;
            int initialPosition = -1;
            for (int i = 0; i < childSlots.size() && (childExtractNodes = (keySlot = (slots = childSlots.get(i)).getSlots().iterator().next()).getKeyPart().getExtractNodes()).size() == 1 && childExtractNodes.contains(rvc.getChildren().get(i)) && (pkPosition = keySlot.getPKPosition()) >= 0; ++i) {
                if (position == -1) {
                    position = initialPosition = pkPosition;
                } else if (pkPosition != position) break;
                ++position;
                assert (keySlot.getOrderPreserving() != FunctionExpression.OrderPreserving.NO);
                if (keySlot.getOrderPreserving() == FunctionExpression.OrderPreserving.YES_IF_LAST) break;
            }
            if (position > 0) {
                int span = position - initialPosition;
                return new SingleKeySlot((KeyPart)new RowValueConstructorKeyPart(this.table.getPKColumns().get(initialPosition), rvc, span, childSlots), initialPosition, span, EVERYTHING_RANGES);
            }
            return null;
        }

        private KeySlots newScalarFunctionKeyPart(KeySlot slot, ScalarFunction node) {
            if (KeyExpressionVisitor.isDegenerate(slot.getKeyRanges())) {
                return EMPTY_KEY_SLOTS;
            }
            KeyPart part = node.newKeyPart(slot.getKeyPart());
            if (part == null) {
                return null;
            }
            return new SingleKeySlot(part, slot.getPKPosition(), slot.getKeyRanges(), node.preservesOrder());
        }

        private KeySlots newCoerceKeyPart(KeySlot slot, CoerceExpression node) {
            if (KeyExpressionVisitor.isDegenerate(slot.getKeyRanges())) {
                return EMPTY_KEY_SLOTS;
            }
            LinkedHashSet<Expression> extractNodes = new LinkedHashSet<Expression>(Collections.singletonList(node));
            KeyPart childPart = slot.getKeyPart();
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            return new SingleKeySlot(new CoerceKeySlot(childPart, ptr, node, extractNodes), slot.getPKPosition(), slot.getKeyRanges());
        }

        private KeySlots andKeySlots(AndExpression andExpression, List<KeySlots> childSlots) {
            List<Object> keyRanges;
            if (childSlots.isEmpty()) {
                return null;
            }
            boolean partialExtraction = andExpression.getChildren().size() != childSlots.size();
            int nChildSlots = childSlots.size();
            for (int i = 0; i < nChildSlots; ++i) {
                KeySlots childSlot = childSlots.get(i);
                if (childSlot == EMPTY_KEY_SLOTS) {
                    return EMPTY_KEY_SLOTS;
                }
                partialExtraction |= childSlot.isPartialExtraction();
            }
            boolean mayExtractNodes = true;
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            RowKeySchema rowKeySchema = this.table.getRowKeySchema();
            int nPkColumns = this.table.getPKColumns().size();
            KeySlot[] keySlotArray = new KeySlot[nPkColumns];
            int initPkPos = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            ArrayList slotsTrailingRanges = Lists.newArrayListWithExpectedSize((int)nPkColumns);
            for (int pkPos = initPkPos; pkPos < nPkColumns; ++pkPos) {
                SlotsIterator iterator = new SlotsIterator(childSlots, pkPos);
                FunctionExpression.OrderPreserving orderPreserving = null;
                HashSet visitedKeyParts = Sets.newHashSet();
                LinkedHashSet<Expression> extractNodes = new LinkedHashSet<Expression>();
                keyRanges = Lists.newArrayList();
                ArrayList trailingRangesList = Lists.newArrayList();
                Object result = null;
                TrailingRangeIterator trailingRangeIterator = new TrailingRangeIterator(initPkPos, pkPos, slotsTrailingRanges);
                while (iterator.next() || trailingRangeIterator.hasNext() && result != KeyRange.EMPTY_RANGE) {
                    result = null;
                    KeyRange[] trailingRanges = this.newTrailingRange();
                    for (int i = 0; i < nChildSlots && result != KeyRange.EMPTY_RANGE; ++i) {
                        KeySlot keySlot = iterator.getSlot(i);
                        if (keySlot == null) continue;
                        KeyRange otherRange = iterator.getRange(i);
                        Iterator<Object> range = result;
                        if (keySlot.getOrderPreserving() != null) {
                            orderPreserving = keySlot.getOrderPreserving().combine(orderPreserving);
                        }
                        if (visitedKeyParts.add(keySlot.getKeyPart()) && keySlot.getKeyPart().getExtractNodes() != null) {
                            extractNodes.addAll(keySlot.getKeyPart().getExtractNodes());
                        }
                        result = this.intersectRanges(pkPos, (KeyRange)((Object)range), otherRange, trailingRanges);
                    }
                    if (result == KeyRange.EMPTY_RANGE) continue;
                    HashMap results = Maps.newHashMap();
                    trailingRangeIterator.init();
                    while (trailingRangeIterator.hasNext()) {
                        do {
                            KeyRange[] intTrailingRanges;
                            KeyRange intResult;
                            KeyRange keyRange;
                            if ((keyRange = trailingRangeIterator.getRange()) == KeyRange.EVERYTHING_RANGE || (intResult = this.intersectRanges(pkPos, (KeyRange)result, keyRange, intTrailingRanges = Arrays.copyOf(trailingRanges, trailingRanges.length))) == KeyRange.EMPTY_RANGE) continue;
                            KeyExpressionVisitor.addResult(intResult, intTrailingRanges, results);
                        } while (trailingRangeIterator.nextTrailingRange() || trailingRangeIterator.nextRange());
                    }
                    if (results.isEmpty() && result != null) {
                        keyRanges.add(result);
                        trailingRangesList.add(trailingRanges);
                        continue;
                    }
                    mayExtractNodes &= results.size() <= 1;
                    for (Map.Entry entry : results.entrySet()) {
                        for (KeyRange[] keyRangeArray : (List)entry.getValue()) {
                            keyRanges.add(entry.getKey());
                            trailingRangesList.add(keyRangeArray);
                        }
                    }
                }
                if (result == null && keyRanges.isEmpty()) {
                    slotsTrailingRanges.add(Collections.emptyList());
                    continue;
                }
                if (keyRanges.isEmpty()) {
                    return EMPTY_KEY_SLOTS;
                }
                keyRanges = this.coalesceKeyRangesAndTrailingRanges(keyRanges, trailingRangesList, slotsTrailingRanges);
                int maxSpan = 1;
                for (KeyRange keyRange : keyRanges) {
                    int span = rowKeySchema.computeMaxSpan(pkPos, keyRange, this.context.getTempPtr());
                    if (span <= maxSpan) continue;
                    maxSpan = span;
                }
                keySlotArray[pkPos] = new KeySlot(new BaseKeyPart(this.table, this.table.getPKColumns().get(pkPos), mayExtractNodes ? extractNodes : Collections.emptySet()), pkPos, maxSpan, keyRanges, orderPreserving);
            }
            for (int i = 0; i < keySlotArray.length; ++i) {
                KeySlot keySlot = keySlotArray[i];
                if (keySlot == null) continue;
                int pkSpan = keySlot.getPKSpan();
                int pkPos = keySlot.getPKPosition();
                boolean slotWasIntersected = false;
                keyRanges = keySlot.getKeyRanges();
                List<Object> slotTrimmedResults = Lists.newArrayListWithExpectedSize((int)keyRanges.size());
                for (KeyRange keyRange : keyRanges) {
                    boolean resultWasIntersected = false;
                    HashSet trimmedResults = Sets.newHashSetWithExpectedSize((int)keyRanges.size());
                    for (int j = pkPos + 1; j < pkPos + pkSpan && j < nPkColumns; ++j) {
                        KeySlot nextKeySlot = keySlotArray[j];
                        if (nextKeySlot == null) continue;
                        for (KeyRange keyRange2 : nextKeySlot.getKeyRanges()) {
                            resultWasIntersected = true;
                            KeyRange intResult = this.intersectTrailing(keyRange, pkPos, keyRange2, j);
                            if (intResult == KeyRange.EMPTY_RANGE) continue;
                            trimmedResults.add(intResult);
                        }
                    }
                    if (resultWasIntersected) {
                        slotWasIntersected = true;
                        slotTrimmedResults.addAll(trimmedResults);
                        mayExtractNodes &= trimmedResults.size() <= 1;
                        continue;
                    }
                    slotTrimmedResults.add(keyRange);
                }
                if (slotTrimmedResults.isEmpty()) {
                    return EMPTY_KEY_SLOTS;
                }
                if (slotWasIntersected) {
                    slotTrimmedResults = KeyRange.coalesce((List<KeyRange>)slotTrimmedResults);
                    pkSpan = 1;
                    for (KeyRange keyRange : slotTrimmedResults) {
                        pkSpan = Math.max(pkSpan, rowKeySchema.computeMaxSpan(pkPos, keyRange, ptr));
                    }
                }
                LinkedHashSet extractNodes = mayExtractNodes ? keySlotArray[pkPos].getKeyPart().getExtractNodes() : new LinkedHashSet();
                keySlotArray[pkPos] = new KeySlot(new BaseKeyPart(this.table, this.table.getPKColumns().get(pkPos), extractNodes), pkPos, pkSpan, slotTrimmedResults, keySlotArray[pkPos].getOrderPreserving());
            }
            List<KeySlot> keySlots = Arrays.asList(keySlotArray);
            keySlots = keySlots.subList(initPkPos, keySlots.size());
            return new MultiKeySlot(keySlots, partialExtraction);
        }

        private KeyRange[] newTrailingRange() {
            KeyRange[] trailingRanges = new KeyRange[this.table.getPKColumns().size()];
            for (int i = 0; i < trailingRanges.length; ++i) {
                trailingRanges[i] = KeyRange.EVERYTHING_RANGE;
            }
            return trailingRanges;
        }

        private static void addResult(KeyRange result, KeyRange[] trailingRange, Map<KeyRange, List<KeyRange[]>> results) {
            ArrayList trailingRanges = Lists.newArrayList((Object[])new KeyRange[][]{trailingRange});
            List<KeyRange[]> priorTrailingRanges = results.put(result, trailingRanges);
            if (priorTrailingRanges != null) {
                trailingRanges.addAll(priorTrailingRanges);
            }
        }

        private List<KeyRange> coalesceKeyRangesAndTrailingRanges(List<KeyRange> keyRanges, List<KeyRange[]> trailingRangesList, List<List<List<KeyRange[]>>> slotsTrailingRanges) {
            List<Pair<KeyRange, List<KeyRange[]>>> pairs = KeyExpressionVisitor.coalesce(keyRanges, trailingRangesList);
            ArrayList trailingRanges = Lists.newArrayListWithExpectedSize((int)pairs.size());
            ArrayList coalescedKeyRanges = Lists.newArrayListWithExpectedSize((int)pairs.size());
            for (Pair<KeyRange, List<KeyRange[]>> pair : pairs) {
                coalescedKeyRanges.add(pair.getFirst());
                trailingRanges.add(pair.getSecond());
            }
            slotsTrailingRanges.add(trailingRanges);
            return coalescedKeyRanges;
        }

        private static boolean isEverythingRanges(KeyRange[] ranges) {
            for (KeyRange range : ranges) {
                if (range == KeyRange.EVERYTHING_RANGE) continue;
                return false;
            }
            return true;
        }

        private static List<KeyRange[]> concat(List<KeyRange[]> list1, List<KeyRange[]> list2) {
            if (list1.size() == 1 && KeyExpressionVisitor.isEverythingRanges(list1.get(0))) {
                if (list2.size() == 1 && KeyExpressionVisitor.isEverythingRanges(list1.get(0))) {
                    return Collections.emptyList();
                }
                return list2;
            }
            if (list2.size() == 1 && KeyExpressionVisitor.isEverythingRanges(list2.get(0))) {
                return list1;
            }
            ArrayList newList = Lists.newArrayListWithExpectedSize((int)(list1.size() + list2.size()));
            newList.addAll(list1);
            newList.addAll(list2);
            return newList;
        }

        @NonNull
        public static List<Pair<KeyRange, List<KeyRange[]>>> coalesce(List<KeyRange> keyRanges, List<KeyRange[]> trailingRangesList) {
            KeyRange newRange;
            ArrayList tmp = Lists.newArrayListWithExpectedSize((int)keyRanges.size());
            int nKeyRanges = keyRanges.size();
            for (int i = 0; i < nKeyRanges; ++i) {
                KeyRange keyRange = keyRanges.get(i);
                KeyRange[] trailingRange = trailingRangesList.get(i);
                Pair pair = new Pair((Object)keyRange, (Object)Lists.newArrayList((Object[])new KeyRange[][]{trailingRange}));
                tmp.add(pair);
            }
            Collections.sort(tmp, KEY_RANGE_PAIR_COMPARATOR);
            ArrayList tmp2 = Lists.newArrayListWithExpectedSize((int)tmp.size());
            Pair range = (Pair)tmp.get(0);
            for (int i = 1; i < tmp.size(); ++i) {
                Pair otherRange = (Pair)tmp.get(i);
                KeyRange intersect = ((KeyRange)range.getFirst()).intersect((KeyRange)otherRange.getFirst());
                if (KeyRange.EMPTY_RANGE == intersect) {
                    tmp2.add(range);
                    range = otherRange;
                    continue;
                }
                newRange = ((KeyRange)range.getFirst()).union((KeyRange)otherRange.getFirst());
                range = new Pair((Object)newRange, KeyExpressionVisitor.concat((List)range.getSecond(), (List)otherRange.getSecond()));
            }
            tmp2.add(range);
            ArrayList tmp3 = Lists.newArrayListWithExpectedSize((int)tmp2.size());
            range = (Pair)tmp2.get(0);
            for (int i = 1; i < tmp2.size(); ++i) {
                Pair otherRange = (Pair)tmp2.get(i);
                assert (!((KeyRange)range.getFirst()).upperUnbound());
                assert (!((KeyRange)otherRange.getFirst()).lowerUnbound());
                if (((KeyRange)range.getFirst()).isUpperInclusive() != ((KeyRange)otherRange.getFirst()).isLowerInclusive() && Bytes.equals((byte[])((KeyRange)range.getFirst()).getUpperRange(), (byte[])((KeyRange)otherRange.getFirst()).getLowerRange())) {
                    newRange = KeyRange.getKeyRange(((KeyRange)range.getFirst()).getLowerRange(), ((KeyRange)range.getFirst()).isLowerInclusive(), ((KeyRange)otherRange.getFirst()).getUpperRange(), ((KeyRange)otherRange.getFirst()).isUpperInclusive());
                    range = new Pair((Object)newRange, KeyExpressionVisitor.concat((List)range.getSecond(), (List)otherRange.getSecond()));
                    continue;
                }
                tmp3.add(range);
                range = otherRange;
            }
            tmp3.add(range);
            return tmp3;
        }

        private KeyRange intersectRanges(int pkPos, KeyRange range, KeyRange otherRange, KeyRange[] trailingRanges) {
            if (range == null) {
                range = otherRange;
            }
            KeyRange result = range;
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            RowKeySchema rowKeySchema = this.table.getRowKeySchema();
            int minSpan = rowKeySchema.computeMinSpan(pkPos, result, ptr);
            int otherMinSpan = rowKeySchema.computeMinSpan(pkPos, otherRange, ptr);
            KeyRange otherClippedRange = otherRange;
            KeyRange clippedRange = result;
            if (minSpan != otherMinSpan && result != KeyRange.EVERYTHING_RANGE && otherRange != KeyRange.EVERYTHING_RANGE) {
                if (otherMinSpan > minSpan) {
                    otherClippedRange = rowKeySchema.clipLeft(pkPos, otherRange, minSpan, ptr);
                } else if (minSpan > otherMinSpan) {
                    clippedRange = rowKeySchema.clipLeft(pkPos, result, otherMinSpan, ptr);
                }
            }
            if ((result = clippedRange.intersect(otherClippedRange)) == KeyRange.EMPTY_RANGE) {
                return result;
            }
            if (minSpan != otherMinSpan) {
                if (!(!result.isSingleKey() || range.isSingleKey() && otherRange.isSingleKey())) {
                    int trailingPkPos = pkPos + Math.min(minSpan, otherMinSpan);
                    KeyRange trailingRange = WhereOptimizer.getTrailingRange(rowKeySchema, pkPos, minSpan > otherMinSpan ? range : otherRange, result, ptr);
                    trailingRanges[trailingPkPos] = trailingRanges[trailingPkPos].intersect(trailingRange);
                } else if (otherMinSpan > minSpan) {
                    result = KeyExpressionVisitor.concatSuffix(result, otherRange);
                } else if (minSpan > otherMinSpan) {
                    result = KeyExpressionVisitor.concatSuffix(result, range);
                }
            }
            return result;
        }

        private static KeyRange concatSuffix(KeyRange result, KeyRange otherRange) {
            byte[] upperRange;
            byte[] lowerRange;
            byte[] clippedLowerRange = lowerRange = result.getLowerRange();
            byte[] fullLowerRange = otherRange.getLowerRange();
            if (!result.lowerUnbound() && Bytes.startsWith((byte[])fullLowerRange, (byte[])clippedLowerRange)) {
                lowerRange = fullLowerRange;
            }
            byte[] clippedUpperRange = upperRange = result.getUpperRange();
            byte[] fullUpperRange = otherRange.getUpperRange();
            if (!result.lowerUnbound() && Bytes.startsWith((byte[])fullUpperRange, (byte[])clippedUpperRange)) {
                upperRange = fullUpperRange;
            }
            if (lowerRange == clippedLowerRange && upperRange == clippedUpperRange) {
                return result;
            }
            return KeyRange.getKeyRange(lowerRange, result.isLowerInclusive(), upperRange, result.isUpperInclusive());
        }

        private KeyRange intersectTrailing(KeyRange result, int pkPos, KeyRange otherRange, int otherPKPos) {
            RowKeySchema rowKeySchema = this.table.getRowKeySchema();
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            int separatorLength = this.table.getPKColumns().get(otherPKPos - 1).getDataType().isFixedWidth() ? 0 : 1;
            boolean lowerInclusive = result.isLowerInclusive();
            byte[] lowerRange = result.getLowerRange();
            ptr.set(lowerRange);
            if (rowKeySchema.position(ptr, pkPos, otherPKPos)) {
                int lowerOffset = ptr.getOffset();
                ptr.set(ptr.get(), lowerOffset, lowerRange.length - lowerOffset);
                byte[] trailingBytes = ptr.copyBytes();
                if (result.isSingleKey() && otherRange.isSingleKey()) {
                    boolean isFixedWidthAtEnd;
                    byte[] otherLowerRange;
                    int otherMinSpan;
                    int minSpan = rowKeySchema.computeMinSpan(pkPos, result, ptr);
                    if (pkPos + minSpan <= otherPKPos + (otherMinSpan = rowKeySchema.computeMinSpan(otherPKPos, otherRange, ptr))) {
                        otherLowerRange = otherRange.getLowerRange();
                        isFixedWidthAtEnd = this.table.getPKColumns().get(pkPos + minSpan - 1).getDataType().isFixedWidth();
                    } else {
                        otherLowerRange = trailingBytes;
                        trailingBytes = otherRange.getLowerRange();
                        isFixedWidthAtEnd = this.table.getPKColumns().get(otherPKPos + otherMinSpan - 1).getDataType().isFixedWidth();
                    }
                    if (Bytes.startsWith((byte[])otherLowerRange, (byte[])trailingBytes) && (isFixedWidthAtEnd || otherLowerRange.length == trailingBytes.length || otherLowerRange[trailingBytes.length] == 0)) {
                        return result;
                    }
                    return KeyRange.EMPTY_RANGE;
                }
                if (otherRange.intersect(KeyRange.getKeyRange(trailingBytes)) == KeyRange.EMPTY_RANGE) {
                    if (result.isSingleKey()) {
                        return KeyRange.EMPTY_RANGE;
                    }
                    ptr.set(result.getLowerRange(), 0, lowerOffset - separatorLength);
                    lowerRange = ptr.copyBytes();
                }
            }
            boolean upperInclusive = result.isUpperInclusive();
            byte[] upperRange = result.getUpperRange();
            ptr.set(upperRange);
            if (rowKeySchema.position(ptr, pkPos, otherPKPos)) {
                int upperOffset = ptr.getOffset();
                ptr.set(ptr.get(), upperOffset, upperRange.length - upperOffset);
                if (otherRange.intersect(KeyRange.getKeyRange(ptr.copyBytes())) == KeyRange.EMPTY_RANGE) {
                    ptr.set(ptr.get(), 0, upperOffset - separatorLength);
                    upperRange = ptr.copyBytes();
                }
            }
            if (lowerRange == result.getLowerRange() && upperRange == result.getUpperRange()) {
                return result;
            }
            KeyRange range = KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
            return range;
        }

        private KeySlots orKeySlots(OrExpression orExpression, List<KeySlots> childSlots) {
            if (orExpression.getChildren().size() != childSlots.size()) {
                return null;
            }
            int initialPos = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            KeySlot theSlot = null;
            LinkedHashSet<Expression> slotExtractNodes = new LinkedHashSet<Expression>();
            int thePosition = -1;
            boolean partialExtraction = false;
            ArrayList slotRanges = Lists.newArrayList();
            for (KeySlots childSlot : childSlots) {
                if (childSlot == EMPTY_KEY_SLOTS) continue;
                partialExtraction |= childSlot.isPartialExtraction();
                for (KeySlot slot : childSlot.getSlots()) {
                    if (slot == null) continue;
                    if (thePosition == -1) {
                        theSlot = slot;
                        thePosition = slot.getPKPosition();
                    } else if (thePosition != slot.getPKPosition()) {
                        return null;
                    }
                    slotExtractNodes.addAll(slot.getKeyPart().getExtractNodes());
                    slotRanges.addAll(slot.getKeyRanges());
                }
            }
            if (thePosition == -1) {
                return null;
            }
            if (theSlot == null) {
                theSlot = new KeySlot(new BaseKeyPart(this.table, this.table.getPKColumns().get(initialPos), slotExtractNodes), initialPos, 1, EVERYTHING_RANGES, null);
            }
            return this.newKeyParts(theSlot, partialExtraction ? slotExtractNodes : new LinkedHashSet<Expression>(Collections.singletonList(orExpression)), slotRanges.isEmpty() ? EVERYTHING_RANGES : KeyRange.coalesce(slotRanges));
        }

        public KeyExpressionVisitor(StatementContext context, PTable table) {
            this.context = context;
            this.table = table;
        }

        @Override
        public Iterator<Expression> visitEnter(CoerceExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(CoerceExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            return this.newCoerceKeyPart(childParts.get(0).getSlots().get(0), node);
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(AndExpression node, List<KeySlots> l) {
            KeySlots keyExpr = this.andKeySlots(node, l);
            return keyExpr;
        }

        @Override
        public Iterator<Expression> visitEnter(OrExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(OrExpression node, List<KeySlots> l) {
            KeySlots keySlots = this.orKeySlots(node, l);
            if (keySlots == null) {
                return null;
            }
            return keySlots;
        }

        @Override
        public Iterator<Expression> visitEnter(RowValueConstructorExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(RowValueConstructorExpression node, List<KeySlots> childSlots) {
            return this.newRowValueConstructorKeyParts(node, childSlots);
        }

        @Override
        public KeySlots visit(RowKeyColumnExpression node) {
            PColumn column = this.table.getPKColumns().get(node.getPosition());
            return new SingleKeySlot((KeyPart)new BaseKeyPart(this.table, column, new LinkedHashSet<RowKeyColumnExpression>(Collections.singletonList(node))), node.getPosition(), 1, EVERYTHING_RANGES);
        }

        @Override
        public Iterator<Expression> visitEnter(ComparisonExpression node) {
            Expression rhs = node.getChildren().get(1);
            if (!rhs.isStateless() || node.getFilterOp() == CompareFilter.CompareOp.NOT_EQUAL) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(ComparisonExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            Expression rhs = node.getChildren().get(1);
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.getSlots().get(0);
            KeyPart childPart = childSlot.getKeyPart();
            CompareFilter.CompareOp op = node.getFilterOp();
            KeyRange keyRange = childPart.getKeyRange(op, rhs);
            return this.newKeyParts(childSlot, (Expression)node, keyRange);
        }

        @Override
        public Iterator<Expression> visitEnter(ScalarFunction node) {
            int index = node.getKeyFormationTraversalIndex();
            if (index < 0) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)node.getChildren().get(index));
        }

        @Override
        public KeySlots visitLeave(ScalarFunction node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            return this.newScalarFunctionKeyPart(childParts.get(0).getSlots().get(0), node);
        }

        @Override
        public Iterator<Expression> visitEnter(LikeExpression node) {
            if (node.getLikeType() == LikeParseNode.LikeType.CASE_INSENSITIVE || !(node.getChildren().get(1) instanceof LiteralExpression) || node.startsWithWildcard()) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(LikeExpression node, List<KeySlots> childParts) {
            Integer childNodeFixedLength;
            if (childParts.isEmpty()) {
                return null;
            }
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.getSlots().get(0);
            String startsWith = node.getLiteralPrefix();
            SortOrder sortOrder = node.getChildren().get(0).getSortOrder();
            byte[] key = PVarchar.INSTANCE.toBytes(startsWith, sortOrder);
            Expression firstChild = node.getChildren().get(0);
            Integer n = childNodeFixedLength = firstChild.getDataType().isFixedWidth() ? firstChild.getMaxLength() : null;
            if (childNodeFixedLength != null && key.length > childNodeFixedLength) {
                return EMPTY_KEY_SLOTS;
            }
            PColumn column = childSlot.getKeyPart().getColumn();
            PDataType type = column.getDataType();
            byte[] lowerRange = key;
            byte[] upperRange = ByteUtil.nextKey(key);
            Integer columnFixedLength = column.getMaxLength();
            if (type.isFixedWidth()) {
                if (columnFixedLength != null) {
                    lowerRange = type.pad(lowerRange, columnFixedLength, SortOrder.ASC);
                    upperRange = type.pad(upperRange, columnFixedLength, SortOrder.ASC);
                }
            } else if (column.getSortOrder() == SortOrder.DESC && this.table.rowKeyOrderOptimizable()) {
                lowerRange = Arrays.copyOf(lowerRange, lowerRange.length + 1);
                lowerRange[lowerRange.length - 1] = 0;
            }
            KeyRange range = type.getKeyRange(lowerRange, true, upperRange, false);
            if (column.getSortOrder() == SortOrder.DESC) {
                range = range.invert();
            }
            return this.newKeyParts(childSlot, (Expression)(node.endsWithOnlyWildcard() ? node : null), range);
        }

        @Override
        public Iterator<Expression> visitEnter(InListExpression node) {
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(InListExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            List<Expression> keyExpressions = node.getKeyExpressions();
            HashSet ranges = Sets.newHashSetWithExpectedSize((int)keyExpressions.size());
            KeySlot childSlot = childParts.get(0).getSlots().get(0);
            KeyPart childPart = childSlot.getKeyPart();
            for (Expression key : keyExpressions) {
                KeyRange range = childPart.getKeyRange(CompareFilter.CompareOp.EQUAL, key);
                if (range == null) {
                    return null;
                }
                if (range == KeyRange.EMPTY_RANGE) continue;
                ranges.add(range);
            }
            return this.newKeyParts(childSlot, (Expression)node, new ArrayList<KeyRange>(ranges));
        }

        @Override
        public Iterator<Expression> visitEnter(IsNullExpression node) {
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(IsNullExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.getSlots().get(0);
            PColumn column = childSlot.getKeyPart().getColumn();
            PDataType type = column.getDataType();
            boolean isFixedWidth = type.isFixedWidth();
            if (isFixedWidth) {
                return node.isNegate() ? null : this.newKeyParts(childSlot, (Expression)node, type.getKeyRange(new byte[SchemaUtil.getFixedByteSize(column)], true, KeyRange.UNBOUND, true));
            }
            KeyRange keyRange = node.isNegate() ? KeyRange.IS_NOT_NULL_RANGE : KeyRange.IS_NULL_RANGE;
            return this.newKeyParts(childSlot, (Expression)node, keyRange);
        }

        private class RowValueConstructorKeyPart
        implements KeyPart {
            private final RowValueConstructorExpression rvc;
            private final PColumn column;
            private final Set<Expression> nodes;
            private final List<KeySlots> childSlots;

            private RowValueConstructorKeyPart(PColumn column, RowValueConstructorExpression rvc, int span, List<KeySlots> childSlots) {
                this.column = column;
                if (span == rvc.getChildren().size()) {
                    this.rvc = rvc;
                    this.nodes = new LinkedHashSet<RowValueConstructorExpression>(Collections.singletonList(rvc));
                    this.childSlots = childSlots;
                } else {
                    this.rvc = new RowValueConstructorExpression(rvc.getChildren().subList(0, span), rvc.isStateless());
                    this.nodes = new LinkedHashSet<Expression>();
                    this.childSlots = childSlots.subList(0, span);
                }
            }

            @Override
            public Set<Expression> getExtractNodes() {
                return this.nodes;
            }

            @Override
            public PColumn getColumn() {
                return this.column;
            }

            @Override
            public PTable getTable() {
                return KeyExpressionVisitor.this.table;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                CompareFilter.CompareOp rvcElementOp;
                boolean usedAllOfLHS;
                boolean bl = usedAllOfLHS = !this.nodes.isEmpty();
                CompareFilter.CompareOp compareOp = op == CompareFilter.CompareOp.LESS_OR_EQUAL ? CompareFilter.CompareOp.LESS : (rvcElementOp = op == CompareFilter.CompareOp.GREATER ? CompareFilter.CompareOp.GREATER_OR_EQUAL : op);
                if (op != CompareFilter.CompareOp.EQUAL) {
                    if (usedAllOfLHS) {
                        if (this.rvc.getChildren().size() < rhs.getChildren().size()) {
                            if (op == CompareFilter.CompareOp.LESS) {
                                op = CompareFilter.CompareOp.LESS_OR_EQUAL;
                            } else if (op == CompareFilter.CompareOp.GREATER_OR_EQUAL) {
                                op = CompareFilter.CompareOp.GREATER;
                            }
                        }
                    } else if (this.rvc.getChildren().size() < rhs.getChildren().size()) {
                        if (op == CompareFilter.CompareOp.LESS) {
                            op = CompareFilter.CompareOp.LESS_OR_EQUAL;
                        } else if (op == CompareFilter.CompareOp.GREATER) {
                            op = CompareFilter.CompareOp.GREATER_OR_EQUAL;
                        }
                    }
                }
                if (!usedAllOfLHS || this.rvc.getChildren().size() != rhs.getChildren().size()) {
                    rhs = new RowValueConstructorExpression(rhs.getChildren().subList(0, Math.min(this.rvc.getChildren().size(), rhs.getChildren().size())), rhs.isStateless());
                }
                final Iterator<KeySlots> keySlotsIterator = this.childSlots.iterator();
                try {
                    rhs = BaseExpression.coerce((Expression)this.rvc, rhs, new BaseExpression.ExpressionComparabilityWrapper(){

                        @Override
                        public Expression wrap(Expression lhs, Expression rhs, boolean rowKeyOrderOptimizable) throws SQLException {
                            KeyPart childPart = ((KeySlots)keySlotsIterator.next()).getSlots().get(0).getKeyPart();
                            return new BaseTerminalExpressionWrap(childPart, rhs, rvcElementOp, lhs);
                        }
                    }, KeyExpressionVisitor.this.table.rowKeyOrderOptimizable());
                }
                catch (SQLException e) {
                    return null;
                }
                ImmutableBytesWritable ptr = KeyExpressionVisitor.this.context.getTempPtr();
                if (!rhs.evaluate(null, ptr)) {
                    return null;
                }
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                KeyRange range = ByteUtil.getKeyRange(key, op, PVarbinary.INSTANCE);
                return range;
            }

            private class BaseTerminalExpressionWrap
            extends BaseTerminalExpression {
                private final KeyPart childPart;
                private final Expression rhs;
                private final CompareFilter.CompareOp rvcElementOp;
                private final Expression lhs;

                public BaseTerminalExpressionWrap(KeyPart childPart, Expression rhs, CompareFilter.CompareOp rvcElementOp, Expression lhs) {
                    this.childPart = childPart;
                    this.rhs = rhs;
                    this.rvcElementOp = rvcElementOp;
                    this.lhs = lhs;
                }

                @Override
                public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
                    byte[] key;
                    if (this.childPart == null) {
                        return this.rhs.evaluate(tuple, ptr);
                    }
                    if (!this.rhs.evaluate(tuple, ptr)) {
                        return false;
                    }
                    if (ptr.getLength() == 0) {
                        ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                        return true;
                    }
                    KeyRange range = this.childPart.getKeyRange(this.rhs.getSortOrder().transform(this.rvcElementOp), this.rhs);
                    if (this.rhs.getSortOrder() == SortOrder.DESC) {
                        range = KeyRange.getKeyRange(range.getUpperRange(), range.isUpperInclusive(), range.getLowerRange(), range.isLowerInclusive());
                    }
                    if (range == KeyRange.EMPTY_RANGE) {
                        return false;
                    }
                    byte[] byArray = key = range.isLowerInclusive() ? range.getLowerRange() : range.getUpperRange();
                    if (this.lhs.getDataType().isFixedWidth() && this.lhs.getMaxLength() != null && key.length > this.lhs.getMaxLength()) {
                        key = Arrays.copyOf(key, (int)this.lhs.getMaxLength());
                    }
                    ptr.set(key);
                    return true;
                }

                @Override
                public PDataType getDataType() {
                    return this.childPart.getColumn().getDataType();
                }

                @Override
                public boolean isNullable() {
                    return this.childPart.getColumn().isNullable();
                }

                @Override
                public Integer getMaxLength() {
                    return this.lhs.getMaxLength();
                }

                @Override
                public Integer getScale() {
                    return this.childPart.getColumn().getScale();
                }

                @Override
                public SortOrder getSortOrder() {
                    return this.childPart.getColumn().getSortOrder();
                }

                @Override
                public <T> T accept(ExpressionVisitor<T> visitor) {
                    return null;
                }
            }
        }

        private static class CoerceKeySlot
        implements KeyPart {
            private final KeyPart childPart;
            private final ImmutableBytesWritable ptr;
            private final CoerceExpression node;
            private final Set<Expression> extractNodes;

            public CoerceKeySlot(KeyPart childPart, ImmutableBytesWritable ptr, CoerceExpression node, Set<Expression> extractNodes) {
                this.childPart = childPart;
                this.ptr = ptr;
                this.node = node;
                this.extractNodes = extractNodes;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                KeyRange range = this.childPart.getKeyRange(op, rhs);
                byte[] lower = range.getLowerRange();
                if (!range.lowerUnbound()) {
                    this.ptr.set(lower);
                    this.node.getChild().getDataType().coerceBytes(this.ptr, this.node.getDataType(), rhs.getSortOrder(), SortOrder.ASC);
                    lower = ByteUtil.copyKeyBytesIfNecessary(this.ptr);
                }
                byte[] upper = range.getUpperRange();
                if (!range.upperUnbound()) {
                    this.ptr.set(upper);
                    this.node.getChild().getDataType().coerceBytes(this.ptr, this.node.getDataType(), rhs.getSortOrder(), SortOrder.ASC);
                    upper = ByteUtil.copyKeyBytesIfNecessary(this.ptr);
                }
                range = KeyRange.getKeyRange(lower, range.isLowerInclusive(), upper, range.isUpperInclusive());
                return range;
            }

            @Override
            public Set<Expression> getExtractNodes() {
                return this.extractNodes;
            }

            @Override
            public PColumn getColumn() {
                return this.childPart.getColumn();
            }

            @Override
            public PTable getTable() {
                return this.childPart.getTable();
            }
        }

        public static class BaseKeyPart
        implements KeyPart {
            private final PTable table;
            private final PColumn column;
            private final Set<Expression> nodes;

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                Integer length;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                rhs.evaluate(null, ptr);
                PDataType type = this.getColumn().getDataType();
                if (type.isFixedWidth() && (length = this.getColumn().getMaxLength()) != null) {
                    type.pad(ptr, length, SortOrder.ASC);
                }
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                KeyRange range = ByteUtil.getKeyRange(key, rhs.getSortOrder().transform(op), type);
                if (rhs.getSortOrder() == SortOrder.DESC) {
                    range = range.invert();
                }
                return range;
            }

            private BaseKeyPart(PTable table, PColumn column, Set<Expression> nodes) {
                this.table = table;
                this.column = column;
                this.nodes = nodes;
            }

            @Override
            public Set<Expression> getExtractNodes() {
                return this.nodes;
            }

            @Override
            public PColumn getColumn() {
                return this.column;
            }

            @Override
            public PTable getTable() {
                return this.table;
            }
        }

        public static class SingleKeySlot
        implements KeySlots {
            private final List<KeySlot> slots;

            SingleKeySlot(KeyPart part, int pkPosition, List<KeyRange> ranges) {
                this(part, pkPosition, 1, ranges);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, List<KeyRange> ranges, FunctionExpression.OrderPreserving orderPreserving) {
                this(part, pkPosition, 1, ranges, orderPreserving);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges) {
                this(part, pkPosition, pkSpan, ranges, null);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges, FunctionExpression.OrderPreserving orderPreserving) {
                this.slots = Collections.singletonList(new KeySlot(part, pkPosition, pkSpan, ranges, orderPreserving));
            }

            @Override
            public List<KeySlot> getSlots() {
                return this.slots;
            }

            @Override
            public boolean isPartialExtraction() {
                return this.slots.get(0).getKeyPart().getExtractNodes().isEmpty();
            }
        }

        public static class MultiKeySlot
        implements KeySlots {
            private final List<KeySlot> childSlots;
            private final boolean partialExtraction;

            private MultiKeySlot(List<KeySlot> childSlots, boolean partialExtraction) {
                this.childSlots = childSlots;
                this.partialExtraction = partialExtraction;
            }

            @Override
            public List<KeySlot> getSlots() {
                return this.childSlots;
            }

            @Override
            public boolean isPartialExtraction() {
                return this.partialExtraction;
            }
        }

        static final class KeySlot {
            private final int pkPosition;
            private final int pkSpan;
            private final KeyPart keyPart;
            private final List<KeyRange> keyRanges;
            private final FunctionExpression.OrderPreserving orderPreserving;

            KeySlot(KeyPart keyPart, int pkPosition, int pkSpan, List<KeyRange> keyRanges, FunctionExpression.OrderPreserving orderPreserving) {
                this.pkPosition = pkPosition;
                this.pkSpan = pkSpan;
                this.keyPart = keyPart;
                this.keyRanges = keyRanges;
                this.orderPreserving = orderPreserving;
            }

            public KeyPart getKeyPart() {
                return this.keyPart;
            }

            public int getPKPosition() {
                return this.pkPosition;
            }

            public int getPKSpan() {
                return this.pkSpan;
            }

            public List<KeyRange> getKeyRanges() {
                return this.keyRanges;
            }

            public final KeySlot concatExtractNodes(Set<Expression> extractNodes) {
                return new KeySlot(new BaseKeyPart(this.getKeyPart().getTable(), this.getKeyPart().getColumn(), SchemaUtil.concat(this.getKeyPart().getExtractNodes(), extractNodes)), this.getPKPosition(), this.getPKSpan(), this.getKeyRanges(), this.getOrderPreserving());
            }

            public FunctionExpression.OrderPreserving getOrderPreserving() {
                return this.orderPreserving;
            }
        }

        public static interface KeySlots {
            public List<KeySlot> getSlots();

            public boolean isPartialExtraction();
        }

        static class TrailingRangeIterator {
            private final List<List<List<KeyRange[]>>> slotTrailingRangesList;
            private final int[] rangePos;
            private final int[] trailingRangePos;
            private final int initPkPos;
            private final int pkPos;
            private int trailingRangePosIndex;
            private int rangePosIndex;
            private boolean hasMore = true;

            TrailingRangeIterator(int initPkPos, int pkPos, List<List<List<KeyRange[]>>> slotsTrailingRangesList) {
                this.slotTrailingRangesList = slotsTrailingRangesList;
                int nSlots = pkPos - initPkPos;
                this.rangePos = new int[nSlots];
                this.trailingRangePos = new int[nSlots];
                this.initPkPos = initPkPos;
                this.pkPos = pkPos;
                this.init();
            }

            public void init() {
                Arrays.fill(this.rangePos, 0);
                Arrays.fill(this.trailingRangePos, 0);
                this.rangePosIndex = this.rangePos.length - 1;
                this.trailingRangePosIndex = this.trailingRangePos.length - 1;
                this.hasMore = this.pkPos > this.initPkPos && this.skipEmpty();
            }

            public boolean hasNext() {
                return this.hasMore && this.skipEmpty();
            }

            public KeyRange getRange() {
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                KeyRange priorTrailingRange = KeyRange.EVERYTHING_RANGE;
                for (int priorPkPos = this.initPkPos; priorPkPos < this.pkPos; ++priorPkPos) {
                    List<KeyRange[]> slotTrailingRanges;
                    List<List<KeyRange[]>> trailingKeyRangesList = this.slotTrailingRangesList.get(priorPkPos - this.initPkPos);
                    if (trailingKeyRangesList.isEmpty() || (slotTrailingRanges = trailingKeyRangesList.get(this.rangePos[priorPkPos - this.initPkPos])).isEmpty()) continue;
                    KeyRange[] slotTrailingRange = slotTrailingRanges.get(this.trailingRangePos[priorPkPos - this.initPkPos]);
                    priorTrailingRange = priorTrailingRange.intersect(slotTrailingRange[this.pkPos]);
                }
                return priorTrailingRange;
            }

            private boolean skipEmptyTrailingRanges() {
                while (this.trailingRangePosIndex >= 0 && (this.slotTrailingRangesList.get(this.trailingRangePosIndex).isEmpty() || this.slotTrailingRangesList.get(this.trailingRangePosIndex).get(this.rangePos[this.trailingRangePosIndex]).isEmpty())) {
                    --this.trailingRangePosIndex;
                }
                return this.trailingRangePosIndex >= 0;
            }

            private boolean skipEmptyRanges() {
                this.trailingRangePosIndex = this.trailingRangePos.length - 1;
                while (this.rangePosIndex >= 0 && this.slotTrailingRangesList.get(this.rangePosIndex).isEmpty()) {
                    --this.rangePosIndex;
                }
                return this.rangePosIndex >= 0;
            }

            private boolean skipEmpty() {
                if (!this.hasMore || this.slotTrailingRangesList.isEmpty() || this.rangePosIndex < 0) {
                    this.hasMore = false;
                    return false;
                }
                do {
                    if (!this.skipEmptyTrailingRanges()) continue;
                    return true;
                } while (this.skipEmptyRanges());
                this.hasMore = this.rangePosIndex >= 0;
                return this.hasMore;
            }

            public boolean nextRange() {
                this.trailingRangePosIndex = this.trailingRangePos.length - 1;
                while (this.rangePosIndex >= 0 && (this.slotTrailingRangesList.get(this.rangePosIndex).isEmpty() || (this.rangePos[this.rangePosIndex] = (this.rangePos[this.rangePosIndex] + 1) % this.slotTrailingRangesList.get(this.rangePosIndex).size()) == 0)) {
                    --this.rangePosIndex;
                }
                return this.rangePosIndex >= 0;
            }

            public boolean nextTrailingRange() {
                while (this.trailingRangePosIndex >= 0 && (this.slotTrailingRangesList.get(this.trailingRangePosIndex).isEmpty() || this.slotTrailingRangesList.get(this.trailingRangePosIndex).get(this.rangePos[this.trailingRangePosIndex]).isEmpty() || (this.trailingRangePos[this.trailingRangePosIndex] = (this.trailingRangePos[this.trailingRangePosIndex] + 1) % this.slotTrailingRangesList.get(this.trailingRangePosIndex).get(this.rangePos[this.trailingRangePosIndex]).size()) == 0)) {
                    --this.trailingRangePosIndex;
                }
                return this.trailingRangePosIndex >= 0;
            }
        }

        static class SlotsIterator {
            public final int pkPos;
            private List<KeySlots> childSlots;
            private List<SlotRangesIterator> slotRangesIterator;
            private boolean firstCall = true;

            SlotsIterator(List<KeySlots> childSlots, int pkPos) {
                this.childSlots = childSlots;
                this.pkPos = pkPos;
                this.slotRangesIterator = Lists.newArrayListWithExpectedSize((int)(childSlots.size() * 3 / 2));
                for (int i = 0; i < childSlots.size(); ++i) {
                    SlotRangesIterator iterator = new SlotRangesIterator(i);
                    this.slotRangesIterator.add(iterator);
                    iterator.initialize();
                }
            }

            public KeySlot getSlot(int index) {
                SlotRangesIterator slotRanges = this.slotRangesIterator.get(index);
                return slotRanges.getSlot();
            }

            public KeyRange getRange(int index) {
                SlotRangesIterator slotRanges = this.slotRangesIterator.get(index);
                return slotRanges.getRange();
            }

            public boolean next() {
                int i;
                if (this.firstCall) {
                    boolean hasAny = false;
                    for (int i2 = 0; i2 < this.childSlots.size(); ++i2) {
                        hasAny |= this.slotRangesIterator.get(i2).initialize();
                    }
                    this.firstCall = false;
                    return hasAny;
                }
                for (i = 0; i < this.childSlots.size() && !this.slotRangesIterator.get(i).next(); ++i) {
                }
                for (i = 0; i < this.childSlots.size(); ++i) {
                    if (this.slotRangesIterator.get(i).isWrapped()) continue;
                    return true;
                }
                return false;
            }

            private class SlotRangesIterator {
                public int slotIndex;
                public int rangeIndex;
                public final KeySlots slots;
                public boolean wrapped;

                public SlotRangesIterator(int slotsIndex) {
                    this.slots = (KeySlots)SlotsIterator.this.childSlots.get(slotsIndex);
                }

                public boolean isWrapped() {
                    return this.wrapped || !this.hasAny();
                }

                private boolean initialize() {
                    this.slotIndex = 0;
                    this.rangeIndex = 0;
                    while (this.slotIndex < this.slots.getSlots().size() && (this.slots.getSlots().get(this.slotIndex) == null || this.slots.getSlots().get(this.slotIndex).getKeyRanges().isEmpty() || this.slots.getSlots().get(this.slotIndex).getPKPosition() != SlotsIterator.this.pkPos)) {
                        ++this.slotIndex;
                    }
                    return this.hasAny();
                }

                private boolean hasAny() {
                    return this.slotIndex < this.slots.getSlots().size();
                }

                public KeySlot getSlot() {
                    if (!this.hasAny()) {
                        return null;
                    }
                    return this.slots.getSlots().get(this.slotIndex);
                }

                public KeyRange getRange() {
                    if (!this.hasAny()) {
                        return null;
                    }
                    return this.getSlot().getKeyRanges().get(this.rangeIndex);
                }

                public boolean next() {
                    if (!this.hasAny()) {
                        return false;
                    }
                    List<KeyRange> ranges = this.getSlot().getKeyRanges();
                    this.rangeIndex = (this.rangeIndex + 1) % ranges.size();
                    if (this.rangeIndex == 0) {
                        do {
                            if ((this.slotIndex = (this.slotIndex + 1) % this.slots.getSlots().size()) != 0) continue;
                            this.initialize();
                            this.wrapped = true;
                            return false;
                        } while (this.getSlot() == null || this.getSlot().getKeyRanges().isEmpty() || this.getSlot().getPKPosition() != SlotsIterator.this.pkPos);
                    }
                    return true;
                }
            }
        }
    }

    private static class RemoveExtractedNodesVisitor
    extends StatelessTraverseNoExpressionVisitor<Expression> {
        private final Set<Expression> nodesToRemove;

        private RemoveExtractedNodesVisitor(Set<Expression> nodesToRemove) {
            this.nodesToRemove = nodesToRemove;
        }

        @Override
        public Expression defaultReturn(Expression node, List<Expression> e) {
            return this.nodesToRemove.contains(node) ? null : node;
        }

        @Override
        public Iterator<Expression> visitEnter(OrExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Expression visit(LiteralExpression node) {
            return this.nodesToRemove.contains(node) ? null : node;
        }

        @Override
        public Expression visitLeave(AndExpression node, List<Expression> l) {
            if (!l.equals(node.getChildren())) {
                if (l.isEmpty()) {
                    return LiteralExpression.newConstant((Object)true, Determinism.ALWAYS);
                }
                if (l.size() == 1) {
                    return l.get(0);
                }
                try {
                    return AndExpression.create(l);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return node;
        }
    }
}

