/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compat.hbase.HbaseCompatCapabilities;
import org.apache.phoenix.compat.hbase.coprocessor.CompatBaseScannerRegionObserver;
import org.apache.phoenix.compile.BindManager;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.CompiledOffset;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.HavingCompiler;
import org.apache.phoenix.compile.JoinCompiler;
import org.apache.phoenix.compile.LimitCompiler;
import org.apache.phoenix.compile.OffsetCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementPlan;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.compile.UnionCompiler;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.ClientAggregatePlan;
import org.apache.phoenix.execute.ClientScanPlan;
import org.apache.phoenix.execute.HashJoinPlan;
import org.apache.phoenix.execute.LiteralResultIterationPlan;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.execute.SortMergeJoinPlan;
import org.apache.phoenix.execute.TupleProjectionPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.UnionPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowValueConstructorOffsetNotCoercibleException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ParseNodeUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;

public class QueryCompiler {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private final PhoenixStatement statement;
    private final Scan scan;
    private final Scan originalScan;
    private final ColumnResolver resolver;
    private final BindManager bindManager;
    private final SelectStatement select;
    private final List<? extends PDatum> targetColumns;
    private final ParallelIteratorFactory parallelIteratorFactory;
    private final SequenceManager sequenceManager;
    private final boolean projectTuples;
    private final boolean noChildParentJoinOptimization;
    private final boolean usePersistentCache;
    private final boolean optimizeSubquery;
    private final Map<TableRef, QueryPlan> dataPlans;
    private final boolean costBased;

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, boolean projectTuples, boolean optimizeSubquery, Map<TableRef, QueryPlan> dataPlans) throws SQLException {
        this(statement, select, resolver, Collections.emptyList(), null, new SequenceManager(statement), projectTuples, optimizeSubquery, dataPlans);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, BindManager bindManager, boolean projectTuples, boolean optimizeSubquery, Map<TableRef, QueryPlan> dataPlans) throws SQLException {
        this(statement, select, resolver, bindManager, Collections.emptyList(), null, new SequenceManager(statement), projectTuples, optimizeSubquery, dataPlans);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, SequenceManager sequenceManager, boolean projectTuples, boolean optimizeSubquery, Map<TableRef, QueryPlan> dataPlans) throws SQLException {
        this(statement, select, resolver, new BindManager(statement.getParameters()), targetColumns, parallelIteratorFactory, sequenceManager, projectTuples, optimizeSubquery, dataPlans);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, BindManager bindManager, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, SequenceManager sequenceManager, boolean projectTuples, boolean optimizeSubquery, Map<TableRef, QueryPlan> dataPlans) throws SQLException {
        this.statement = statement;
        this.select = select;
        this.resolver = resolver;
        this.bindManager = bindManager;
        this.scan = new Scan();
        this.targetColumns = targetColumns;
        this.parallelIteratorFactory = parallelIteratorFactory;
        this.sequenceManager = sequenceManager;
        this.projectTuples = projectTuples;
        this.noChildParentJoinOptimization = select.getHint().hasHint(HintNode.Hint.NO_CHILD_PARENT_JOIN_OPTIMIZATION) || select.getHint().hasHint(HintNode.Hint.USE_PERSISTENT_CACHE);
        this.usePersistentCache = select.getHint().hasHint(HintNode.Hint.USE_PERSISTENT_CACHE);
        ConnectionQueryServices services = statement.getConnection().getQueryServices();
        this.costBased = services.getProps().getBoolean("phoenix.costbased.optimizer.enabled", false);
        this.scan.setLoadColumnFamiliesOnDemand(true);
        if (select.getHint().hasHint(HintNode.Hint.NO_CACHE)) {
            this.scan.setCacheBlocks(false);
        }
        this.scan.setCaching(statement.getFetchSize());
        this.originalScan = ScanUtil.newScan(this.scan);
        this.optimizeSubquery = optimizeSubquery;
        this.dataPlans = dataPlans == null ? Collections.emptyMap() : dataPlans;
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, SequenceManager sequenceManager) throws SQLException {
        this(statement, select, resolver, targetColumns, parallelIteratorFactory, sequenceManager, true, false, null);
    }

    public QueryPlan compile() throws SQLException {
        this.verifySCN();
        QueryPlan plan = this.select.isUnion() ? this.compileUnionAll(this.select) : this.compileSelect(this.select);
        return plan;
    }

    private void verifySCN() throws SQLException {
        if (!HbaseCompatCapabilities.isMaxLookbackTimeSupported()) {
            return;
        }
        PhoenixConnection conn = this.statement.getConnection();
        if (conn.isRunningUpgrade()) {
            return;
        }
        Long scn = conn.getSCN();
        if (scn == null) {
            return;
        }
        long maxLookBackAgeInMillis = CompatBaseScannerRegionObserver.getMaxLookbackInMillis((Configuration)conn.getQueryServices().getConfiguration());
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (maxLookBackAgeInMillis > 0L && now - maxLookBackAgeInMillis > scn) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_QUERY_TABLE_WITH_SCN_OLDER_THAN_MAX_LOOKBACK_AGE).build().buildException();
        }
    }

    public QueryPlan compileUnionAll(SelectStatement select) throws SQLException {
        List<SelectStatement> unionAllSelects = select.getSelects();
        ArrayList<QueryPlan> plans = new ArrayList<QueryPlan>();
        for (int i = 0; i < unionAllSelects.size(); ++i) {
            SelectStatement subSelect = unionAllSelects.get(i);
            if (!select.getOrderBy().isEmpty() || select.getLimit() != null) {
                subSelect = select.getOffset() == null ? NODE_FACTORY.select(subSelect, select.getOrderBy(), select.getLimit(), null) : NODE_FACTORY.select(subSelect, select.getOrderBy(), null, null);
            }
            QueryPlan subPlan = this.compileSubquery(subSelect, true);
            plans.add(subPlan);
        }
        TableRef tableRef = UnionCompiler.contructSchemaTable(this.statement, plans, select.hasWildcard() ? null : select.getSelect());
        ColumnResolver resolver = FromCompiler.getResolver(tableRef);
        StatementContext context = new StatementContext(this.statement, resolver, this.bindManager, this.scan, this.sequenceManager);
        QueryPlan plan = this.compileSingleFlatQuery(context, select, this.statement.getParameters(), false, false, null, false, true);
        plan = new UnionPlan(context, select, tableRef, plan.getProjector(), plan.getLimit(), plan.getOffset(), plan.getOrderBy(), GroupByCompiler.GroupBy.EMPTY_GROUP_BY, plans, context.getBindManager().getParameterMetaData());
        return plan;
    }

    public QueryPlan compileSelect(SelectStatement select) throws SQLException {
        List<Object> binds = this.statement.getParameters();
        StatementContext context = new StatementContext(this.statement, this.resolver, this.bindManager, this.scan, this.sequenceManager);
        if (select.isJoin()) {
            JoinCompiler.JoinTable joinTable = JoinCompiler.compile(this.statement, select, context.getResolver());
            return this.compileJoinQuery(context, binds, joinTable, false, false, null);
        }
        return this.compileSingleQuery(context, select, binds, false, true);
    }

    protected QueryPlan compileJoinQuery(StatementContext context, List<Object> binds, JoinCompiler.JoinTable joinTable, boolean asSubquery, boolean projectPKColumns, List<OrderByNode> orderBy) throws SQLException {
        if (joinTable.getJoinSpecs().isEmpty()) {
            JoinCompiler.Table table = joinTable.getLeftTable();
            SelectStatement subquery = table.getAsSubquery(orderBy);
            if (!table.isSubselect()) {
                context.setCurrentTable(table.getTableRef());
                PTable projectedTable = table.createProjectedTable(!projectPKColumns, context);
                TupleProjector projector = new TupleProjector(projectedTable);
                boolean wildcardIncludesDynamicCols = context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.query.wildcard.dynamicColumns", false);
                TupleProjector.serializeProjectorIntoScan(context.getScan(), projector, wildcardIncludesDynamicCols);
                context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), subquery.getUdfParseNodes()));
                table.projectColumns(context.getScan());
                return this.compileSingleFlatQuery(context, subquery, binds, asSubquery, !asSubquery, null, true, false);
            }
            QueryPlan plan = this.compileSubquery(subquery, false);
            PTable projectedTable = table.createProjectedTable(plan.getProjector());
            context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), subquery.getUdfParseNodes()));
            return new TupleProjectionPlan(plan, new TupleProjector(plan.getProjector()), context, null);
        }
        List<JoinCompiler.Strategy> strategies = joinTable.getApplicableJoinStrategies();
        assert (strategies.size() > 0);
        if (!this.costBased || strategies.size() == 1) {
            return this.compileJoinQuery(strategies.get(0), context, binds, joinTable, asSubquery, projectPKColumns, orderBy);
        }
        StatementPlan bestPlan = null;
        Cost bestCost = null;
        for (JoinCompiler.Strategy strategy : strategies) {
            StatementContext newContext = new StatementContext(context.getStatement(), context.getResolver(), context.getBindManager(), new Scan(), context.getSequenceManager());
            QueryPlan plan = this.compileJoinQuery(strategy, newContext, binds, joinTable, asSubquery, projectPKColumns, orderBy);
            Cost cost = plan.getCost();
            if (bestPlan != null && cost.compareTo(bestCost) >= 0) continue;
            bestPlan = plan;
            bestCost = cost;
        }
        context.setResolver(bestPlan.getContext().getResolver());
        context.setCurrentTable(bestPlan.getContext().getCurrentTable());
        return bestPlan;
    }

    protected QueryPlan compileJoinQuery(JoinCompiler.Strategy strategy, StatementContext context, List<Object> binds, JoinCompiler.JoinTable joinTable, boolean asSubquery, boolean projectPKColumns, List<OrderByNode> orderBy) throws SQLException {
        byte[] emptyByteArray = new byte[]{};
        List<JoinCompiler.JoinSpec> joinSpecs = joinTable.getJoinSpecs();
        boolean wildcardIncludesDynamicCols = context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.query.wildcard.dynamicColumns", false);
        switch (strategy) {
            case HASH_BUILD_RIGHT: {
                JoinCompiler.JoinSpec joinSpec;
                int i;
                TupleProjector tupleProjector;
                SelectStatement query;
                TableRef tableRef;
                PTable initialProjectedTable;
                boolean[] starJoinVector = joinTable.getStarJoinVector();
                JoinCompiler.Table table = joinTable.getLeftTable();
                if (!table.isSubselect()) {
                    context.setCurrentTable(table.getTableRef());
                    initialProjectedTable = table.createProjectedTable(!projectPKColumns, context);
                    tableRef = table.getTableRef();
                    table.projectColumns(context.getScan());
                    query = joinTable.getAsSingleSubquery(table.getAsSubquery(orderBy), asSubquery);
                    tupleProjector = new TupleProjector(initialProjectedTable);
                } else {
                    SelectStatement subquery = table.getAsSubquery(orderBy);
                    QueryPlan plan = this.compileSubquery(subquery, false);
                    initialProjectedTable = table.createProjectedTable(plan.getProjector());
                    tableRef = plan.getTableRef();
                    context.getScan().setFamilyMap(plan.getContext().getScan().getFamilyMap());
                    query = joinTable.getAsSingleSubquery((SelectStatement)plan.getStatement(), asSubquery);
                    tupleProjector = new TupleProjector(plan.getProjector());
                }
                context.setCurrentTable(tableRef);
                PTable projectedTable = initialProjectedTable;
                int count = joinSpecs.size();
                ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[count];
                List[] joinExpressions = new List[count];
                JoinTableNode.JoinType[] joinTypes = new JoinTableNode.JoinType[count];
                PTable[] tables = new PTable[count];
                int[] fieldPositions = new int[count];
                StatementContext[] subContexts = new StatementContext[count];
                QueryPlan[] subPlans = new QueryPlan[count];
                HashJoinPlan.SubPlan[] hashPlans = new HashJoinPlan.HashSubPlan[count];
                fieldPositions[0] = projectedTable.getColumns().size() - projectedTable.getPKColumns().size();
                for (i = 0; i < count; ++i) {
                    joinSpec = joinSpecs.get(i);
                    Scan subScan = ScanUtil.newScan(this.originalScan);
                    subContexts[i] = new StatementContext(this.statement, context.getResolver(), context.getBindManager(), subScan, new SequenceManager(this.statement));
                    subPlans[i] = this.compileJoinQuery(subContexts[i], binds, joinSpec.getRhsJoinTable(), true, true, null);
                    boolean hasPostReference = joinSpec.getRhsJoinTable().hasPostReference();
                    if (hasPostReference) {
                        tables[i] = subContexts[i].getResolver().getTables().get(0).getTable();
                        projectedTable = JoinCompiler.joinProjectedTables(projectedTable, tables[i], joinSpec.getType());
                        continue;
                    }
                    tables[i] = null;
                }
                for (i = 0; i < count; ++i) {
                    joinSpec = joinSpecs.get(i);
                    context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), query.getUdfParseNodes()));
                    joinIds[i] = new ImmutableBytesPtr(emptyByteArray);
                    Pair<List<Expression>, List<Expression>> joinConditions = joinSpec.compileJoinConditions(context, subContexts[i], strategy);
                    joinExpressions[i] = (List)joinConditions.getFirst();
                    List hashExpressions = (List)joinConditions.getSecond();
                    Pair keyRangeExpressions = new Pair(null, null);
                    boolean optimized = this.getKeyExpressionCombinations((Pair<Expression, Expression>)keyRangeExpressions, context, joinTable.getOriginalJoinSelectStatement(), tableRef, joinSpec.getType(), joinExpressions[i], hashExpressions);
                    Expression keyRangeLhsExpression = (Expression)keyRangeExpressions.getFirst();
                    Expression keyRangeRhsExpression = (Expression)keyRangeExpressions.getSecond();
                    joinTypes[i] = joinSpec.getType();
                    if (i < count - 1) {
                        fieldPositions[i + 1] = fieldPositions[i] + (tables[i] == null ? 0 : tables[i].getColumns().size() - tables[i].getPKColumns().size());
                    }
                    hashPlans[i] = new HashJoinPlan.HashSubPlan(i, subPlans[i], optimized ? null : hashExpressions, joinSpec.isSingleValueOnly(), this.usePersistentCache, keyRangeLhsExpression, keyRangeRhsExpression);
                }
                TupleProjector.serializeProjectorIntoScan(context.getScan(), tupleProjector, wildcardIncludesDynamicCols);
                QueryPlan plan = this.compileSingleFlatQuery(context, query, binds, asSubquery, !asSubquery && joinTable.isAllLeftJoin(), null, true, false);
                Expression postJoinFilterExpression = joinTable.compilePostFilterExpression(context);
                Integer limit = null;
                Integer offset = null;
                if (!query.isAggregate() && !query.isDistinct() && query.getOrderBy().isEmpty()) {
                    limit = plan.getLimit();
                    offset = plan.getOffset();
                }
                HashJoinInfo joinInfo = new HashJoinInfo(projectedTable, joinIds, joinExpressions, joinTypes, starJoinVector, tables, fieldPositions, postJoinFilterExpression, QueryUtil.getOffsetLimit(limit, offset));
                return HashJoinPlan.create(joinTable.getOriginalJoinSelectStatement(), plan, joinInfo, hashPlans);
            }
            case HASH_BUILD_LEFT: {
                int fieldPosition;
                TupleProjector tupleProjector;
                SelectStatement rhs;
                TableRef rhsTableRef;
                PTable rhsProjTable;
                JoinCompiler.JoinSpec lastJoinSpec = joinSpecs.get(joinSpecs.size() - 1);
                JoinTableNode.JoinType type = lastJoinSpec.getType();
                JoinCompiler.JoinTable rhsJoinTable = lastJoinSpec.getRhsJoinTable();
                JoinCompiler.Table rhsTable = rhsJoinTable.getLeftTable();
                JoinCompiler.JoinTable lhsJoin = joinTable.createSubJoinTable(this.statement.getConnection());
                Scan subScan = ScanUtil.newScan(this.originalScan);
                StatementContext lhsCtx = new StatementContext(this.statement, context.getResolver(), context.getBindManager(), subScan, new SequenceManager(this.statement));
                QueryPlan lhsPlan = this.compileJoinQuery(lhsCtx, binds, lhsJoin, true, true, null);
                if (!rhsTable.isSubselect()) {
                    context.setCurrentTable(rhsTable.getTableRef());
                    rhsProjTable = rhsTable.createProjectedTable(!projectPKColumns, context);
                    rhsTableRef = rhsTable.getTableRef();
                    rhsTable.projectColumns(context.getScan());
                    rhs = rhsJoinTable.getAsSingleSubquery(rhsTable.getAsSubquery(orderBy), asSubquery);
                    tupleProjector = new TupleProjector(rhsProjTable);
                } else {
                    SelectStatement subquery = rhsTable.getAsSubquery(orderBy);
                    QueryPlan plan = this.compileSubquery(subquery, false);
                    rhsProjTable = rhsTable.createProjectedTable(plan.getProjector());
                    rhsTableRef = plan.getTableRef();
                    context.getScan().setFamilyMap(plan.getContext().getScan().getFamilyMap());
                    rhs = rhsJoinTable.getAsSingleSubquery((SelectStatement)plan.getStatement(), asSubquery);
                    tupleProjector = new TupleProjector(plan.getProjector());
                }
                context.setCurrentTable(rhsTableRef);
                context.setResolver(FromCompiler.getResolverForProjectedTable(rhsProjTable, context.getConnection(), rhs.getUdfParseNodes()));
                ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[]{new ImmutableBytesPtr(emptyByteArray)};
                Pair<List<Expression>, List<Expression>> joinConditions = lastJoinSpec.compileJoinConditions(lhsCtx, context, strategy);
                List joinExpressions = (List)joinConditions.getSecond();
                List hashExpressions = (List)joinConditions.getFirst();
                boolean needsMerge = lhsJoin.hasPostReference();
                PTable lhsTable = needsMerge ? lhsCtx.getResolver().getTables().get(0).getTable() : null;
                int n = fieldPosition = needsMerge ? rhsProjTable.getColumns().size() - rhsProjTable.getPKColumns().size() : 0;
                PTable projectedTable = needsMerge ? JoinCompiler.joinProjectedTables(rhsProjTable, lhsTable, type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type) : rhsProjTable;
                TupleProjector.serializeProjectorIntoScan(context.getScan(), tupleProjector, wildcardIncludesDynamicCols);
                context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), rhs.getUdfParseNodes()));
                QueryPlan rhsPlan = this.compileSingleFlatQuery(context, rhs, binds, asSubquery, !asSubquery && type == JoinTableNode.JoinType.Right, null, true, false);
                Expression postJoinFilterExpression = joinTable.compilePostFilterExpression(context);
                Integer limit = null;
                Integer offset = null;
                if (!rhs.isAggregate() && !rhs.isDistinct() && rhs.getOrderBy().isEmpty()) {
                    limit = rhsPlan.getLimit();
                    offset = rhsPlan.getOffset();
                }
                HashJoinInfo joinInfo = new HashJoinInfo(projectedTable, joinIds, new List[]{joinExpressions}, new JoinTableNode.JoinType[]{type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type}, new boolean[]{true}, new PTable[]{lhsTable}, new int[]{fieldPosition}, postJoinFilterExpression, QueryUtil.getOffsetLimit(limit, offset));
                boolean usePersistentCache = joinTable.getOriginalJoinSelectStatement().getHint().hasHint(HintNode.Hint.USE_PERSISTENT_CACHE);
                Pair keyRangeExpressions = new Pair(null, null);
                this.getKeyExpressionCombinations((Pair<Expression, Expression>)keyRangeExpressions, context, joinTable.getOriginalJoinSelectStatement(), rhsTableRef, type, joinExpressions, hashExpressions);
                return HashJoinPlan.create(joinTable.getOriginalJoinSelectStatement(), rhsPlan, joinInfo, new HashJoinPlan.HashSubPlan[]{new HashJoinPlan.HashSubPlan(0, lhsPlan, hashExpressions, false, usePersistentCache, (Expression)keyRangeExpressions.getFirst(), (Expression)keyRangeExpressions.getSecond())});
            }
            case SORT_MERGE: {
                int fieldPosition;
                JoinCompiler.JoinTable lhsJoin = joinTable.createSubJoinTable(this.statement.getConnection());
                JoinCompiler.JoinSpec lastJoinSpec = joinSpecs.get(joinSpecs.size() - 1);
                JoinTableNode.JoinType type = lastJoinSpec.getType();
                JoinCompiler.JoinTable rhsJoin = lastJoinSpec.getRhsJoinTable();
                if (type == JoinTableNode.JoinType.Right) {
                    JoinCompiler.JoinTable temp = lhsJoin;
                    lhsJoin = rhsJoin;
                    rhsJoin = temp;
                }
                List<EqualParseNode> joinConditionNodes = lastJoinSpec.getOnConditions();
                ArrayList lhsOrderBy = Lists.newArrayListWithExpectedSize((int)joinConditionNodes.size());
                ArrayList rhsOrderBy = Lists.newArrayListWithExpectedSize((int)joinConditionNodes.size());
                for (EqualParseNode condition : joinConditionNodes) {
                    lhsOrderBy.add(NODE_FACTORY.orderBy(type == JoinTableNode.JoinType.Right ? condition.getRHS() : condition.getLHS(), false, true));
                    rhsOrderBy.add(NODE_FACTORY.orderBy(type == JoinTableNode.JoinType.Right ? condition.getLHS() : condition.getRHS(), false, true));
                }
                Scan lhsScan = ScanUtil.newScan(this.originalScan);
                StatementContext lhsCtx = new StatementContext(this.statement, context.getResolver(), context.getBindManager(), lhsScan, new SequenceManager(this.statement));
                boolean preserveRowkey = !projectPKColumns && type != JoinTableNode.JoinType.Full;
                QueryPlan lhsPlan = this.compileJoinQuery(lhsCtx, binds, lhsJoin, true, !preserveRowkey, lhsOrderBy);
                PTable lhsProjTable = lhsCtx.getResolver().getTables().get(0).getTable();
                Scan rhsScan = ScanUtil.newScan(this.originalScan);
                StatementContext rhsCtx = new StatementContext(this.statement, context.getResolver(), context.getBindManager(), rhsScan, new SequenceManager(this.statement));
                QueryPlan rhsPlan = this.compileJoinQuery(rhsCtx, binds, rhsJoin, true, true, rhsOrderBy);
                PTable rhsProjTable = rhsCtx.getResolver().getTables().get(0).getTable();
                Pair<List<Expression>, List<Expression>> joinConditions = lastJoinSpec.compileJoinConditions(type == JoinTableNode.JoinType.Right ? rhsCtx : lhsCtx, type == JoinTableNode.JoinType.Right ? lhsCtx : rhsCtx, strategy);
                List lhsKeyExpressions = type == JoinTableNode.JoinType.Right ? (List)joinConditions.getSecond() : (List)joinConditions.getFirst();
                List rhsKeyExpressions = type == JoinTableNode.JoinType.Right ? (List)joinConditions.getFirst() : (List)joinConditions.getSecond();
                boolean needsMerge = rhsJoin.hasPostReference();
                int n = fieldPosition = needsMerge ? lhsProjTable.getColumns().size() - lhsProjTable.getPKColumns().size() : 0;
                PTable projectedTable = needsMerge ? JoinCompiler.joinProjectedTables(lhsProjTable, rhsProjTable, type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type) : lhsProjTable;
                ColumnResolver resolver = FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), joinTable.getOriginalJoinSelectStatement().getUdfParseNodes());
                TableRef tableRef = resolver.getTables().get(0);
                StatementContext subCtx = new StatementContext(this.statement, resolver, context.getBindManager(), ScanUtil.newScan(this.originalScan), new SequenceManager(this.statement));
                subCtx.setCurrentTable(tableRef);
                SortMergeJoinPlan innerPlan = new SortMergeJoinPlan(subCtx, joinTable.getOriginalJoinSelectStatement(), tableRef, type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type, lhsPlan, rhsPlan, (Pair<List<Expression>, List<Expression>>)new Pair((Object)lhsKeyExpressions, (Object)rhsKeyExpressions), rhsKeyExpressions, projectedTable, lhsProjTable, needsMerge ? rhsProjTable : null, fieldPosition, lastJoinSpec.isSingleValueOnly(), (Pair<List<OrderByNode>, List<OrderByNode>>)new Pair((Object)lhsOrderBy, (Object)rhsOrderBy));
                context.setCurrentTable(tableRef);
                context.setResolver(resolver);
                NamedTableNode from = NODE_FACTORY.namedTable(tableRef.getTableAlias(), NODE_FACTORY.table(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getTableName().getString()));
                ParseNode where = joinTable.getPostFiltersCombined();
                SelectStatement select = asSubquery ? NODE_FACTORY.select(from, joinTable.getOriginalJoinSelectStatement().getHint(), false, Collections.emptyList(), where, null, null, orderBy, null, null, 0, false, joinTable.getOriginalJoinSelectStatement().hasSequence(), Collections.emptyList(), joinTable.getOriginalJoinSelectStatement().getUdfParseNodes()) : NODE_FACTORY.select(joinTable.getOriginalJoinSelectStatement(), from, where);
                return this.compileSingleFlatQuery(context, select, binds, asSubquery, false, innerPlan, true, false);
            }
        }
        throw new IllegalArgumentException("Invalid join strategy '" + (Object)((Object)strategy) + "'");
    }

    private boolean getKeyExpressionCombinations(Pair<Expression, Expression> combination, StatementContext context, SelectStatement select, TableRef table, JoinTableNode.JoinType type, List<Expression> joinExpressions, List<Expression> hashExpressions) throws SQLException {
        if (type != JoinTableNode.JoinType.Inner && type != JoinTableNode.JoinType.Semi || this.noChildParentJoinOptimization) {
            return false;
        }
        Scan scanCopy = ScanUtil.newScan(context.getScan());
        StatementContext contextCopy = new StatementContext(this.statement, context.getResolver(), context.getBindManager(), scanCopy, new SequenceManager(this.statement));
        contextCopy.setCurrentTable(table);
        ArrayList lhsCombination = Lists.newArrayList();
        boolean complete = WhereOptimizer.getKeyExpressionCombination(lhsCombination, contextCopy, select, joinExpressions);
        if (lhsCombination.isEmpty()) {
            return false;
        }
        ArrayList rhsCombination = Lists.newArrayListWithExpectedSize((int)lhsCombination.size());
        block0: for (int i = 0; i < lhsCombination.size(); ++i) {
            Expression lhs = (Expression)lhsCombination.get(i);
            for (int j = 0; j < joinExpressions.size(); ++j) {
                if (lhs != joinExpressions.get(j)) continue;
                rhsCombination.add(hashExpressions.get(j));
                continue block0;
            }
        }
        if (lhsCombination.size() == 1) {
            combination.setFirst(lhsCombination.get(0));
            combination.setSecond(rhsCombination.get(0));
        } else {
            combination.setFirst((Object)new RowValueConstructorExpression(lhsCombination, false));
            combination.setSecond((Object)new RowValueConstructorExpression(rhsCombination, false));
        }
        return type == JoinTableNode.JoinType.Semi && complete;
    }

    protected QueryPlan compileSubquery(SelectStatement subquerySelectStatement, boolean pushDownMaxRows) throws SQLException {
        PhoenixConnection phoenixConnection = this.statement.getConnection();
        ParseNodeUtil.RewriteResult rewriteResult = ParseNodeUtil.rewrite(subquerySelectStatement, phoenixConnection);
        int maxRows = this.statement.getMaxRows();
        this.statement.setMaxRows(pushDownMaxRows ? maxRows : 0);
        QueryPlan queryPlan = new QueryCompiler(this.statement, rewriteResult.getRewrittenSelectStatement(), rewriteResult.getColumnResolver(), this.bindManager, false, this.optimizeSubquery, null).compile();
        if (this.optimizeSubquery) {
            queryPlan = this.statement.getConnection().getQueryServices().getOptimizer().optimize(this.statement, queryPlan);
        }
        this.statement.setMaxRows(maxRows);
        return queryPlan;
    }

    protected QueryPlan compileSingleQuery(StatementContext context, SelectStatement select, List<Object> binds, boolean asSubquery, boolean allowPageFilter) throws SQLException {
        SelectStatement innerSelect = select.getInnerSelectStatement();
        if (innerSelect == null) {
            return this.compileSingleFlatQuery(context, select, binds, asSubquery, allowPageFilter, null, false, false);
        }
        if (innerSelect.getOffset() != null && !innerSelect.getOffset().isIntegerOffset() || select.getOffset() != null && !select.getOffset().isIntegerOffset()) {
            throw new SQLException("RVC Offset not allowed with subqueries.");
        }
        QueryPlan innerPlan = this.compileSubquery(innerSelect, false);
        RowProjector innerQueryPlanRowProjector = innerPlan.getProjector();
        TupleProjector tupleProjector = new TupleProjector(innerQueryPlanRowProjector);
        TableRef tableRef = context.getResolver().getTables().get(0);
        ColumnResolver resolver = FromCompiler.getResolverForCompiledDerivedTable(this.statement.getConnection(), tableRef, innerQueryPlanRowProjector);
        context.setResolver(resolver);
        tableRef = resolver.getTables().get(0);
        context.setCurrentTable(tableRef);
        innerPlan = new TupleProjectionPlan(innerPlan, tupleProjector, context, null);
        return this.compileSingleFlatQuery(context, select, binds, asSubquery, allowPageFilter, innerPlan, false, false);
    }

    protected QueryPlan compileSingleFlatQuery(StatementContext context, SelectStatement select, List<Object> binds, boolean asSubquery, boolean allowPageFilter, QueryPlan innerPlan, boolean inJoin, boolean inUnion) throws SQLException {
        SelectStatement planSelect;
        int maxRows;
        boolean isApplicable = true;
        PTable projectedTable = null;
        if (this.projectTuples && (projectedTable = TupleProjectionCompiler.createProjectedTable(select, context)) != null) {
            context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), select.getUdfParseNodes()));
        }
        ColumnResolver resolver = context.getResolver();
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        ParseNode viewWhere = null;
        if (table.getViewStatement() != null) {
            viewWhere = new SQLParser(table.getViewStatement()).parseQuery().getWhere();
        }
        Integer limit = LimitCompiler.compile(context, select);
        CompiledOffset compiledOffset = null;
        Integer offset = null;
        try {
            compiledOffset = OffsetCompiler.getOffsetCompiler().compile(context, select, inJoin, inUnion);
            offset = (Integer)compiledOffset.getIntegerOffset().orNull();
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            compiledOffset = new CompiledOffset((Optional<Integer>)Optional.absent(), (Optional<byte[]>)Optional.absent());
            isApplicable = false;
        }
        GroupByCompiler.GroupBy groupBy = GroupByCompiler.compile(context, select);
        select = HavingCompiler.rewrite(context, select, groupBy);
        Expression having = HavingCompiler.compile(context, select, groupBy);
        if (innerPlan == null && !tableRef.equals(resolver.getTables().get(0))) {
            context.setResolver(FromCompiler.getResolver(context.getConnection(), tableRef, select.getUdfParseNodes()));
        }
        HashSet subqueries = Sets.newHashSet();
        Expression where = WhereCompiler.compile(context, select, viewWhere, subqueries, compiledOffset.getByteOffset());
        groupBy = groupBy.compile(context, innerPlan, where);
        context.setResolver(resolver);
        boolean wildcardIncludesDynamicCols = context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.query.wildcard.dynamicColumns", false);
        RowProjector projector = ProjectionCompiler.compile(context, select, groupBy, asSubquery ? Collections.emptyList() : this.targetColumns, where, wildcardIncludesDynamicCols);
        OrderByCompiler.OrderBy orderBy = OrderByCompiler.compile(context, select, groupBy, limit, compiledOffset, projector, innerPlan, where);
        context.getAggregationManager().compile(context, groupBy);
        if (!asSubquery && (maxRows = this.statement.getMaxRows()) > 0) {
            limit = limit != null ? Integer.valueOf(Math.min(limit, maxRows)) : Integer.valueOf(maxRows);
        }
        if (projectedTable != null) {
            TupleProjector.serializeProjectorIntoScan(context.getScan(), new TupleProjector(projectedTable), wildcardIncludesDynamicCols && projector.projectDynColsInWildcardQueries());
        }
        QueryPlan plan = innerPlan;
        QueryPlan dataPlan = this.dataPlans.get(tableRef);
        if (plan == null) {
            ParallelIteratorFactory parallelIteratorFactory;
            ParallelIteratorFactory parallelIteratorFactory2 = parallelIteratorFactory = asSubquery ? null : this.parallelIteratorFactory;
            plan = select.getFrom() == null ? new LiteralResultIterationPlan(context, select, tableRef, projector, limit, offset, orderBy, parallelIteratorFactory) : (select.isAggregate() || select.isDistinct() ? new AggregatePlan(context, select, tableRef, projector, limit, offset, orderBy, parallelIteratorFactory, groupBy, having, dataPlan) : new ScanPlan(context, select, tableRef, projector, limit, offset, orderBy, parallelIteratorFactory, allowPageFilter, dataPlan, compiledOffset.getByteOffset()));
        }
        SelectStatement selectStatement = planSelect = asSubquery ? select : this.select;
        if (!subqueries.isEmpty()) {
            int count = subqueries.size();
            HashJoinPlan.SubPlan[] subPlans = new HashJoinPlan.WhereClauseSubPlan[count];
            int i = 0;
            for (SubqueryParseNode subqueryNode : subqueries) {
                SelectStatement stmt = subqueryNode.getSelectNode();
                subPlans[i++] = new HashJoinPlan.WhereClauseSubPlan(this.compileSubquery(stmt, false), stmt, subqueryNode.expectSingleRow());
            }
            plan = HashJoinPlan.create(planSelect, plan, null, subPlans);
        }
        if (innerPlan != null) {
            if (LiteralExpression.isTrue(where)) {
                where = null;
            }
            QueryPlan queryPlan = plan = select.isAggregate() || select.isDistinct() ? new ClientAggregatePlan(context, planSelect, tableRef, projector, limit, offset, where, orderBy, groupBy, having, plan) : new ClientScanPlan(context, planSelect, tableRef, projector, limit, offset, where, orderBy, plan);
        }
        if (plan instanceof BaseQueryPlan) {
            ((BaseQueryPlan)plan).setApplicable(isApplicable);
        }
        return plan;
    }
}

