/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class DeclareCursorCompiler {
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;
    private QueryPlan queryPlan;

    public DeclareCursorCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation, QueryPlan queryPlan) throws SQLException {
        this.statement = statement;
        this.operation = operation;
        this.queryPlan = statement.getConnection().getQueryServices().getOptimizer().optimize(statement, queryPlan);
    }

    public MutationPlan compile(final DeclareCursorStatement declare) throws SQLException {
        if (declare.getBindCount() != 0) {
            throw new SQLException("Cannot declare cursor, internal SELECT statement contains bindings!");
        }
        PhoenixConnection connection = this.statement.getConnection();
        StatementContext context = new StatementContext(this.statement);
        final MetaDataClient client = new MetaDataClient(connection);
        return new BaseMutationPlan(context, this.operation){

            @Override
            public MutationState execute() throws SQLException {
                return client.declareCursor(declare, DeclareCursorCompiler.this.queryPlan);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("DECLARE CURSOR"));
            }
        };
    }
}

