/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache.aggcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.aggcache.SpillFile;
import org.apache.phoenix.cache.aggcache.SpillMap;
import org.apache.phoenix.cache.aggcache.SpillableGroupByCache;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.TupleUtil;

public class SpillManager
implements Closeable {
    private final ArrayList<SpillMap> spillMaps;
    private final int numSpillFiles;
    private final ServerAggregators aggregators;
    private final Configuration conf;

    public SpillManager(int numSpillFiles, ServerAggregators serverAggregators, Configuration conf, SpillableGroupByCache.QueryCache cache) {
        try {
            int estValueSize = serverAggregators.getEstimatedByteSize();
            this.spillMaps = Lists.newArrayList();
            this.numSpillFiles = numSpillFiles;
            this.aggregators = serverAggregators;
            this.conf = conf;
            File spillFilesDir = conf.get("phoenix.spool.directory") != null ? new File(conf.get("phoenix.spool.directory")) : null;
            Preconditions.checkArgument((4096 > estValueSize ? 1 : 0) != 0);
            for (int i = 0; i < numSpillFiles; ++i) {
                SpillFile file = SpillFile.createSpillFile(spillFilesDir);
                this.spillMaps.add(new SpillMap(file, 4096, estValueSize, cache));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not init the SpillManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(ImmutableBytesPtr key, Aggregator[] aggs, ServerAggregators serverAggs) throws IOException {
        FilterOutputStream output = null;
        ByteArrayOutputStream bai = null;
        try {
            bai = new ByteArrayOutputStream();
            output = new DataOutputStream(bai);
            WritableUtils.writeVInt((DataOutput)((Object)output), (int)key.getLength());
            ((DataOutputStream)output).write(key.get(), key.getOffset(), key.getLength());
            byte[] aggsByte = serverAggs.toBytes(aggs);
            WritableUtils.writeVInt((DataOutput)((Object)output), (int)aggsByte.length);
            output.write(aggsByte);
            byte[] byArray = bai.toByteArray();
            return byArray;
        }
        finally {
            if (bai != null) {
                bai.close();
                bai = null;
            }
            if (output != null) {
                output.close();
                output = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImmutableBytesPtr getKey(byte[] data) throws IOException {
        FilterInputStream input = null;
        try {
            input = new DataInputStream(new ByteArrayInputStream(data));
            int keyLength = WritableUtils.readVInt((DataInput)((Object)input));
            int offset = WritableUtils.getVIntSize((long)keyLength);
            ImmutableBytesPtr immutableBytesPtr = new ImmutableBytesPtr(data, offset, keyLength);
            return immutableBytesPtr;
        }
        finally {
            if (input != null) {
                input.close();
                input = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Aggregator[] getAggregators(byte[] data) throws IOException {
        Aggregator[] aggregatorArray;
        DataInputStream input = null;
        try {
            Boolean hasValue;
            input = new DataInputStream(new ByteArrayInputStream(data));
            int keyLength = WritableUtils.readVInt((DataInput)input);
            int vIntKeyLength = WritableUtils.getVIntSize((long)keyLength);
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(data, vIntKeyLength, keyLength);
            input.skip(keyLength);
            int valueLength = WritableUtils.readVInt((DataInput)input);
            int vIntValLength = WritableUtils.getVIntSize((long)keyLength);
            Cell keyValue = PhoenixKeyValueUtil.newKeyValue(ptr.get(), ptr.getOffset(), ptr.getLength(), QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, data, vIntKeyLength + keyLength + vIntValLength, valueLength);
            SingleKeyValueTuple result = new SingleKeyValueTuple(keyValue);
            TupleUtil.getAggregateValue(result, ptr);
            KeyValueSchema schema = this.aggregators.getValueSchema();
            ValueBitSet tempValueSet = ValueBitSet.newInstance(schema);
            tempValueSet.clear();
            tempValueSet.or(ptr);
            int i = 0;
            int maxOffset = ptr.getOffset() + ptr.getLength();
            SingleAggregateFunction[] funcArray = this.aggregators.getFunctions();
            Aggregator[] sAggs = new Aggregator[funcArray.length];
            schema.iterator(ptr);
            while ((hasValue = schema.next(ptr, i, maxOffset, tempValueSet)) != null) {
                SingleAggregateFunction func = funcArray[i];
                sAggs[i++] = hasValue != false ? func.newServerAggregator(this.conf, ptr) : func.newServerAggregator(this.conf);
            }
            aggregatorArray = sAggs;
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(input);
            throw throwable;
        }
        Closeables.closeQuietly(input);
        return aggregatorArray;
    }

    public <K extends ImmutableBytesWritable> CacheEntry<K> toCacheEntry(byte[] bytes) throws IOException {
        ImmutableBytesPtr key = SpillManager.getKey(bytes);
        Aggregator[] aggs = this.getAggregators(bytes);
        return new CacheEntry<ImmutableBytesPtr>(key, aggs);
    }

    private int getPartition(ImmutableBytesWritable key) {
        return (int)(Math.abs((long)key.hashCode()) % (long)this.numSpillFiles);
    }

    public void spill(ImmutableBytesWritable key, Aggregator[] value) throws IOException {
        SpillMap spillMap = this.spillMaps.get(this.getPartition(key));
        ImmutableBytesPtr keyPtr = new ImmutableBytesPtr(key);
        byte[] data = this.serialize(keyPtr, value, this.aggregators);
        spillMap.put(keyPtr, data);
    }

    public Aggregator[] loadEntry(ImmutableBytesWritable key) throws IOException {
        SpillMap spillMap = this.spillMaps.get(this.getPartition(key));
        byte[] data = spillMap.get(key);
        if (data != null) {
            return this.getAggregators(data);
        }
        return null;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.spillMaps.size(); ++i) {
            Closeables.closeQuietly(this.spillMaps.get(i).getSpillFile());
        }
    }

    public SpillMapIterator newDataIterator() {
        return new SpillMapIterator();
    }

    private final class SpillMapIterator
    implements Iterator<byte[]> {
        int index = 0;
        Iterator<byte[]> spillIter = ((SpillMap)SpillManager.access$100(SpillManager.this).get(this.index)).iterator();

        private SpillMapIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.spillIter.hasNext() && this.index < SpillManager.this.numSpillFiles - 1) {
                this.spillIter = ((SpillMap)SpillManager.this.spillMaps.get(++this.index)).iterator();
            }
            return this.spillIter.hasNext();
        }

        @Override
        public byte[] next() {
            return this.spillIter.next();
        }

        @Override
        public void remove() {
            throw new IllegalAccessError("Remove is not supported for this type of iterator");
        }
    }

    public static class CacheEntry<T extends ImmutableBytesWritable>
    implements Map.Entry<T, Aggregator[]> {
        protected T key;
        protected Aggregator[] aggs;

        public CacheEntry(T key, Aggregator[] aggs) {
            this.key = key;
            this.aggs = aggs;
        }

        public Aggregator[] getValue(Configuration conf) {
            return this.aggs;
        }

        public int getKeyLength() {
            return this.key.getLength();
        }

        @Override
        public Aggregator[] getValue() {
            return this.aggs;
        }

        @Override
        public Aggregator[] setValue(Aggregator[] arg0) {
            this.aggs = arg0;
            return this.aggs;
        }

        @Override
        public T getKey() {
            return this.key;
        }
    }
}

