/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import java.util.List;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.mongo.DrillMongoConstants;
import org.apache.drill.exec.store.mongo.MongoCompareFunctionProcessor;
import org.apache.drill.exec.store.mongo.MongoUtils;
import org.apache.drill.exec.store.mongo.common.MongoOp;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoFilterBuilder
extends AbstractExprVisitor<Document, Void, RuntimeException>
implements DrillMongoConstants {
    private static final Logger logger = LoggerFactory.getLogger(MongoFilterBuilder.class);
    private final LogicalExpression le;
    private boolean allExpressionsConverted = true;

    public MongoFilterBuilder(LogicalExpression conditionExp) {
        this.le = conditionExp;
    }

    public Document parseTree() {
        return (Document)this.le.accept((ExprVisitor)this, null);
    }

    private Document mergeFilters(String functionName, Document left, Document right) {
        Document newFilter = new Document();
        switch (functionName) {
            case "booleanAnd": {
                if (left != null && right != null) {
                    newFilter = MongoUtils.andFilterAtIndex(left, right);
                    break;
                }
                if (left != null) {
                    newFilter = left;
                    break;
                }
                newFilter = right;
                break;
            }
            case "booleanOr": {
                newFilter = MongoUtils.orFilterAtIndex(left, right);
            }
        }
        return newFilter;
    }

    public boolean isAllExpressionsConverted() {
        return this.allExpressionsConverted;
    }

    public Document visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        this.allExpressionsConverted = false;
        return null;
    }

    public Document visitBooleanOperator(BooleanOperator op, Void value) {
        List args = op.args();
        Document condition = null;
        String functionName = op.getName();
        for (LogicalExpression arg : args) {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    if (condition == null) {
                        condition = (Document)arg.accept((ExprVisitor)this, null);
                        break;
                    }
                    Document scanSpec = (Document)arg.accept((ExprVisitor)this, null);
                    if (scanSpec != null) {
                        condition = this.mergeFilters(functionName, condition, scanSpec);
                        break;
                    }
                    this.allExpressionsConverted = false;
                }
            }
        }
        return condition;
    }

    public Document visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        Document functionCall = null;
        String functionName = call.getName();
        List args = call.args();
        if (MongoCompareFunctionProcessor.isCompareFunction(functionName)) {
            MongoCompareFunctionProcessor processor = MongoCompareFunctionProcessor.process(call);
            if (processor.isSuccess()) {
                try {
                    functionCall = this.createFunctionCall(processor.getFunctionName(), processor.getPath(), processor.getValue());
                }
                catch (Exception e) {
                    logger.error(" Failed to creare Filter ", (Throwable)e);
                }
            }
        } else {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    Document left = (Document)((LogicalExpression)args.get(0)).accept((ExprVisitor)this, null);
                    Document right = (Document)((LogicalExpression)args.get(1)).accept((ExprVisitor)this, null);
                    if (left != null && right != null) {
                        functionCall = this.mergeFilters(functionName, left, right);
                        break;
                    }
                    this.allExpressionsConverted = false;
                    if (!"booleanAnd".equals(functionName)) break;
                    Document document = functionCall = left == null ? right : left;
                }
            }
        }
        if (functionCall == null) {
            this.allExpressionsConverted = false;
        }
        return functionCall;
    }

    private Document createFunctionCall(String functionName, SchemaPath field, Object fieldValue) {
        String fieldName = field.getRootSegmentPath();
        MongoOp compareOp = null;
        switch (functionName) {
            case "equal": {
                compareOp = MongoOp.EQUAL;
                break;
            }
            case "not_equal": {
                compareOp = MongoOp.NOT_EQUAL;
                break;
            }
            case "greater_than_or_equal_to": {
                compareOp = MongoOp.GREATER_OR_EQUAL;
                break;
            }
            case "greater_than": {
                compareOp = MongoOp.GREATER;
                break;
            }
            case "less_than_or_equal_to": {
                compareOp = MongoOp.LESS_OR_EQUAL;
                break;
            }
            case "less_than": {
                compareOp = MongoOp.LESS;
                break;
            }
            case "isnull": 
            case "isNull": 
            case "is null": {
                compareOp = MongoOp.IFNULL;
                break;
            }
            case "isnotnull": 
            case "isNotNull": 
            case "is not null": {
                compareOp = MongoOp.IFNOTNULL;
            }
        }
        if (compareOp != null) {
            Document queryFilter = new Document();
            if (compareOp == MongoOp.IFNULL) {
                queryFilter.put(fieldName, (Object)new Document(MongoOp.EQUAL.getCompareOp(), null));
            } else if (compareOp == MongoOp.IFNOTNULL) {
                queryFilter.put(fieldName, (Object)new Document(MongoOp.NOT_EQUAL.getCompareOp(), null));
            } else {
                queryFilter.put(fieldName, (Object)new Document(compareOp.getCompareOp(), fieldValue));
            }
            return queryFilter;
        }
        return null;
    }
}

