/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.resource.AbstractResource;
import liquibase.resource.InputStreamList;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;
import liquibase.util.CollectionUtil;
import liquibase.util.FileUtil;

public interface ResourceAccessor
extends AutoCloseable {
    @Deprecated
    default public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        InputStreamList returnList = new InputStreamList();
        if (relativeTo != null) {
            Resource relativeToResource = this.get(relativeTo);
            streamPath = relativeToResource.resolveSibling(streamPath).getPath();
        }
        for (Resource resource : CollectionUtil.createIfNull(this.getAll(streamPath))) {
            returnList.add(resource.getUri(), resource.openInputStream());
        }
        return returnList;
    }

    @Deprecated
    default public InputStream openStream(String relativeTo, String streamPath) throws IOException {
        Resource resource;
        if (relativeTo != null) {
            streamPath = this.get(relativeTo).resolveSibling(streamPath).getPath();
        }
        if (!(resource = this.get(streamPath)).exists()) {
            return null;
        }
        return resource.openInputStream();
    }

    @Deprecated
    default public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        TreeSet<String> returnList = new TreeSet<String>();
        if (includeFiles) {
            if (relativeTo != null) {
                path = this.get(relativeTo).resolveSibling(path).getPath();
            }
            for (Resource resource : this.search(path, recursive)) {
                returnList.add(resource.getPath());
            }
        } else {
            throw new UnexpectedLiquibaseException("ResourceAccessor can no longer search only for directories");
        }
        return returnList;
    }

    public List<Resource> search(String var1, boolean var2) throws IOException;

    public List<Resource> getAll(String var1) throws IOException;

    default public Resource getExisting(String path) throws IOException {
        Resource resource = this.get(path);
        if (!resource.exists()) {
            throw new FileNotFoundException(FileUtil.getFileNotFoundMessage(path));
        }
        return resource;
    }

    default public Resource get(String path) throws IOException {
        List<Resource> resources = this.getAll(path);
        if (resources == null || resources.size() == 0) {
            return new NotFoundResource(path, this);
        }
        if (resources.size() == 1) {
            return resources.iterator().next();
        }
        String message = "Found " + resources.size() + " files with the path '" + path + "':" + System.lineSeparator();
        for (Resource resource : resources) {
            message = message + "    - " + resource.getUri() + System.lineSeparator();
        }
        message = message + "  Search Path: " + System.lineSeparator();
        for (String location : Scope.getCurrentScope().getResourceAccessor().describeLocations()) {
            message = message + "    - " + location + System.lineSeparator();
        }
        message = message + "  You can limit the search path to remove duplicates with the liquibase.searchPath setting.";
        GlobalConfiguration.DuplicateFileMode mode = GlobalConfiguration.DUPLICATE_FILE_MODE.getCurrentValue();
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        if (mode == GlobalConfiguration.DuplicateFileMode.ERROR) {
            throw new IOException(message + " Or, if you KNOW these are the exact same file you can set liquibase.duplicateFileMode=WARN.");
        }
        if (mode == GlobalConfiguration.DuplicateFileMode.WARN) {
            Resource resource = resources.iterator().next();
            String warnMessage = message + System.lineSeparator() + "  To fail when duplicates are found, set liquibase.duplicateFileMode=ERROR" + System.lineSeparator() + "  Choosing: " + resource.getUri();
            Scope.getCurrentScope().getUI().sendMessage(warnMessage);
            log.warning(warnMessage);
        }
        return resources.iterator().next();
    }

    public List<String> describeLocations();

    public static class NotFoundResource
    extends AbstractResource {
        private ResourceAccessor resourceAccessor;

        public NotFoundResource(String path, ResourceAccessor resourceAccessor) {
            super(path, URI.create("resourceaccessor:" + path.replace(" ", "%20").replace('\\', '/')));
            this.resourceAccessor = resourceAccessor;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new UnexpectedLiquibaseException("Resource does not exist");
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public Resource resolve(String other) {
            try {
                return this.resourceAccessor.get(this.resolvePath(other));
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }

        @Override
        public Resource resolveSibling(String other) {
            try {
                return this.resourceAccessor.get(this.resolveSiblingPath(other));
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }

        @Override
        public OutputStream openOutputStream(OpenOptions openOptions) throws IOException {
            return this.openOutputStream(new OpenOptions());
        }
    }
}

