/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.listener;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChangeEvent;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

public class HubChangeExecListener
extends AbstractChangeExecListener
implements ChangeExecListener,
ChangeLogSyncListener {
    private static final Logger logger = Scope.getCurrentScope().getLog(HubChangeExecListener.class);
    private final Operation operation;
    private final Map<ChangeSet, Date> startDateMap = new HashMap<ChangeSet, Date>();
    private String rollbackScriptContents;
    private int postCount;
    private int failedToPostCount;
    private ChangeExecListener changeExecListener;

    public HubChangeExecListener(Operation operation, ChangeExecListener changeExecListener) {
        this.operation = operation;
        this.changeExecListener = changeExecListener;
    }

    public void setRollbackScriptContents(String rollbackScriptContents) {
        this.rollbackScriptContents = rollbackScriptContents;
    }

    public int getPostCount() {
        return this.postCount;
    }

    public int getFailedToPostCount() {
        return this.failedToPostCount;
    }

    @Override
    public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
        this.startDateMap.put(changeSet, new Date());
        if (this.changeExecListener != null) {
            this.changeExecListener.willRun(changeSet, databaseChangeLog, database, runStatus);
        }
    }

    @Override
    public void willRun(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
        this.startDateMap.put(changeSet, new Date());
        if (this.changeExecListener != null) {
            this.changeExecListener.willRun(change, changeSet, changeLog, database);
        }
    }

    @Override
    public void ran(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.ExecType execType) {
        String message = "PASSED::" + changeSet.getId() + "::" + changeSet.getAuthor();
        this.updateHub(changeSet, databaseChangeLog, database, "UPDATE", "PASS", message);
        if (this.changeExecListener != null) {
            this.changeExecListener.ran(changeSet, databaseChangeLog, database, execType);
        }
    }

    @Override
    public void willRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        this.startDateMap.put(changeSet, new Date());
        if (this.changeExecListener != null) {
            this.changeExecListener.willRollback(changeSet, databaseChangeLog, database);
        }
    }

    @Override
    public void rollbackFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception e) {
        this.updateHubForRollback(changeSet, databaseChangeLog, database, "FAIL", e.getMessage());
        if (this.changeExecListener != null) {
            this.changeExecListener.rollbackFailed(changeSet, databaseChangeLog, database, e);
        }
    }

    @Override
    public void rolledBack(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        String message = "PASSED::" + changeSet.getId() + "::" + changeSet.getAuthor();
        this.updateHubForRollback(changeSet, databaseChangeLog, database, "PASS", message);
        if (this.changeExecListener != null) {
            this.changeExecListener.rolledBack(changeSet, databaseChangeLog, database);
        }
    }

    @Override
    public void preconditionFailed(PreconditionFailedException error, PreconditionContainer.FailOption onFail) {
        if (this.changeExecListener != null) {
            this.changeExecListener.preconditionFailed(error, onFail);
        }
    }

    @Override
    public void preconditionErrored(PreconditionErrorException error, PreconditionContainer.ErrorOption onError) {
        if (this.changeExecListener != null) {
            this.changeExecListener.preconditionErrored(error, onError);
        }
    }

    @Override
    public void ran(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
        if (this.changeExecListener != null) {
            this.changeExecListener.ran(change, changeSet, changeLog, database);
        }
    }

    @Override
    public void runFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        this.updateHub(changeSet, databaseChangeLog, database, "UPDATE", "FAIL", exception.getMessage());
        if (this.changeExecListener != null) {
            this.changeExecListener.runFailed(changeSet, databaseChangeLog, database, exception);
        }
    }

    @Override
    public void markedRan(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        this.startDateMap.put(changeSet, new Date());
        String message = "PASSED::" + changeSet.getId() + "::" + changeSet.getAuthor();
        this.updateHub(changeSet, databaseChangeLog, database, "SYNC", "PASS", message);
    }

    private void updateHubForRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, String operationStatusType, String statusMessage) {
        HubChangeLog hubChangeLog;
        if (this.operation == null) {
            boolean hubOn;
            String apiKey = StringUtil.trimToNull(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue());
            boolean bl = hubOn = HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() != HubConfiguration.HubMode.OFF;
            if (apiKey != null && hubOn) {
                String message = "Hub communication failure.\nThe data for operation on changeset '" + changeSet.getId() + "' by author '" + changeSet.getAuthor() + "'\nwas not successfully recorded in your Liquibase Hub project";
                Scope.getCurrentScope().getUI().sendMessage(message);
                logger.info(message);
            }
            return;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        try {
            hubChangeLog = hubService.getHubChangeLog(UUID.fromString(databaseChangeLog.getChangeLogId()));
            if (hubChangeLog == null) {
                logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
                return;
            }
        }
        catch (LiquibaseHubException lhe) {
            logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
            return;
        }
        Date dateExecuted = new Date();
        OperationChangeEvent operationChangeEvent = new OperationChangeEvent();
        operationChangeEvent.setEventType("ROLLBACK");
        operationChangeEvent.setStartDate(this.startDateMap.get(changeSet));
        operationChangeEvent.setEndDate(dateExecuted);
        operationChangeEvent.setDateExecuted(dateExecuted);
        operationChangeEvent.setChangesetId(changeSet.getId());
        operationChangeEvent.setChangesetFilename(changeSet.getFilePath());
        operationChangeEvent.setChangesetAuthor(changeSet.getAuthor());
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            SqlStatement[] statements;
            List<Change> changes;
            if (this.rollbackScriptContents != null) {
                sqlList.add(this.rollbackScriptContents);
            } else if (changeSet.hasCustomRollbackChanges()) {
                changes = changeSet.getRollback().getChanges();
                for (Change change : changes) {
                    for (SqlStatement statement : statements = change.generateStatements(database)) {
                        for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, database)) {
                            sqlList.add(sql.toSql());
                        }
                    }
                }
            } else {
                changes = changeSet.getChanges();
                for (Change change : changes) {
                    for (SqlStatement statement : statements = change.generateRollbackStatements(database)) {
                        for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, database)) {
                            sqlList.add(sql.toSql());
                        }
                    }
                }
            }
        }
        catch (LiquibaseException lbe) {
            logger.warning(lbe.getMessage());
        }
        String[] sqlArray = new String[sqlList.size()];
        sqlArray = sqlList.toArray(sqlArray);
        operationChangeEvent.setGeneratedSql(sqlArray);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer(".json");
        try {
            serializer.write(Collections.singletonList(changeSet), baos);
            operationChangeEvent.setChangesetBody(baos.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException statements) {
            // empty catch block
        }
        operationChangeEvent.setOperationStatusType(operationStatusType);
        operationChangeEvent.setStatusMessage(statusMessage);
        if ("FAIL".equals(operationStatusType)) {
            operationChangeEvent.setLogs(statusMessage);
        } else {
            String logs = this.getCurrentLog();
            if (!StringUtil.isEmpty(logs)) {
                operationChangeEvent.setLogs(logs);
            } else {
                operationChangeEvent.setLogs(statusMessage);
            }
        }
        operationChangeEvent.setLogsTimestamp(new Date());
        operationChangeEvent.setProject(hubChangeLog.getProject());
        operationChangeEvent.setOperation(this.operation);
        try {
            hubService.sendOperationChangeEvent(operationChangeEvent);
            ++this.postCount;
        }
        catch (LiquibaseException lbe) {
            logger.warning(lbe.getMessage(), lbe);
            logger.warning("Unable to send Operation Change Event for operation '" + this.operation.getId().toString() + " changeset '" + changeSet.toString(false));
        }
    }

    private String getCurrentLog() {
        Level currentLevel = HubConfiguration.LIQUIBASE_HUB_LOGLEVEL.getCurrentValue();
        BufferedLogService bufferedLogService = (BufferedLogService)((Object)Scope.getCurrentScope().get(BufferedLogService.class.getName(), BufferedLogService.class));
        if (bufferedLogService != null) {
            return bufferedLogService.getLogAsString(currentLevel);
        }
        return null;
    }

    private void updateHub(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, String eventType, String operationStatusType, String statusMessage) {
        String[] sqlArray;
        HubChangeLog hubChangeLog;
        if (this.operation == null) {
            boolean hubOn;
            String apiKey = StringUtil.trimToNull(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValueObfuscated());
            boolean bl = hubOn = HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() != HubConfiguration.HubMode.OFF;
            if (apiKey != null && hubOn) {
                String message = databaseChangeLog.getChangeLogId() == null ? "The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Liquibase Hub.\nTo register the changelog with your Hub Project run 'liquibase registerChangeLog'.\nLearn more at https://hub.liquibase.com." : "The changelog file specified is not registered with any Liquibase Hub project, so the results will not be recorded in Liquibase Hub.\nTo register the changelog with your Hub Project run 'liquibase registerChangeLog'.\nLearn more at https://hub.liquibase.com.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                logger.info(message);
            }
            return;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        try {
            hubChangeLog = hubService.getHubChangeLog(UUID.fromString(databaseChangeLog.getChangeLogId()));
            if (hubChangeLog == null) {
                logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
                return;
            }
        }
        catch (LiquibaseHubException lhe) {
            logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
            return;
        }
        OperationChangeEvent operationChangeEvent = new OperationChangeEvent();
        ArrayList<String> sqlList = new ArrayList<String>();
        if (!eventType.equals("SYNC")) {
            List<Change> changes = changeSet.getChanges();
            for (Change change : changes) {
                try {
                    Sql[] sqls;
                    for (Sql sql : sqls = SqlGeneratorFactory.getInstance().generateSql(change, database)) {
                        sqlList.add(sql.toSql());
                    }
                }
                catch (Exception e) {
                    logger.warning("Unable to generate SQL for Hub failure message: " + e.getMessage());
                }
            }
            sqlArray = new String[sqlList.size()];
            sqlArray = sqlList.toArray(sqlArray);
            operationChangeEvent.setGeneratedSql(sqlArray);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer(".json");
            try {
                serializer.write(Collections.singletonList(changeSet), baos);
                operationChangeEvent.setChangesetBody(baos.toString(StandardCharsets.UTF_8.name()));
            }
            catch (IOException ioe) {
                logger.warning("Unable to serialize changeset '" + changeSet.toString(false) + "' for Hub.");
            }
        }
        Date dateExecuted = new Date();
        sqlArray = new String[sqlList.size()];
        sqlArray = sqlList.toArray(sqlArray);
        operationChangeEvent.setEventType(eventType);
        operationChangeEvent.setStartDate(this.startDateMap.get(changeSet));
        operationChangeEvent.setEndDate(dateExecuted);
        operationChangeEvent.setDateExecuted(dateExecuted);
        operationChangeEvent.setChangesetId(changeSet.getId());
        operationChangeEvent.setChangesetFilename(changeSet.getFilePath());
        operationChangeEvent.setChangesetAuthor(changeSet.getAuthor());
        operationChangeEvent.setOperationStatusType(operationStatusType);
        operationChangeEvent.setStatusMessage(statusMessage);
        operationChangeEvent.setGeneratedSql(sqlArray);
        operationChangeEvent.setOperation(this.operation);
        operationChangeEvent.setLogsTimestamp(new Date());
        if ("FAIL".equals(operationStatusType)) {
            operationChangeEvent.setLogs(statusMessage);
        } else {
            String logs = this.getCurrentLog();
            if (!StringUtil.isEmpty(logs)) {
                operationChangeEvent.setLogs(logs);
            } else {
                operationChangeEvent.setLogs(statusMessage);
            }
        }
        operationChangeEvent.setProject(hubChangeLog.getProject());
        operationChangeEvent.setOperation(this.operation);
        try {
            hubService.sendOperationChangeEvent(operationChangeEvent);
            ++this.postCount;
        }
        catch (LiquibaseException lbe) {
            logger.warning(lbe.getMessage(), lbe);
            logger.warning("Unable to send Operation Change Event for operation '" + this.operation.getId().toString() + " changeset '" + changeSet.toString(false));
            ++this.failedToPostCount;
        }
    }
}

