/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.object.datatype.DataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayDataType
extends DataType {
    private final DataType baseType;
    private final int[] arrayTypeDimensions;

    public ArrayDataType(ByteBuffer bb) {
        super(bb);
        int dimensionsSize = Utils.readBytesAsUnsignedInt(bb, 1);
        this.arrayTypeDimensions = new int[dimensionsSize];
        if (this.getVersion() == 2) {
            bb.position(bb.position() + 3);
        }
        for (int i = 0; i < this.arrayTypeDimensions.length; ++i) {
            this.arrayTypeDimensions[i] = Utils.readBytesAsUnsignedInt(bb, 4);
            if (this.getVersion() != 2) continue;
            bb.position(bb.position() + 4);
        }
        this.baseType = DataType.readDataType(bb);
    }

    @Override
    public Class<?> getJavaType() {
        return Array.newInstance(this.baseType.getJavaType(), 0).getClass();
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public int[] getArrayTypeDimensions() {
        return ArrayUtils.clone((int[])this.arrayTypeDimensions);
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        int[] mergedDimensions = ArrayUtils.addAll((int[])dimensions, (int[])this.arrayTypeDimensions);
        return DatasetReader.readDataset(this.getBaseType(), buffer, mergedDimensions, hdfBackingStorage);
    }
}

