/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import com.ning.compress.lzf.LZFException;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import io.jhdf.exceptions.HdfFilterException;
import io.jhdf.filter.Filter;

public class LzfFilter
implements Filter {
    @Override
    public int getId() {
        return 32000;
    }

    @Override
    public String getName() {
        return "lzf";
    }

    @Override
    public byte[] decode(byte[] encodedData, int[] filterData) {
        int compressedLength = encodedData.length;
        int uncompressedLength = filterData[2];
        if (compressedLength == uncompressedLength) {
            return encodedData;
        }
        byte[] output = new byte[uncompressedLength];
        try {
            ChunkDecoderFactory.safeInstance().decodeChunk(encodedData, 0, output, 0, uncompressedLength);
        }
        catch (LZFException e) {
            throw new HdfFilterException("Inflating failed", e);
        }
        return output;
    }
}

