/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.filter.Filter;
import io.jhdf.filter.PipelineFilterWithData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilterPipeline {
    public static final FilterPipeline NO_FILTERS = new FilterPipeline();
    private final List<PipelineFilterWithData> filters = new ArrayList<PipelineFilterWithData>();

    FilterPipeline() {
    }

    void addFilter(Filter filter, int[] data) {
        this.filters.add(new PipelineFilterWithData(filter, data));
    }

    public byte[] decode(byte[] encodedData) {
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            PipelineFilterWithData filter = this.filters.get(i);
            encodedData = filter.decode(encodedData);
        }
        return encodedData;
    }

    public String toString() {
        return "FilterPipeline{" + this.filters.stream().map(Objects::toString).collect(Collectors.joining(" -> ")) + '}';
    }

    public List<PipelineFilterWithData> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }
}

