/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked;

import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.btree.BTreeV1;
import io.jhdf.btree.BTreeV1Data;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.ChunkOffset;
import io.jhdf.dataset.chunked.ChunkedDatasetBase;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedDatasetV3
extends ChunkedDatasetBase {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedDatasetV3.class);
    private final DataLayoutMessage.ChunkedDataLayoutMessage layoutMessage;
    private final ChunkLookupLazyInitializer chunkLookupLazyInitializer;

    public ChunkedDatasetV3(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent, oh);
        this.layoutMessage = oh.getMessageOfType(DataLayoutMessage.ChunkedDataLayoutMessage.class);
        this.chunkLookupLazyInitializer = new ChunkLookupLazyInitializer();
    }

    @Override
    protected Map<ChunkOffset, Chunk> getChunkLookup() {
        try {
            return (Map)this.chunkLookupLazyInitializer.get();
        }
        catch (ConcurrentException e) {
            throw new HdfException("Failed to create chunk lookup for: " + this.getPath(), e);
        }
    }

    @Override
    public int[] getChunkDimensions() {
        return this.layoutMessage.getChunkDimensions();
    }

    private final class ChunkLookupLazyInitializer
    extends LazyInitializer<Map<ChunkOffset, Chunk>> {
        private ChunkLookupLazyInitializer() {
        }

        protected Map<ChunkOffset, Chunk> initialize() {
            logger.debug("Creating chunk lookup for [{}]", (Object)ChunkedDatasetV3.this.getPath());
            if (ChunkedDatasetV3.this.layoutMessage.getBTreeAddress() == -1L) {
                return Collections.emptyMap();
            }
            BTreeV1Data bTree = BTreeV1.createDataBTree(ChunkedDatasetV3.this.hdfBackingStorage, ChunkedDatasetV3.this.layoutMessage.getBTreeAddress(), ChunkedDatasetV3.this.getDimensions().length);
            List<Chunk> allChunks = bTree.getChunks();
            return allChunks.stream().collect(Collectors.toMap(chunk -> new ChunkOffset(chunk.getChunkOffset()), Function.identity()));
        }
    }
}

