/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHeap {
    private static final Logger logger = LoggerFactory.getLogger(LocalHeap.class);
    private static final byte[] HEAP_SIGNATURE = "HEAP".getBytes(StandardCharsets.US_ASCII);
    private final long address;
    private final short version;
    private final long dataSegmentSize;
    private final long offsetToHeadOfFreeList;
    private final long addressOfDataSegment;
    private final ByteBuffer dataBuffer;

    public LocalHeap(HdfBackingStorage hdfBackingStorage, long address) {
        this.address = address;
        try {
            int headerSize = 8 + hdfBackingStorage.getSizeOfLengths() + hdfBackingStorage.getSizeOfLengths() + hdfBackingStorage.getSizeOfOffsets();
            ByteBuffer header = hdfBackingStorage.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            header.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(HEAP_SIGNATURE, formatSignatureBytes)) {
                throw new HdfException("Heap signature not matched");
            }
            this.version = header.get();
            header.position(8);
            this.dataSegmentSize = Utils.readBytesAsUnsignedLong(header, hdfBackingStorage.getSizeOfLengths());
            logger.trace("dataSegmentSize = {}", (Object)this.dataSegmentSize);
            this.offsetToHeadOfFreeList = Utils.readBytesAsUnsignedLong(header, hdfBackingStorage.getSizeOfLengths());
            logger.trace("offsetToHeadOfFreeList = {}", (Object)this.offsetToHeadOfFreeList);
            this.addressOfDataSegment = Utils.readBytesAsUnsignedLong(header, hdfBackingStorage.getSizeOfOffsets());
            logger.trace("addressOfDataSegment = {}", (Object)this.addressOfDataSegment);
            this.dataBuffer = hdfBackingStorage.map(this.addressOfDataSegment, this.dataSegmentSize);
        }
        catch (Exception e) {
            throw new HdfException("Error reading local heap", e);
        }
    }

    public short getVersion() {
        return this.version;
    }

    public long getDataSegmentSize() {
        return this.dataSegmentSize;
    }

    public long getOffsetToHeadOfFreeList() {
        return this.offsetToHeadOfFreeList;
    }

    public long getAddressOfDataSegment() {
        return this.addressOfDataSegment;
    }

    public String toString() {
        return "LocalHeap [address=" + Utils.toHex(this.address) + ", version=" + this.version + ", dataSegmentSize=" + this.dataSegmentSize + ", offsetToHeadOfFreeList=" + this.offsetToHeadOfFreeList + ", addressOfDataSegment=" + Utils.toHex(this.addressOfDataSegment) + "]";
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }
}

