/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableCharacteristic {
    public final Semantics semantics;
    public final boolean pruneIfEmpty;
    public final boolean passColumnsThrough;

    private TableCharacteristic(Semantics semantics, boolean pruneIfEmpty, boolean passColumnsThrough) {
        this.semantics = semantics;
        this.pruneIfEmpty = pruneIfEmpty;
        this.passColumnsThrough = passColumnsThrough;
    }

    public static Builder builder(Semantics semantics) {
        return new Builder(semantics);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableCharacteristic that = (TableCharacteristic)o;
        return this.pruneIfEmpty == that.pruneIfEmpty && this.passColumnsThrough == that.passColumnsThrough && this.semantics == that.semantics;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.semantics, this.pruneIfEmpty, this.passColumnsThrough});
    }

    public String toString() {
        return "TableCharacteristic{semantics=" + (Object)((Object)this.semantics) + ", pruneIfEmpty=" + this.pruneIfEmpty + ", passColumnsThrough=" + this.passColumnsThrough + '}';
    }

    public static class Builder {
        private final Semantics semantics;
        private boolean pruneIfEmpty = false;
        private boolean passColumnsThrough = false;

        private Builder(Semantics semantics) {
            if (semantics == Semantics.ROW) {
                this.pruneIfEmpty = true;
            }
            this.semantics = semantics;
        }

        public Builder pruneIfEmpty() {
            this.pruneIfEmpty = true;
            return this;
        }

        public Builder passColumnsThrough() {
            this.passColumnsThrough = true;
            return this;
        }

        public TableCharacteristic build() {
            return new TableCharacteristic(this.semantics, this.pruneIfEmpty, this.passColumnsThrough);
        }
    }

    public static enum Semantics {
        ROW,
        SET;

    }
}

