/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.drill.jdbc.proxy.InvocationReporter;
import org.apache.drill.jdbc.proxy.ProxiesManager;

class TracingInvocationHandler<INTF>
implements InvocationHandler {
    private final ProxiesManager proxiesManager;
    private final InvocationReporter callReporter;
    private final INTF proxiedObject;
    private final Class<?> proxiedInterface;

    TracingInvocationHandler(ProxiesManager proxiesManager, InvocationReporter reporter, INTF proxiedObject, Class<?> proxiedInterface) {
        this.proxiesManager = proxiesManager;
        this.callReporter = reporter;
        this.proxiedObject = proxiedObject;
        this.proxiedInterface = proxiedInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object netReturnedResult;
        Object rawReturnedResult;
        this.callReporter.methodCalled(this.proxiedObject, this.proxiedInterface, method, args);
        try {
            Class<?> methodReturnType;
            rawReturnedResult = method.invoke(this.proxiedObject, args);
            netReturnedResult = null == rawReturnedResult ? null : (!(methodReturnType = method.getReturnType()).isInterface() ? rawReturnedResult : this.proxiesManager.getProxyInstanceForOriginal(rawReturnedResult, methodReturnType));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Unexpected/unhandled error calling proxied method: " + String.valueOf(e), e);
        }
        catch (InvocationTargetException e) {
            Throwable thrownResult = e.getCause();
            this.callReporter.methodThrew(this.proxiedObject, this.proxiedInterface, method, args, thrownResult);
            throw thrownResult;
        }
        this.callReporter.methodReturned(this.proxiedObject, this.proxiedInterface, method, args, rawReturnedResult);
        return netReturnedResult;
    }
}

