/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.walker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupParticle;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.walker.SchemasByNamespace;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaScope;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaVisitor;

public final class XmlSchemaWalker {
    private Set<QName> userRecognizedTypes;
    private final XmlSchemaCollection schemas;
    private final List<XmlSchemaVisitor> visitors;
    private final Map<QName, List<XmlSchemaElement>> elemsBySubstGroup;
    private final SchemasByNamespace schemasByNamespace;
    private final Map<QName, XmlSchemaScope> scopeCache;
    private final Set<QName> visitedElements;

    public XmlSchemaWalker(XmlSchemaCollection xmlSchemas) {
        if (xmlSchemas == null) {
            throw new IllegalArgumentException("Input XmlSchemaCollection cannot be null.");
        }
        this.schemas = xmlSchemas;
        this.visitors = new ArrayList<XmlSchemaVisitor>(1);
        this.schemasByNamespace = new SchemasByNamespace();
        this.elemsBySubstGroup = new HashMap<QName, List<XmlSchemaElement>>();
        for (XmlSchema schema : this.schemas.getXmlSchemas()) {
            this.schemasByNamespace.addSchema(schema.getTargetNamespace(), schema);
            for (XmlSchemaElement elem : schema.getElements().values()) {
                if (elem.getSubstitutionGroup() == null) continue;
                List<XmlSchemaElement> elems = this.elemsBySubstGroup.get(elem.getSubstitutionGroup());
                if (elems == null) {
                    elems = new ArrayList<XmlSchemaElement>();
                    this.elemsBySubstGroup.put(elem.getSubstitutionGroup(), elems);
                }
                elems.add(elem);
            }
        }
        this.scopeCache = new HashMap<QName, XmlSchemaScope>();
        this.visitedElements = new HashSet<QName>();
        this.userRecognizedTypes = null;
    }

    public XmlSchemaWalker(XmlSchemaCollection xmlSchemas, XmlSchemaVisitor visitor) {
        this(xmlSchemas);
        if (visitor != null) {
            this.visitors.add(visitor);
        }
    }

    public XmlSchemaWalker addVisitor(XmlSchemaVisitor visitor) {
        this.visitors.add(visitor);
        return this;
    }

    public XmlSchemaWalker removeVisitor(XmlSchemaVisitor visitor) {
        if (visitor != null) {
            this.visitors.remove(visitor);
        }
        return this;
    }

    public void clear() {
        this.scopeCache.clear();
        this.visitedElements.clear();
    }

    public void setUserRecognizedTypes(Set<QName> userRecognizedTypes) {
        this.userRecognizedTypes = userRecognizedTypes;
    }

    public Set<QName> getUserRecognizedTypes() {
        return this.userRecognizedTypes;
    }

    public void walk(XmlSchemaElement element) {
        QName typeQName;
        XmlSchemaType schemaType;
        XmlSchemaElement substGroupElem = element = this.getElement(element, false);
        List<XmlSchemaElement> substitutes = null;
        if (this.elemsBySubstGroup.containsKey(XmlSchemaWalker.getElementQName(element))) {
            substitutes = this.elemsBySubstGroup.get(element.getQName());
            for (XmlSchemaVisitor visitor : this.visitors) {
                visitor.onEnterSubstitutionGroup(substGroupElem);
            }
            element = this.getElement(element, true);
            element.setMinOccurs(1L);
            element.setMaxOccurs(1L);
        }
        if ((schemaType = element.getSchemaType()) == null && (typeQName = element.getSchemaTypeName()) != null) {
            schemaType = this.schemasByNamespace.getTypeByName(typeQName);
        }
        if (schemaType != null) {
            XmlSchemaScope scope = null;
            if (schemaType.getQName() != null && this.scopeCache.containsKey(schemaType.getQName())) {
                scope = this.scopeCache.get(schemaType.getQName());
            } else {
                scope = new XmlSchemaScope(schemaType, this.schemasByNamespace, this.scopeCache, this.userRecognizedTypes);
                if (schemaType.getQName() != null) {
                    this.scopeCache.put(schemaType.getQName(), scope);
                }
            }
            Collection<XmlSchemaAttrInfo> attrs = scope.getAttributesInScope();
            XmlSchemaTypeInfo typeInfo = scope.getTypeInfo();
            boolean previouslyVisited = !element.isAnonymous() && this.visitedElements.contains(element.getQName());
            for (XmlSchemaVisitor visitor : this.visitors) {
                visitor.onEnterElement(element, typeInfo, previouslyVisited);
            }
            if (!element.isAnonymous() && !previouslyVisited) {
                this.visitedElements.add(element.getQName());
            }
            if (!previouslyVisited) {
                if (attrs != null) {
                    for (XmlSchemaAttrInfo attr : attrs) {
                        XmlSchemaSimpleType attrType = attr.getAttribute().getSchemaType();
                        if (attrType != null) {
                            XmlSchemaScope attrScope;
                            if (attrType.getQName() != null && this.scopeCache.containsKey(attrType.getQName())) {
                                attrScope = this.scopeCache.get(attrType.getQName());
                            } else {
                                attrScope = new XmlSchemaScope((XmlSchemaType)attrType, this.schemasByNamespace, this.scopeCache, this.userRecognizedTypes);
                                if (attrType.getName() != null) {
                                    this.scopeCache.put(attrType.getQName(), attrScope);
                                }
                            }
                            XmlSchemaTypeInfo attrTypeInfo = attrScope.getTypeInfo();
                            attr.setType(attrTypeInfo);
                        }
                        for (XmlSchemaVisitor visitor : this.visitors) {
                            visitor.onVisitAttribute(element, attr);
                        }
                    }
                }
                if (scope.getAnyAttribute() != null) {
                    for (XmlSchemaVisitor visitor : this.visitors) {
                        visitor.onVisitAnyAttribute(element, scope.getAnyAttribute());
                    }
                }
                for (XmlSchemaVisitor visitor : this.visitors) {
                    visitor.onEndAttributes(element, typeInfo);
                }
                XmlSchemaParticle child = scope.getParticle();
                if (child != null) {
                    this.walk(child);
                }
            }
            for (XmlSchemaVisitor visitor : this.visitors) {
                visitor.onExitElement(element, typeInfo, previouslyVisited);
            }
        } else if (!element.isAbstract()) {
            throw new IllegalStateException("Element " + element.getQName() + " is not abstract and has no type.");
        }
        if (substitutes != null) {
            for (XmlSchemaElement substitute : substitutes) {
                this.walk(substitute);
            }
            for (XmlSchemaVisitor visitor : this.visitors) {
                visitor.onExitSubstitutionGroup(substGroupElem);
            }
        }
    }

    private void walk(XmlSchemaParticle particle) {
        if (particle instanceof XmlSchemaGroupRef) {
            XmlSchemaGroup g;
            XmlSchemaGroupRef groupRef = (XmlSchemaGroupRef)particle;
            XmlSchemaGroupParticle group = groupRef.getParticle();
            if (group == null && (g = this.schemasByNamespace.getGroupByName(groupRef.getRefName())) != null) {
                group = g.getParticle();
            }
            this.walk(group, groupRef.getMinOccurs(), groupRef.getMaxOccurs());
        } else if (particle instanceof XmlSchemaGroupParticle) {
            this.walk((XmlSchemaGroupParticle)particle, particle.getMinOccurs(), particle.getMaxOccurs());
        } else if (particle instanceof XmlSchemaElement) {
            this.walk((XmlSchemaElement)particle);
        } else if (particle instanceof XmlSchemaAny) {
            for (XmlSchemaVisitor visitor : this.visitors) {
                visitor.onVisitAny((XmlSchemaAny)particle);
            }
        } else {
            throw new IllegalArgumentException("Unknown particle type " + particle.getClass().getName());
        }
    }

    private void walk(XmlSchemaGroupParticle group, long minOccurs, long maxOccurs) {
        boolean forceCopy = minOccurs != group.getMinOccurs() || maxOccurs != group.getMaxOccurs();
        XmlSchemaAll all = null;
        XmlSchemaChoice choice = null;
        XmlSchemaSequence seq = null;
        ArrayList<Object> children = null;
        if (group instanceof XmlSchemaAll) {
            all = (XmlSchemaAll)group;
        } else if (group instanceof XmlSchemaChoice) {
            choice = (XmlSchemaChoice)group;
        } else if (group instanceof XmlSchemaSequence) {
            seq = (XmlSchemaSequence)group;
        } else {
            throw new IllegalArgumentException("Unrecognized XmlSchemaGroupParticle of type " + group.getClass().getName());
        }
        if (forceCopy) {
            XmlSchemaAll copy;
            if (all != null) {
                copy = new XmlSchemaAll();
                copy.setAnnotation(all.getAnnotation());
                copy.setId(all.getId());
                copy.setLineNumber(all.getLineNumber());
                copy.setLinePosition(all.getLinePosition());
                copy.setMetaInfoMap(all.getMetaInfoMap());
                copy.setMinOccurs(minOccurs);
                copy.setMaxOccurs(maxOccurs);
                copy.setSourceURI(all.getSourceURI());
                copy.setUnhandledAttributes(all.getUnhandledAttributes());
                copy.getItems().addAll(all.getItems());
                all = copy;
            } else if (choice != null) {
                copy = new XmlSchemaChoice();
                copy.setAnnotation(choice.getAnnotation());
                copy.setId(choice.getId());
                copy.setLineNumber(choice.getLineNumber());
                copy.setLinePosition(choice.getLinePosition());
                copy.setMinOccurs(minOccurs);
                copy.setMaxOccurs(maxOccurs);
                copy.setMetaInfoMap(choice.getMetaInfoMap());
                copy.setSourceURI(choice.getSourceURI());
                copy.setUnhandledAttributes(choice.getUnhandledAttributes());
                copy.getItems().addAll(choice.getItems());
                choice = copy;
            } else if (seq != null) {
                copy = new XmlSchemaSequence();
                copy.setAnnotation(seq.getAnnotation());
                copy.setId(seq.getId());
                copy.setLineNumber(seq.getLineNumber());
                copy.setLinePosition(seq.getLinePosition());
                copy.setMinOccurs(minOccurs);
                copy.setMaxOccurs(maxOccurs);
                copy.setMetaInfoMap(seq.getMetaInfoMap());
                copy.setSourceURI(seq.getSourceURI());
                copy.setUnhandledAttributes(seq.getUnhandledAttributes());
                seq = copy;
            }
        }
        for (XmlSchemaVisitor xmlSchemaVisitor : this.visitors) {
            if (all != null) {
                xmlSchemaVisitor.onEnterAllGroup(all);
                continue;
            }
            if (choice != null) {
                xmlSchemaVisitor.onEnterChoiceGroup(choice);
                continue;
            }
            if (seq == null) continue;
            xmlSchemaVisitor.onEnterSequenceGroup(seq);
        }
        if (all != null) {
            children = new ArrayList<Object>(all.getItems().size());
            for (XmlSchemaAllMember xmlSchemaAllMember : all.getItems()) {
                if (xmlSchemaAllMember instanceof XmlSchemaGroup) {
                    children.add(((XmlSchemaGroup)xmlSchemaAllMember).getParticle());
                    continue;
                }
                if (xmlSchemaAllMember instanceof XmlSchemaParticle) {
                    children.add((XmlSchemaParticle)xmlSchemaAllMember);
                    continue;
                }
                throw new IllegalArgumentException("All child is not an XmlSchemaGroup or XmlSchemaParticle; it is a " + xmlSchemaAllMember.getClass().getName());
            }
        } else if (choice != null) {
            children = new ArrayList(choice.getItems().size());
            for (XmlSchemaChoiceMember xmlSchemaChoiceMember : choice.getItems()) {
                if (xmlSchemaChoiceMember instanceof XmlSchemaGroup) {
                    children.add(((XmlSchemaGroup)xmlSchemaChoiceMember).getParticle());
                    continue;
                }
                if (xmlSchemaChoiceMember instanceof XmlSchemaParticle) {
                    children.add((XmlSchemaParticle)xmlSchemaChoiceMember);
                    continue;
                }
                throw new IllegalArgumentException("Choice child is not an XmlSchemaGroup or XmlSchemaParticle; it is a " + xmlSchemaChoiceMember.getClass().getName());
            }
        } else if (seq != null) {
            children = new ArrayList(seq.getItems().size());
            for (XmlSchemaSequenceMember xmlSchemaSequenceMember : seq.getItems()) {
                if (xmlSchemaSequenceMember instanceof XmlSchemaGroup) {
                    children.add(((XmlSchemaGroup)xmlSchemaSequenceMember).getParticle());
                    continue;
                }
                if (xmlSchemaSequenceMember instanceof XmlSchemaParticle) {
                    children.add((XmlSchemaParticle)xmlSchemaSequenceMember);
                    continue;
                }
                throw new IllegalArgumentException("Sequence child is not an XmlSchemaGroup or XmlSchemaParticle; it is a " + xmlSchemaSequenceMember.getClass().getName());
            }
        }
        if (children == null) {
            throw new IllegalStateException("Could not process group of type " + group.getClass().getName());
        }
        for (XmlSchemaParticle xmlSchemaParticle : children) {
            this.walk(xmlSchemaParticle);
        }
        for (XmlSchemaVisitor xmlSchemaVisitor : this.visitors) {
            if (all != null) {
                xmlSchemaVisitor.onExitAllGroup(all);
                continue;
            }
            if (choice != null) {
                xmlSchemaVisitor.onExitChoiceGroup(choice);
                continue;
            }
            if (seq == null) continue;
            xmlSchemaVisitor.onExitSequenceGroup(seq);
        }
    }

    private XmlSchemaElement getElement(XmlSchemaElement element, boolean isSubstitutionGroup) {
        XmlSchema schema;
        if (!element.isRef() && !isSubstitutionGroup) {
            return element;
        }
        QName elemQName = XmlSchemaWalker.getElementQName(element);
        XmlSchemaElement globalElem = null;
        globalElem = !element.isRef() ? element : (element.getRef().getTarget() != null ? (XmlSchemaElement)element.getRef().getTarget() : this.schemasByNamespace.getElementByName(elemQName));
        String id = element.getId();
        if (id == null) {
            id = globalElem.getId();
        }
        if ((schema = this.schemasByNamespace.getSchemaDefiningElement(elemQName)) == null) {
            schema = element.getParent();
        }
        XmlSchemaElement copy = new XmlSchemaElement(schema, false);
        copy.setName(globalElem.getName());
        copy.setAbstract(globalElem.isAbstract());
        copy.setAnnotation(globalElem.getAnnotation());
        copy.setBlock(globalElem.getBlock());
        copy.setDefaultValue(globalElem.getDefaultValue());
        copy.setFinal(globalElem.getFinal());
        copy.setFixedValue(globalElem.getFixedValue());
        copy.setForm(globalElem.getForm());
        copy.setId(id);
        copy.setLineNumber(element.getLineNumber());
        copy.setLinePosition(element.getLinePosition());
        copy.setMaxOccurs(element.getMaxOccurs());
        copy.setMinOccurs(element.getMinOccurs());
        copy.setMetaInfoMap(globalElem.getMetaInfoMap());
        copy.setNillable(globalElem.isNillable());
        copy.setType(globalElem.getSchemaType());
        copy.setSchemaTypeName(globalElem.getSchemaTypeName());
        copy.setSourceURI(globalElem.getSourceURI());
        copy.setSubstitutionGroup(globalElem.getSubstitutionGroup());
        copy.setUnhandledAttributes(globalElem.getUnhandledAttributes());
        return copy;
    }

    private static QName getElementQName(XmlSchemaElement element) {
        if (element.isRef()) {
            return element.getRefBase().getTargetQName();
        }
        return element.getQName();
    }
}

