/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcGroupScan;
import org.apache.drill.exec.store.jdbc.JdbcIntermediatePrel;

public class JdbcPrel
extends AbstractRelNode
implements Prel {
    private final String sql;
    private final double rows;
    private final DrillJdbcConvention convention;
    private final UserBitShared.UserCredentials userCredentials;

    public JdbcPrel(RelOptCluster cluster, RelTraitSet traitSet, JdbcIntermediatePrel prel, UserBitShared.UserCredentials userCredentials) {
        super(cluster, traitSet);
        RelNode input = prel.getInput();
        this.userCredentials = userCredentials;
        this.rows = input.estimateRowCount(cluster.getMetadataQuery());
        this.convention = (DrillJdbcConvention)input.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE);
        JdbcDialect jdbcDialect = this.convention.getPlugin().getJdbcDialect(this.convention.dialect);
        this.sql = jdbcDialect.generateSql(this.getCluster(), input);
        this.rowType = input.getRowType();
    }

    private String stripToOneLineSql(String sql) {
        String[] sqlToken;
        StringBuilder strippedSqlTextBldr = new StringBuilder(sql.length());
        for (String sqlTextLine : sqlToken = sql.split("\\n")) {
            if (sqlTextLine.trim().startsWith("--")) continue;
            strippedSqlTextBldr.append(sqlTextLine).append(' ');
        }
        return strippedSqlTextBldr.toString();
    }

    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) {
        ArrayList<SchemaPath> columns = new ArrayList<SchemaPath>();
        for (String col : this.rowType.getFieldNames()) {
            columns.add(SchemaPath.getSimplePath((String)col));
        }
        JdbcGroupScan output = new JdbcGroupScan(this.sql, columns, this.convention.getPlugin(), this.rows, this.userCredentials.getUserName());
        return creator.addMetadata((Prel)this, (PhysicalOperator)output);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("sql", (Object)this.stripToOneLineSql(this.sql));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.rows;
    }

    public Iterator<Prel> iterator() {
        return Collections.emptyIterator();
    }

    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return (T)logicalVisitor.visitPrel((Prel)this, value);
    }

    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    public boolean needsFinalColumnReordering() {
        return false;
    }
}

