/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.util.List;
import javax.sql.DataSource;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.InsertWriterRecordBatch;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.jdbc.JdbcInsertWriter;
import org.apache.drill.exec.store.jdbc.JdbcTableModifyWriter;

public class JdbcInsertWriterBatchCreator
implements BatchCreator<JdbcInsertWriter> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, JdbcInsertWriter config, List<RecordBatch> children) throws ExecutionSetupException {
        assert (children != null && children.size() == 1);
        UserBitShared.UserCredentials userCreds = context.getContextInformation().getQueryUserCredentials();
        DataSource ds = config.getPlugin().getDataSource(userCreds).orElseThrow(() -> new ExecutionSetupException(String.format("Query user %s could obtain a connection to %s, missing credentials?", userCreds.getUserName(), config.getPlugin().getName())));
        return new InsertWriterRecordBatch((Writer)config, children.iterator().next(), (FragmentContext)context, (RecordWriter)new JdbcTableModifyWriter(userCreds, config.getTableIdentifier(), config));
    }
}

