/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.JdbcSubScan;

@JsonTypeName(value="jdbc-scan")
public class JdbcGroupScan
extends AbstractGroupScan {
    private final String sql;
    private final List<SchemaPath> columns;
    private final JdbcStoragePlugin plugin;
    private final double rows;
    private int hashCode;

    @JsonCreator
    public JdbcGroupScan(@JsonProperty(value="sql") String sql, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="config") JdbcStorageConfig config, @JsonProperty(value="rows") double rows, @JsonProperty(value="username") String username, @JacksonInject StoragePluginRegistry plugins) throws ExecutionSetupException {
        super(username);
        this.sql = sql;
        this.columns = columns;
        this.plugin = (JdbcStoragePlugin)plugins.resolve((StoragePluginConfig)config, JdbcStoragePlugin.class);
        this.rows = rows;
    }

    JdbcGroupScan(String sql, List<SchemaPath> columns, JdbcStoragePlugin plugin, double rows, String username) {
        super(username);
        this.sql = sql;
        this.columns = columns;
        this.plugin = plugin;
        this.rows = rows;
    }

    @JsonProperty(value="config")
    public JdbcStorageConfig config() {
        return this.plugin.getConfig();
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
    }

    public SubScan getSpecificScan(int minorFragmentId) {
        return new JdbcSubScan(this.sql, this.columns, this.plugin, this.getUserName());
    }

    public int getMaxParallelizationWidth() {
        return 1;
    }

    public ScanStats getScanStats() {
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)((long)Math.max(this.rows, 1.0)), 1.0, 1.0);
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="columns")
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public String getDigest() {
        return this.sql + String.valueOf((Object)this.plugin.getConfig());
    }

    public JdbcStorageConfig getConfig() {
        return this.plugin.getConfig();
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        return new JdbcGroupScan(this.sql, this.columns, this.plugin, this.rows, this.userName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JdbcGroupScan that = (JdbcGroupScan)((Object)obj);
        return Objects.equals(this.sql, that.sql) && Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows) && Objects.equals(this.plugin.getName(), that.plugin.getName()) && Objects.equals((Object)this.config(), (Object)that.getConfig());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{this.sql, this.columns, this.plugin.getConfig(), this.rows, this.plugin.getName()});
        }
        return this.hashCode;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("sql", this.sql).field("columns", this.columns).field("jdbcConfig", (Object)this.plugin.getConfig()).field("rows", (Object)this.rows).toString();
    }
}

