/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin.plan;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.drill.plugin.DrillGroupScan;
import org.apache.drill.exec.store.drill.plugin.DrillScanSpec;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePlugin;
import org.apache.drill.exec.store.plan.AbstractPluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginAggregateRel;
import org.apache.drill.exec.store.plan.rel.PluginFilterRel;
import org.apache.drill.exec.store.plan.rel.PluginJoinRel;
import org.apache.drill.exec.store.plan.rel.PluginLimitRel;
import org.apache.drill.exec.store.plan.rel.PluginProjectRel;
import org.apache.drill.exec.store.plan.rel.PluginSortRel;
import org.apache.drill.exec.store.plan.rel.PluginUnionRel;
import org.apache.drill.exec.store.plan.rel.StoragePluginTableScan;

public class DrillPluginImplementor
extends AbstractPluginImplementor {
    private DrillGroupScan groupScan;
    private boolean isRoot = true;

    protected Class<? extends StoragePlugin> supportedPlugin() {
        return DrillStoragePlugin.class;
    }

    public void implement(StoragePluginTableScan scan) {
        this.groupScan = (DrillGroupScan)scan.getGroupScan();
        if (this.isRoot) {
            this.completeProcessing((RelNode)scan);
        }
    }

    private void completeProcessing(RelNode scan) {
        String query = this.buildQuery(scan);
        DrillScanSpec scanSpec = new DrillScanSpec(query);
        this.groupScan = new DrillGroupScan(this.groupScan.getUserName(), this.groupScan.getPluginConfig(), scanSpec);
    }

    public void implement(PluginAggregateRel aggregate) throws IOException {
        this.process((RelNode)aggregate);
    }

    private void process(RelNode relNode) throws IOException {
        boolean isRoot = this.isRoot;
        this.isRoot = false;
        for (RelNode input : relNode.getInputs()) {
            this.visitChild(input);
        }
        if (isRoot) {
            this.completeProcessing(relNode);
        }
    }

    public void implement(PluginFilterRel filter) throws IOException {
        this.process((RelNode)filter);
    }

    public void implement(PluginLimitRel limit) throws IOException {
        this.process((RelNode)limit);
    }

    public void implement(PluginProjectRel project) throws IOException {
        this.process((RelNode)project);
    }

    public void implement(PluginSortRel sort) throws IOException {
        this.process((RelNode)sort);
    }

    public void implement(PluginUnionRel union) throws IOException {
        this.process((RelNode)union);
    }

    public void implement(PluginJoinRel join) throws IOException {
        this.process((RelNode)join);
    }

    public boolean canImplement(Aggregate aggregate) {
        return true;
    }

    public boolean canImplement(Filter filter) {
        return true;
    }

    public boolean canImplement(DrillLimitRelBase limit) {
        return true;
    }

    public boolean canImplement(Project project) {
        return true;
    }

    public boolean canImplement(Sort sort) {
        return true;
    }

    public boolean canImplement(Union union) {
        return true;
    }

    public boolean canImplement(TableScan scan) {
        return true;
    }

    public boolean canImplement(Join scan) {
        return true;
    }

    protected boolean hasPluginGroupScan(RelNode node) {
        return this.findGroupScan(node) instanceof DrillGroupScan;
    }

    public GroupScan getPhysicalOperator() {
        return this.groupScan;
    }

    public String buildQuery(RelNode node) {
        SqlDialect dialect = this.groupScan.getDialect();
        DrillRelToSqlConverter jdbcImplementor = new DrillRelToSqlConverter(dialect, (JavaTypeFactory)node.getCluster().getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitRoot(node);
        return result.asStatement().toSqlString(dialect).getSql();
    }

    public static class DrillRelToSqlConverter
    extends JdbcImplementor {
        public DrillRelToSqlConverter(SqlDialect dialect, JavaTypeFactory typeFactory) {
            super(dialect, typeFactory);
        }

        public SqlImplementor.Result visit(PluginLimitRel e) {
            SqlImplementor.Result x = this.visitInput((RelNode)e, 0, new SqlImplementor.Clause[]{SqlImplementor.Clause.OFFSET, SqlImplementor.Clause.FETCH});
            SqlImplementor.Builder builder = x.builder((RelNode)e);
            Optional.ofNullable(e.getFetch()).ifPresent(fetch -> builder.setFetch(builder.context.toSql(null, fetch)));
            Optional.ofNullable(e.getOffset()).ifPresent(offset -> builder.setOffset(builder.context.toSql(null, offset)));
            return builder.result();
        }

        public SqlImplementor.Result visit(TableScan scan) {
            List qualifiedName = scan.getTable().getQualifiedName();
            SqlIdentifier sqlIdentifier = new SqlIdentifier(qualifiedName.subList(1, qualifiedName.size()), SqlParserPos.ZERO);
            return this.result((SqlNode)sqlIdentifier, (Collection)ImmutableList.of((Object)SqlImplementor.Clause.FROM), (RelNode)scan, null);
        }
    }
}

