/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kudu.KuduStoragePlugin;
import org.apache.drill.exec.store.kudu.KuduStoragePluginConfig;

@JsonTypeName(value="kudu-sub-scan")
public class KuduSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "KUDU_SUB_SCAN";
    private final KuduStoragePlugin kuduStoragePlugin;
    private final List<KuduSubScanSpec> tabletScanSpecList;
    private final List<SchemaPath> columns;

    @JsonCreator
    public KuduSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="kuduStoragePluginConfig") KuduStoragePluginConfig kuduStoragePluginConfig, @JsonProperty(value="tabletScanSpecList") LinkedList<KuduSubScanSpec> tabletScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns) throws ExecutionSetupException {
        super((String)null);
        this.kuduStoragePlugin = (KuduStoragePlugin)registry.resolve((StoragePluginConfig)kuduStoragePluginConfig, KuduStoragePlugin.class);
        this.tabletScanSpecList = tabletScanSpecList;
        this.columns = columns;
    }

    public KuduSubScan(KuduStoragePlugin plugin, List<KuduSubScanSpec> tabletInfoList, List<SchemaPath> columns) {
        super((String)null);
        this.kuduStoragePlugin = plugin;
        this.tabletScanSpecList = tabletInfoList;
        this.columns = columns;
    }

    public KuduStoragePluginConfig getKuduStoragePluginConfig() {
        return this.kuduStoragePlugin.getConfig();
    }

    public List<KuduSubScanSpec> getTabletScanSpecList() {
        return this.tabletScanSpecList;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public boolean isExecutable() {
        return false;
    }

    @JsonIgnore
    public KuduStoragePlugin getStorageEngine() {
        return this.kuduStoragePlugin;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KuduSubScan(this.kuduStoragePlugin, this.tabletScanSpecList, this.columns);
    }

    public Iterator<PhysicalOperator> iterator() {
        return ImmutableSet.of().iterator();
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public static class KuduSubScanSpec {
        private final String tableName;
        private final byte[] startKey;
        private final byte[] endKey;

        @JsonCreator
        public KuduSubScanSpec(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="startKey") byte[] startKey, @JsonProperty(value="endKey") byte[] endKey) {
            this.tableName = tableName;
            this.startKey = startKey;
            this.endKey = endKey;
        }

        public String getTableName() {
            return this.tableName;
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }
    }
}

