/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.kudu.KuduGroupScan;
import org.apache.drill.exec.store.kudu.KuduScanSpec;
import org.apache.drill.exec.store.kudu.KuduSchemaFactory;
import org.apache.drill.exec.store.kudu.KuduStoragePluginConfig;
import org.apache.kudu.client.KuduClient;

public class KuduStoragePlugin
extends AbstractStoragePlugin {
    private final KuduStoragePluginConfig engineConfig;
    private final KuduSchemaFactory schemaFactory;
    private final KuduClient client;

    public KuduStoragePlugin(KuduStoragePluginConfig configuration, DrillbitContext context, String name) throws IOException {
        super(context, name);
        this.schemaFactory = new KuduSchemaFactory(this, name);
        this.engineConfig = configuration;
        this.client = new KuduClient.KuduClientBuilder(configuration.getMasterAddresses()).build();
    }

    public KuduClient getClient() {
        return this.client;
    }

    public void close() throws Exception {
        this.client.close();
    }

    public boolean supportsRead() {
        return true;
    }

    public KuduGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        KuduScanSpec scanSpec = (KuduScanSpec)selection.getListWith((TypeReference)new TypeReference<KuduScanSpec>(){});
        return new KuduGroupScan(this, scanSpec, null);
    }

    public boolean supportsWrite() {
        return true;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public KuduStoragePluginConfig getConfig() {
        return this.engineConfig;
    }
}

