/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.zookeeper;

import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.tephra.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.tephra.shaded.com.google.common.util.concurrent.Futures;
import org.apache.tephra.shaded.org.apache.twill.internal.zookeeper.RetryUtils;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.NodeChildren;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.NodeData;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RewatchOnExpireWatcher
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(RewatchOnExpireWatcher.class);
    private final ZKClient client;
    private final ActionType actionType;
    private final String path;
    private final Watcher delegate;
    private final AtomicMarkableReference<Object> lastResult;

    RewatchOnExpireWatcher(ZKClient client, ActionType actionType, String path, Watcher delegate) {
        this.client = client;
        this.actionType = actionType;
        this.path = path;
        this.delegate = delegate;
        this.lastResult = new AtomicMarkableReference<Object>(null, false);
    }

    void setLastResult(Object result) {
        this.lastResult.compareAndSet(null, result, false, true);
    }

    public void process(WatchedEvent event) {
        if (this.delegate != null && event.getType() != Watcher.Event.EventType.None) {
            try {
                this.delegate.process(event);
            }
            catch (Throwable t) {
                LOG.error("Watcher throws exception.", t);
            }
        }
        if (event.getState() != Watcher.Event.KeeperState.Expired) {
            return;
        }
        switch (this.actionType) {
            case EXISTS: {
                this.exists();
                break;
            }
            case CHILDREN: {
                this.children();
                break;
            }
            case DATA: {
                this.data();
            }
        }
    }

    private void exists() {
        Futures.addCallback(this.client.exists(this.path, this), new FutureCallback<Stat>(){

            @Override
            public void onSuccess(Stat stat) {
                Object oldResult = RewatchOnExpireWatcher.this.lastResult.getReference();
                RewatchOnExpireWatcher.this.lastResult.compareAndSet(oldResult, null, true, false);
                if (!(stat == oldResult || stat != null && stat.equals(oldResult))) {
                    if (stat == null) {
                        RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                    } else if (oldResult == null) {
                        RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                    } else {
                        RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                    }
                }
            }

            @Override
            public void onFailure(Throwable t) {
                if (RetryUtils.canRetry(t)) {
                    RewatchOnExpireWatcher.this.exists();
                } else {
                    RewatchOnExpireWatcher.this.lastResult.set(null, false);
                    LOG.error("Fail to re-set watch on exists for path " + RewatchOnExpireWatcher.this.path, t);
                }
            }
        });
    }

    private void children() {
        Futures.addCallback(this.client.getChildren(this.path, this), new FutureCallback<NodeChildren>(){

            @Override
            public void onSuccess(NodeChildren result) {
                Object oldResult = RewatchOnExpireWatcher.this.lastResult.getReference();
                RewatchOnExpireWatcher.this.lastResult.compareAndSet(oldResult, null, true, false);
                if (result.equals(oldResult)) {
                    return;
                }
                if (!(oldResult instanceof NodeChildren)) {
                    LOG.error("The same watcher has been used for different event type.");
                    return;
                }
                NodeChildren oldNodeChildren = (NodeChildren)oldResult;
                if (!result.getChildren().equals(oldNodeChildren.getChildren())) {
                    RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                } else {
                    RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                }
            }

            @Override
            public void onFailure(Throwable t) {
                KeeperException.Code code;
                if (RetryUtils.canRetry(t)) {
                    RewatchOnExpireWatcher.this.children();
                    return;
                }
                RewatchOnExpireWatcher.this.lastResult.set(null, false);
                if (t instanceof KeeperException && (code = ((KeeperException)t).code()) == KeeperException.Code.NONODE) {
                    RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                    return;
                }
                LOG.error("Fail to re-set watch on getChildren for path " + RewatchOnExpireWatcher.this.path, t);
            }
        });
    }

    private void data() {
        Futures.addCallback(this.client.getData(this.path, this), new FutureCallback<NodeData>(){

            @Override
            public void onSuccess(NodeData result) {
                Object oldResult = RewatchOnExpireWatcher.this.lastResult.getReference();
                RewatchOnExpireWatcher.this.lastResult.compareAndSet(oldResult, null, true, false);
                if (!result.equals(oldResult)) {
                    RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                }
            }

            @Override
            public void onFailure(Throwable t) {
                KeeperException.Code code;
                if (RetryUtils.canRetry(t)) {
                    RewatchOnExpireWatcher.this.data();
                    return;
                }
                RewatchOnExpireWatcher.this.lastResult.set(null, false);
                if (t instanceof KeeperException && (code = ((KeeperException)t).code()) == KeeperException.Code.NONODE) {
                    RewatchOnExpireWatcher.this.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, RewatchOnExpireWatcher.this.path));
                    return;
                }
                LOG.error("Fail to re-set watch on getData for path " + RewatchOnExpireWatcher.this.path, t);
            }
        });
    }

    static enum ActionType {
        EXISTS,
        CHILDREN,
        DATA;

    }
}

