/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.tephra.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.tephra.shaded.com.google.common.base.Charsets;
import org.apache.tephra.shaded.com.google.common.primitives.Bytes;
import org.apache.tephra.shaded.com.google.common.primitives.Ints;

public class CommitMarkerCodec
implements Closeable {
    private static final byte[] KEY_BYTES = "count".getBytes(Charsets.UTF_8);
    private final DataOutputBuffer rawKey = new DataOutputBuffer();
    private final DataOutputBuffer rawValue = new DataOutputBuffer();
    private SequenceFile.ValueBytes valueBytes;

    @Override
    public void close() throws IOException {
        this.rawKey.close();
        this.rawValue.close();
    }

    public int readMarker(SequenceFile.Reader reader) throws IOException {
        if (this.valueBytes == null) {
            this.valueBytes = reader.createValueBytes();
        }
        this.rawKey.reset();
        this.rawValue.reset();
        int status2 = reader.nextRaw(this.rawKey, this.valueBytes);
        if (status2 == -1) {
            return -1;
        }
        if (this.isMarkerValid()) {
            this.valueBytes.writeUncompressedBytes((DataOutputStream)this.rawValue);
            this.rawValue.flush();
            return Ints.fromByteArray(this.rawValue.getData());
        }
        throw new IOException(String.format("Invalid key for num entries appended found %s, expected : %s", new String(this.rawKey.getData()), "count"));
    }

    private boolean isMarkerValid() {
        return this.rawKey.getLength() == KEY_BYTES.length && Bytes.indexOf(this.rawKey.getData(), KEY_BYTES) == 0;
    }

    public static void writeMarker(SequenceFile.Writer writer, int count) throws IOException {
        writer.appendRaw(KEY_BYTES, 0, KEY_BYTES.length, (SequenceFile.ValueBytes)new CommitEntriesCount(count));
    }

    @VisibleForTesting
    static final class CommitEntriesCount
    implements SequenceFile.ValueBytes {
        private final int numEntries;

        public CommitEntriesCount(int numEntries) {
            this.numEntries = numEntries;
        }

        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(Ints.toByteArray(this.numEntries));
        }

        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new IllegalArgumentException("Commit Entries count writing is not expected to be compressed.");
        }

        public int getSize() {
            return 4;
        }
    }
}

