/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.TransactionNotInProgressException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.shaded.com.google.common.base.Preconditions;
import org.apache.tephra.shaded.com.google.common.collect.ImmutableList;
import org.apache.tephra.shaded.com.google.common.collect.Lists;
import org.apache.tephra.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContext.class);
    private final Collection<TransactionAware> txAwares;
    private final TransactionSystemClient txClient;
    private Transaction currentTx;

    public TransactionContext(TransactionSystemClient txClient, TransactionAware ... txAwares) {
        this(txClient, ImmutableList.copyOf(txAwares));
    }

    public TransactionContext(TransactionSystemClient txClient, Iterable<TransactionAware> txAwares) {
        this.txAwares = Sets.newLinkedHashSet(txAwares);
        this.txClient = txClient;
    }

    public boolean addTransactionAware(TransactionAware txAware) {
        boolean added = this.txAwares.add(txAware);
        if (added && this.currentTx != null) {
            txAware.startTx(this.currentTx);
        }
        return added;
    }

    public boolean removeTransactionAware(TransactionAware txAware) {
        Preconditions.checkState(this.currentTx == null, "Cannot remove TransactionAware while there is an active transaction.");
        return this.txAwares.remove(txAware);
    }

    public void start() throws TransactionFailureException {
        this.currentTx = this.txClient.startShort();
        this.startAllTxAwares();
    }

    public void start(int timeout) throws TransactionFailureException {
        this.currentTx = this.txClient.startShort(timeout);
        this.startAllTxAwares();
    }

    private void startAllTxAwares() throws TransactionFailureException {
        for (TransactionAware txAware : this.txAwares) {
            try {
                txAware.startTx(this.currentTx);
            }
            catch (Throwable t) {
                try {
                    this.txClient.abort(this.currentTx);
                    TransactionFailureException tfe = this.createTransactionFailure("start", txAware, t);
                    LOG.warn(tfe.getMessage());
                    throw tfe;
                }
                catch (Throwable throwable) {
                    this.currentTx = null;
                    throw throwable;
                }
            }
        }
    }

    public void finish() throws TransactionFailureException {
        Preconditions.checkState(this.currentTx != null, "Cannot finish tx that has not been started");
        this.checkForConflicts();
        this.persist();
        this.commit();
        try {
            this.postCommit();
        }
        finally {
            this.currentTx = null;
        }
    }

    public void abort() throws TransactionFailureException {
        this.abort(null);
    }

    public void checkpoint() throws TransactionFailureException {
        Preconditions.checkState(this.currentTx != null, "Cannot checkpoint tx that has not been started");
        this.persist();
        try {
            this.currentTx = this.txClient.checkpoint(this.currentTx);
            for (TransactionAware txAware : this.txAwares) {
                txAware.updateTx(this.currentTx);
            }
        }
        catch (TransactionNotInProgressException e) {
            String message = String.format("Transaction %d is not in progress.", this.currentTx.getTransactionId());
            LOG.warn(message, (Throwable)e);
            this.abort(new TransactionFailureException(message, (Throwable)e));
        }
        catch (Throwable e) {
            String message = String.format("Exception from checkpoint for transaction %d.", this.currentTx.getTransactionId());
            LOG.warn(message, e);
            this.abort(new TransactionFailureException(message, e));
        }
    }

    @Nullable
    public Transaction getCurrentTransaction() {
        return this.currentTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(TransactionFailureException cause) throws TransactionFailureException {
        if (this.currentTx == null) {
            return;
        }
        try {
            boolean success = true;
            for (TransactionAware txAware : this.txAwares) {
                try {
                    success = txAware.rollbackTx() && success;
                }
                catch (Throwable t) {
                    TransactionFailureException tfe = this.createTransactionFailure("roll back changes in", txAware, t);
                    LOG.warn(tfe.getMessage());
                    if (cause == null) {
                        cause = tfe;
                    } else {
                        cause.addSuppressed((Throwable)tfe);
                    }
                    success = false;
                }
            }
            try {
                if (success) {
                    this.txClient.abort(this.currentTx);
                } else {
                    this.txClient.invalidate(this.currentTx.getTransactionId());
                }
            }
            catch (Throwable t) {
                if (cause == null) {
                    cause = new TransactionFailureException(String.format("Error while calling transaction service to %s transaction %d.", success ? "abort" : "invalidate", this.currentTx.getTransactionId()));
                }
                cause.addSuppressed(t);
            }
            if (cause != null) {
                throw cause;
            }
        }
        finally {
            this.currentTx = null;
        }
    }

    private void checkForConflicts() throws TransactionFailureException {
        ArrayList<byte[]> changes = Lists.newArrayList();
        for (TransactionAware txAware : this.txAwares) {
            try {
                changes.addAll(txAware.getTxChanges());
            }
            catch (Throwable t) {
                TransactionFailureException tfe = this.createTransactionFailure("retrieve changes from", txAware, t);
                LOG.warn(tfe.getMessage());
                this.abort(tfe);
            }
        }
        try {
            this.txClient.canCommitOrThrow(this.currentTx, changes);
        }
        catch (TransactionFailureException e) {
            this.abort(e);
        }
        catch (Throwable e) {
            String message = String.format("Exception from canCommit for transaction %d.", this.currentTx.getTransactionId());
            this.abort(new TransactionFailureException(message, e));
        }
    }

    private void persist() throws TransactionFailureException {
        for (TransactionAware txAware : this.txAwares) {
            boolean success = false;
            Throwable cause = null;
            try {
                success = txAware.commitTx();
            }
            catch (Throwable e) {
                cause = e;
            }
            if (success) continue;
            TransactionFailureException tfe = this.createTransactionFailure("persist changes of", txAware, cause);
            LOG.warn(tfe.getMessage());
            this.abort(tfe);
        }
    }

    private void commit() throws TransactionFailureException {
        try {
            this.txClient.commitOrThrow(this.currentTx);
        }
        catch (TransactionFailureException e) {
            this.abort(e);
        }
        catch (Throwable e) {
            String message = String.format("Exception from commit for transaction %d.", this.currentTx.getTransactionId());
            this.abort(new TransactionFailureException(message, e));
        }
    }

    private void postCommit() throws TransactionFailureException {
        TransactionFailureException cause = null;
        for (TransactionAware txAware : this.txAwares) {
            try {
                txAware.postTxCommit();
            }
            catch (Throwable t) {
                TransactionFailureException tfe = this.createTransactionFailure("perform post-commit for", txAware, t);
                LOG.warn(tfe.getMessage());
                if (cause == null) {
                    cause = tfe;
                    continue;
                }
                cause.addSuppressed((Throwable)tfe);
            }
        }
        if (cause != null) {
            throw cause;
        }
    }

    private TransactionFailureException createTransactionFailure(String action, TransactionAware txAware, Throwable cause) {
        String txAwareName;
        Throwable thrownForName = null;
        try {
            txAwareName = txAware.getTransactionAwareName();
        }
        catch (Throwable t) {
            thrownForName = t;
            txAwareName = "unknown";
        }
        TransactionFailureException tfe = new TransactionFailureException(String.format("Unable to %s transaction-aware '%s' for transaction %d", action, txAwareName, this.currentTx.getTransactionId()), cause);
        if (thrownForName != null) {
            tfe.addSuppressed(thrownForName);
        }
        return tfe;
    }
}

