/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.decoders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.store.easy.json.loader.ClosingStreamIterator;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderOptions;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.MetaDataField;
import org.apache.drill.exec.store.kafka.ReadOptions;
import org.apache.drill.exec.store.kafka.decoders.KafkaJsonLoader;
import org.apache.drill.exec.store.kafka.decoders.MessageReader;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessageReader
implements MessageReader {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageReader.class);
    private final ClosingStreamIterator stream = new ClosingStreamIterator();
    private KafkaJsonLoader kafkaJsonLoader;
    private ResultSetLoader resultSetLoader;
    private SchemaNegotiator negotiator;
    private ReadOptions readOptions;
    private Properties kafkaConsumerProps;

    @Override
    public void init(SchemaNegotiator negotiator, ReadOptions readOptions, KafkaStoragePlugin plugin) {
        this.negotiator = negotiator;
        this.resultSetLoader = negotiator.build();
        this.readOptions = readOptions;
        this.kafkaConsumerProps = plugin.getConfig().getKafkaConsumerProps();
    }

    @Override
    public void readMessage(ConsumerRecord<?, ?> record) {
        block2: {
            byte[] recordArray = (byte[])record.value();
            try {
                this.parseAndWrite(record, recordArray);
            }
            catch (TokenIterator.RecoverableJsonException e) {
                if (this.readOptions.isSkipInvalidRecords()) break block2;
                throw UserException.dataReadError((Throwable)e).message(String.format("Error happened when parsing invalid record. Please set `%s` option to 'true' to skip invalid records.", "store.kafka.reader.skip_invalid_records"), new Object[0]).addContext(this.resultSetLoader.errorContext()).build(logger);
            }
        }
    }

    private void parseAndWrite(ConsumerRecord<?, ?> record, byte[] recordArray) {
        this.stream.setValue((InputStream)new ByteArrayInputStream(recordArray));
        if (this.kafkaJsonLoader == null) {
            JsonLoaderOptions jsonLoaderOptions = new JsonLoaderOptions();
            jsonLoaderOptions.allTextMode = this.readOptions.isAllTextMode();
            jsonLoaderOptions.readNumbersAsDouble = this.readOptions.isReadNumbersAsDouble();
            jsonLoaderOptions.skipMalformedRecords = this.readOptions.isSkipInvalidRecords();
            jsonLoaderOptions.allowNanInf = this.readOptions.isAllowNanInf();
            jsonLoaderOptions.enableEscapeAnyChar = this.readOptions.isAllowEscapeAnyChar();
            jsonLoaderOptions.skipMalformedDocument = this.readOptions.isSkipInvalidRecords();
            this.kafkaJsonLoader = (KafkaJsonLoader)new KafkaJsonLoader.KafkaJsonLoaderBuilder().resultSetLoader(this.resultSetLoader).standardOptions(this.negotiator.queryOptions()).options(jsonLoaderOptions).errorContext(this.negotiator.parentErrorContext()).fromStream(() -> this.stream).build();
        }
        RowSetLoader rowWriter = this.resultSetLoader.writer();
        rowWriter.start();
        if (this.kafkaJsonLoader.parser().next()) {
            this.writeValue(rowWriter, MetaDataField.KAFKA_TOPIC, record.topic());
            this.writeValue(rowWriter, MetaDataField.KAFKA_PARTITION_ID, record.partition());
            this.writeValue(rowWriter, MetaDataField.KAFKA_OFFSET, record.offset());
            this.writeValue(rowWriter, MetaDataField.KAFKA_TIMESTAMP, record.timestamp());
            this.writeValue(rowWriter, MetaDataField.KAFKA_MSG_KEY, record.key() != null ? record.key().toString() : null);
            rowWriter.save();
        }
    }

    private <T> void writeValue(RowSetLoader rowWriter, MetaDataField metaDataField, T value) {
        if (rowWriter.tupleSchema().column(metaDataField.getFieldName()) == null) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)metaDataField.getFieldName(), (TypeProtos.MinorType)metaDataField.getFieldType(), (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        rowWriter.column(metaDataField.getFieldName()).setObject(value);
    }

    @Override
    public ResultSetLoader getResultSetLoader() {
        return this.resultSetLoader;
    }

    @Override
    public KafkaConsumer<byte[], byte[]> getConsumer(KafkaStoragePlugin plugin) {
        return new KafkaConsumer(plugin.getConfig().getKafkaConsumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Override
    public boolean endBatch() {
        this.kafkaJsonLoader.endBatch();
        return this.resultSetLoader.hasRows();
    }

    @Override
    public void close() {
        try {
            this.kafkaJsonLoader.close();
            this.resultSetLoader.close();
        }
        catch (Exception e) {
            logger.warn("Error while closing JsonMessageReader: {}", (Object)e.getMessage());
        }
    }

    public String toString() {
        return new StringJoiner(", ", JsonMessageReader.class.getSimpleName() + "[", "]").add("kafkaJsonLoader=" + String.valueOf((Object)this.kafkaJsonLoader)).add("resultSetLoader=" + String.valueOf(this.resultSetLoader)).toString();
    }
}

