/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.StringJoiner;
import org.apache.drill.exec.server.options.OptionManager;

public class ReadOptions {
    private final String messageReader;
    private final long pollTimeOut;
    private final boolean allTextMode;
    private final boolean readNumbersAsDouble;
    private final boolean enableUnionType;
    private final boolean skipInvalidRecords;
    private final boolean allowNanInf;
    private final boolean allowEscapeAnyChar;

    public ReadOptions(OptionManager optionManager) {
        this.messageReader = optionManager.getString("store.kafka.record.reader");
        this.pollTimeOut = optionManager.getLong("store.kafka.poll.timeout");
        this.allTextMode = optionManager.getBoolean("store.kafka.all_text_mode");
        this.readNumbersAsDouble = optionManager.getBoolean("store.kafka.read_numbers_as_double");
        this.enableUnionType = optionManager.getBoolean("exec.enable_union_type");
        this.skipInvalidRecords = optionManager.getBoolean("store.kafka.reader.skip_invalid_records");
        this.allowNanInf = optionManager.getBoolean("store.kafka.reader.allow_nan_inf");
        this.allowEscapeAnyChar = optionManager.getBoolean("store.kafka.reader.allow_escape_any_char");
    }

    public String getMessageReader() {
        return this.messageReader;
    }

    public long getPollTimeOut() {
        return this.pollTimeOut;
    }

    public boolean isAllTextMode() {
        return this.allTextMode;
    }

    public boolean isReadNumbersAsDouble() {
        return this.readNumbersAsDouble;
    }

    public boolean isEnableUnionType() {
        return this.enableUnionType;
    }

    public boolean isSkipInvalidRecords() {
        return this.skipInvalidRecords;
    }

    public boolean isAllowNanInf() {
        return this.allowNanInf;
    }

    public boolean isAllowEscapeAnyChar() {
        return this.allowEscapeAnyChar;
    }

    public String toString() {
        return new StringJoiner(", ", ReadOptions.class.getSimpleName() + "[", "]").add("messageReader='" + this.messageReader + "'").add("pollTimeOut=" + this.pollTimeOut).add("allTextMode=" + this.allTextMode).add("readNumbersAsDouble=" + this.readNumbersAsDouble).add("enableUnionType=" + this.enableUnionType).add("skipInvalidRecords=" + this.skipInvalidRecords).add("allowNanInf=" + this.allowNanInf).add("allowEscapeAnyChar=" + this.allowEscapeAnyChar).toString();
    }
}

