/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;

class KafkaNodeProcessor
extends AbstractExprVisitor<Boolean, LogicalExpression, RuntimeException> {
    private String functionName;
    private Boolean success;
    private Long value;
    private String path;
    private static final ImmutableSet<Class<? extends LogicalExpression>> VALUE_EXPRESSION_CLASSES;
    private static final ImmutableMap<String, String> COMPARE_FUNCTIONS_TRANSPOSE_MAP;

    public KafkaNodeProcessor(String functionName) {
        this.functionName = functionName;
        this.success = false;
    }

    public static boolean isPushdownFunction(String functionName) {
        return COMPARE_FUNCTIONS_TRANSPOSE_MAP.keySet().contains((Object)functionName);
    }

    public Boolean visitUnknown(LogicalExpression e, LogicalExpression valueArg) throws RuntimeException {
        return false;
    }

    public static KafkaNodeProcessor process(FunctionCall call) {
        String functionName = call.getName();
        LogicalExpression nameArg = call.arg(0);
        LogicalExpression valueArg = call.argCount() >= 2 ? call.arg(1) : null;
        KafkaNodeProcessor evaluator = new KafkaNodeProcessor(functionName);
        if (VALUE_EXPRESSION_CLASSES.contains((Object)nameArg.getClass())) {
            LogicalExpression swapArg = valueArg;
            valueArg = nameArg;
            nameArg = swapArg;
            evaluator.functionName = (String)COMPARE_FUNCTIONS_TRANSPOSE_MAP.get((Object)functionName);
        }
        evaluator.success = (Boolean)nameArg.accept((ExprVisitor)evaluator, (Object)valueArg);
        return evaluator;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getPath() {
        return this.path;
    }

    public Long getValue() {
        return this.value;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Boolean visitSchemaPath(SchemaPath path, LogicalExpression valueArg) throws RuntimeException {
        this.path = path.getRootSegmentPath();
        if (valueArg == null) {
            return false;
        }
        switch (this.path) {
            case "kafkaMsgOffset": {
                if (this.functionName.equals("not_equal")) {
                    return false;
                }
            }
            case "kafkaPartitionId": {
                if (valueArg instanceof ValueExpressions.IntExpression) {
                    this.value = ((ValueExpressions.IntExpression)valueArg).getInt();
                    return true;
                }
                if (!(valueArg instanceof ValueExpressions.LongExpression)) break;
                this.value = ((ValueExpressions.LongExpression)valueArg).getLong();
                return true;
            }
            case "kafkaMsgTimestamp": {
                if (!(this.functionName.equals("equal") || this.functionName.equals("greater_than") || this.functionName.equals("greater_than_or_equal_to"))) {
                    return false;
                }
                if (valueArg instanceof ValueExpressions.LongExpression) {
                    this.value = ((ValueExpressions.LongExpression)valueArg).getLong();
                    return true;
                }
                if (valueArg instanceof ValueExpressions.DateExpression) {
                    this.value = ((ValueExpressions.DateExpression)valueArg).getDate();
                    return true;
                }
                if (valueArg instanceof ValueExpressions.TimeExpression) {
                    this.value = ((ValueExpressions.TimeExpression)valueArg).getTime();
                    return true;
                }
                if (valueArg instanceof ValueExpressions.TimeStampExpression) {
                    this.value = ((ValueExpressions.TimeStampExpression)valueArg).getTimeStamp();
                    return true;
                }
                if (!(valueArg instanceof ValueExpressions.IntExpression)) break;
                this.value = ((ValueExpressions.IntExpression)valueArg).getInt();
                return true;
            }
        }
        return false;
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        VALUE_EXPRESSION_CLASSES = builder.add(ValueExpressions.BooleanExpression.class).add(ValueExpressions.DateExpression.class).add(ValueExpressions.DoubleExpression.class).add(ValueExpressions.FloatExpression.class).add(ValueExpressions.IntExpression.class).add(ValueExpressions.LongExpression.class).add(ValueExpressions.QuotedString.class).add(ValueExpressions.TimeExpression.class).build();
        builder = ImmutableMap.builder();
        COMPARE_FUNCTIONS_TRANSPOSE_MAP = builder.put((Object)"equal", (Object)"equal").put((Object)"not_equal", (Object)"not_equal").put((Object)"greater_than_or_equal_to", (Object)"less_than_or_equal_to").put((Object)"greater_than", (Object)"less_than").put((Object)"less_than_or_equal_to", (Object)"greater_than_or_equal_to").put((Object)"less_than", (Object)"greater_than").build();
    }
}

