/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.exec.store.kafka.KafkaScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;
import org.apache.drill.exec.store.kafka.KafkaSubScan;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="kafka-scan")
public class KafkaGroupScan
extends AbstractGroupScan {
    private static final Logger logger = LoggerFactory.getLogger(KafkaGroupScan.class);
    private static final long MSG_SIZE = 1024L;
    private final KafkaStoragePlugin kafkaStoragePlugin;
    private final KafkaScanSpec kafkaScanSpec;
    private final List<SchemaPath> columns;
    private final int records;
    private ListMultimap<Integer, PartitionScanWork> assignments;
    private List<EndpointAffinity> affinities;
    private Map<TopicPartition, PartitionScanWork> partitionWorkMap;

    @JsonCreator
    public KafkaGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="kafkaStoragePluginConfig") KafkaStoragePluginConfig kafkaStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="records") int records, @JsonProperty(value="kafkaScanSpec") KafkaScanSpec scanSpec, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        this(userName, (KafkaStoragePlugin)pluginRegistry.resolve((StoragePluginConfig)kafkaStoragePluginConfig, KafkaStoragePlugin.class), columns, records, scanSpec);
    }

    public KafkaGroupScan(KafkaStoragePlugin kafkaStoragePlugin, KafkaScanSpec kafkaScanSpec, List<SchemaPath> columns, int records) {
        super("");
        this.kafkaStoragePlugin = kafkaStoragePlugin;
        this.columns = columns;
        this.records = records;
        this.kafkaScanSpec = kafkaScanSpec;
        this.init();
    }

    public KafkaGroupScan(String userName, KafkaStoragePlugin kafkaStoragePlugin, List<SchemaPath> columns, int records, KafkaScanSpec kafkaScanSpec) {
        super(userName);
        this.kafkaStoragePlugin = kafkaStoragePlugin;
        this.columns = columns;
        this.records = records;
        this.kafkaScanSpec = kafkaScanSpec;
        this.init();
    }

    public KafkaGroupScan(KafkaGroupScan that) {
        super((AbstractGroupScan)that);
        this.kafkaStoragePlugin = that.kafkaStoragePlugin;
        this.columns = that.columns;
        this.records = that.records;
        this.kafkaScanSpec = that.kafkaScanSpec;
        this.assignments = that.assignments;
        this.partitionWorkMap = that.partitionWorkMap;
    }

    public KafkaGroupScan(KafkaGroupScan that, List<SchemaPath> columns) {
        super((AbstractGroupScan)that);
        this.kafkaStoragePlugin = that.kafkaStoragePlugin;
        this.columns = columns;
        this.records = that.records;
        this.kafkaScanSpec = that.kafkaScanSpec;
        this.assignments = that.assignments;
        this.partitionWorkMap = that.partitionWorkMap;
    }

    public KafkaGroupScan(KafkaGroupScan that, int records) {
        super((AbstractGroupScan)that);
        this.kafkaStoragePlugin = that.kafkaStoragePlugin;
        this.columns = that.columns;
        this.records = records;
        this.kafkaScanSpec = that.kafkaScanSpec;
        this.assignments = that.assignments;
        this.partitionWorkMap = that.partitionWorkMap;
    }

    private void init() {
        List topicPartitions;
        this.partitionWorkMap = Maps.newHashMap();
        Collection endpoints = this.kafkaStoragePlugin.getContext().getBits();
        Map endpointMap = endpoints.stream().collect(Collectors.toMap(CoordinationProtos.DrillbitEndpoint::getAddress, Function.identity(), (o, n) -> n));
        HashMap startOffsetsMap = Maps.newHashMap();
        HashMap endOffsetsMap = Maps.newHashMap();
        String topicName = this.kafkaScanSpec.getTopicName();
        KafkaConsumer kafkaConsumer = null;
        try {
            kafkaConsumer = new KafkaConsumer(this.kafkaStoragePlugin.getConfig().getKafkaConsumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
            if (!kafkaConsumer.listTopics().containsKey(topicName)) {
                throw UserException.dataReadError().message("Table '%s' does not exist", new Object[]{topicName}).build(logger);
            }
            kafkaConsumer.subscribe(Collections.singletonList(topicName));
            kafkaConsumer.poll(Duration.ofSeconds(5L));
            Set<TopicPartition> assignments = this.waitForConsumerAssignment((Consumer)kafkaConsumer);
            topicPartitions = kafkaConsumer.partitionsFor(topicName);
            kafkaConsumer.seekToBeginning(assignments);
            for (TopicPartition topicPartition : assignments) {
                startOffsetsMap.put(topicPartition, kafkaConsumer.position(topicPartition));
            }
            kafkaConsumer.seekToEnd(assignments);
            for (TopicPartition topicPartition : assignments) {
                endOffsetsMap.put(topicPartition, kafkaConsumer.position(topicPartition));
            }
            this.kafkaStoragePlugin.registerToClose((AutoCloseable)kafkaConsumer);
        }
        catch (Exception e) {
            try {
                throw UserException.dataReadError((Throwable)e).message("Failed to fetch start/end offsets of the topic %s", new Object[]{topicName}).addContext(e.getMessage()).build(logger);
            }
            catch (Throwable throwable) {
                this.kafkaStoragePlugin.registerToClose((AutoCloseable)kafkaConsumer);
                throw throwable;
            }
        }
        for (PartitionInfo partitionInfo : topicPartitions) {
            Node[] inSyncReplicas;
            TopicPartition topicPartition;
            topicPartition = new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
            long lastCommittedOffset = (Long)startOffsetsMap.get(topicPartition);
            long latestOffset = (Long)endOffsetsMap.get(topicPartition);
            logger.debug("Latest offset of {} is {}", (Object)topicPartition, (Object)latestOffset);
            logger.debug("Last committed offset of {} is {}", (Object)topicPartition, (Object)lastCommittedOffset);
            KafkaPartitionScanSpec partitionScanSpec = new KafkaPartitionScanSpec(topicPartition.topic(), topicPartition.partition(), lastCommittedOffset, latestOffset);
            PartitionScanWork work = new PartitionScanWork((EndpointByteMap)new EndpointByteMapImpl(), partitionScanSpec);
            for (Node isr : inSyncReplicas = partitionInfo.inSyncReplicas()) {
                String host = isr.host();
                CoordinationProtos.DrillbitEndpoint ep = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(host);
                if (ep == null) continue;
                work.getByteMap().add(ep, work.getTotalBytes());
            }
            this.partitionWorkMap.put(topicPartition, work);
        }
    }

    private Set<TopicPartition> waitForConsumerAssignment(Consumer consumer) throws InterruptedException {
        long timeout;
        Set assignments = consumer.assignment();
        long waitingForAssigmentTimeout = this.kafkaStoragePlugin.getContext().getOptionManager().getLong("store.kafka.poll.timeout");
        for (timeout = 0L; assignments.isEmpty() && timeout < waitingForAssigmentTimeout; timeout += 500L) {
            Thread.sleep(500L);
            assignments = consumer.assignment();
        }
        if (timeout >= waitingForAssigmentTimeout) {
            throw UserException.dataReadError().message("Consumer assignment wasn't completed within the timeout %s", new Object[]{waitingForAssigmentTimeout}).build(logger);
        }
        return assignments;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
        this.assignments = AssignmentCreator.getMappings(incomingEndpoints, (List)Lists.newArrayList(this.partitionWorkMap.values()));
    }

    public GroupScan applyLimit(int maxRecords) {
        if (maxRecords > this.records) {
            return new KafkaGroupScan(this, maxRecords);
        }
        return null;
    }

    public boolean supportsLimitPushdown() {
        return true;
    }

    public KafkaSubScan getSpecificScan(int minorFragmentId) {
        List workList = this.assignments.get((Object)minorFragmentId);
        List<KafkaPartitionScanSpec> scanSpecList = workList.stream().map(PartitionScanWork::getPartitionScanSpec).collect(Collectors.toList());
        return new KafkaSubScan(this.getUserName(), this.kafkaStoragePlugin, this.columns, this.records, scanSpecList);
    }

    public int getMaxParallelizationWidth() {
        return this.partitionWorkMap.values().size();
    }

    public ScanStats getScanStats() {
        long messageCount = 0L;
        for (PartitionScanWork work : this.partitionWorkMap.values()) {
            messageCount += work.getPartitionScanSpec().getEndOffset() - work.getPartitionScanSpec().getStartOffset();
        }
        return new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, (double)messageCount, 1.0, (double)(messageCount * 1024L));
    }

    public String getDigest() {
        return this.toString();
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KafkaGroupScan(this);
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.affinities == null) {
            this.affinities = AffinityCreator.getAffinityMap((List)Lists.newArrayList(this.partitionWorkMap.values()));
        }
        return this.affinities;
    }

    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        return new KafkaGroupScan(this, columns);
    }

    public GroupScan cloneWithNewSpec(List<KafkaPartitionScanSpec> partitionScanSpecList) {
        KafkaGroupScan clone = new KafkaGroupScan(this);
        HashSet partitionsInSpec = Sets.newHashSet();
        for (KafkaPartitionScanSpec scanSpec : partitionScanSpecList) {
            TopicPartition tp2 = new TopicPartition(scanSpec.getTopicName(), scanSpec.getPartitionId());
            partitionsInSpec.add(tp2);
            PartitionScanWork newScanWork = new PartitionScanWork(this.partitionWorkMap.get(tp2).getByteMap(), scanSpec);
            clone.partitionWorkMap.put(tp2, newScanWork);
        }
        clone.partitionWorkMap.keySet().removeIf(tp -> !partitionsInSpec.contains(tp));
        return clone;
    }

    @JsonProperty
    public KafkaStoragePluginConfig getKafkaStoragePluginConfig() {
        return this.kafkaStoragePlugin.getConfig();
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getRecords() {
        return this.records;
    }

    @JsonProperty
    public KafkaScanSpec getKafkaScanSpec() {
        return this.kafkaScanSpec;
    }

    @JsonIgnore
    public KafkaStoragePlugin getStoragePlugin() {
        return this.kafkaStoragePlugin;
    }

    public String toString() {
        return new PlanStringBuilder("").field("scanSpec", (Object)this.kafkaScanSpec).field("columns", this.columns).field("records", this.records).toString();
    }

    @JsonIgnore
    public List<KafkaPartitionScanSpec> getPartitionScanSpecList() {
        return this.partitionWorkMap.values().stream().map(work -> work.partitionScanSpec.clone()).collect(Collectors.toList());
    }

    public static class PartitionScanWork
    implements CompleteWork {
        private final EndpointByteMapImpl byteMap;
        private final KafkaPartitionScanSpec partitionScanSpec;

        public PartitionScanWork(EndpointByteMap byteMap, KafkaPartitionScanSpec partitionScanSpec) {
            this.byteMap = (EndpointByteMapImpl)byteMap;
            this.partitionScanSpec = partitionScanSpec;
        }

        public int compareTo(CompleteWork o) {
            return Long.compare(this.getTotalBytes(), o.getTotalBytes());
        }

        public long getTotalBytes() {
            return (this.partitionScanSpec.getEndOffset() - this.partitionScanSpec.getStartOffset()) * 1024L;
        }

        public EndpointByteMap getByteMap() {
            return this.byteMap;
        }

        public KafkaPartitionScanSpec getPartitionScanSpec() {
            return this.partitionScanSpec;
        }
    }
}

