/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB.client.query;

import java.util.HashSet;
import java.util.Set;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.openTSDB.client.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBQuery {
    private static final Logger log = LoggerFactory.getLogger(DBQuery.class);
    private String start;
    private String end;
    private Set<Query> queries;

    private DBQuery(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.queries = builder.queries;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public Set<Query> getQueries() {
        return this.queries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBQuery dbQuery = (DBQuery)o;
        if (!this.start.equals(dbQuery.start)) {
            return false;
        }
        if (!this.end.equals(dbQuery.end)) {
            return false;
        }
        return this.queries.equals(dbQuery.queries);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + this.queries.hashCode();
        return result;
    }

    public String toString() {
        return "DBQuery{start='" + this.start + "', end='" + this.end + "', queries=" + String.valueOf(this.queries) + "}";
    }

    public static class Builder {
        private String start;
        private String end;
        private Set<Query> queries = new HashSet<Query>();

        public Builder setStartTime(String startTime) {
            if (startTime == null) {
                throw UserException.validationError().message("start param must be specified", new Object[0]).build(log);
            }
            this.start = startTime;
            return this;
        }

        public Builder setEndTime(String endTime) {
            this.end = endTime;
            return this;
        }

        public Builder setQueries(Set<Query> queries) {
            if (queries.isEmpty()) {
                throw UserException.validationError().message("Required params such as metric, aggregator weren't specified. Add these params to the query", new Object[0]).build(log);
            }
            this.queries = queries;
            return this;
        }

        public DBQuery build() {
            return new DBQuery(this);
        }
    }
}

