/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.HostnameExtracter;
import nl.basjes.parse.useragent.utils.Normalize;

public class CalculateDeviceBrand
extends FieldCalculator {
    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField.MutableAgentField deviceBrand = userAgent.get("DeviceBrand");
        if (deviceBrand.isDefaultValue()) {
            String newDeviceBrand = this.determineDeviceBrand(userAgent);
            if (newDeviceBrand != null) {
                userAgent.setForced("DeviceBrand", newDeviceBrand, 0L);
            } else {
                userAgent.setForced("DeviceBrand", "<<<null>>>", 0L);
            }
        } else {
            userAgent.setForced("DeviceBrand", Normalize.brand(deviceBrand.getValue()), deviceBrand.getConfidence());
        }
    }

    private String determineDeviceBrand(UserAgent userAgent) {
        String deviceBrand = null;
        AgentField informationUrl = userAgent.get("AgentInformationUrl");
        if (!informationUrl.isDefaultValue()) {
            deviceBrand = HostnameExtracter.extractBrandFromUrl(informationUrl.getValue());
        }
        if (deviceBrand != null) {
            return deviceBrand;
        }
        AgentField informationEmail = userAgent.get("AgentInformationEmail");
        if (!informationEmail.isDefaultValue()) {
            deviceBrand = HostnameExtracter.extractBrandFromEmail(informationEmail.getValue());
        }
        return deviceBrand;
    }

    @Override
    public String getCalculatedFieldName() {
        return "DeviceBrand";
    }

    @Override
    public Set<String> getDependencies() {
        return new HashSet<String>(Arrays.asList("AgentInformationUrl", "AgentInformationEmail"));
    }
}

