/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.delta.format.DeltaFormatPlugin;
import org.apache.drill.exec.store.delta.format.DeltaFormatPluginConfig;
import org.apache.drill.exec.store.parquet.AbstractParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="delta-row-group-scan")
public class DeltaRowGroupScan
extends AbstractParquetRowGroupScan {
    public static final String OPERATOR_TYPE = "DELTA_ROW_GROUP_SCAN";
    private final DeltaFormatPlugin formatPlugin;
    private final DeltaFormatPluginConfig formatPluginConfig;
    private final Map<Path, Map<String, String>> partitions;

    @JsonCreator
    public DeltaRowGroupScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="storageConfig") StoragePluginConfig storageConfig, @JsonProperty(value="formatPluginConfig") FormatPluginConfig formatPluginConfig, @JsonProperty(value="rowGroupReadEntries") List<RowGroupReadEntry> rowGroupReadEntries, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="partitions") Map<Path, Map<String, String>> partitions, @JsonProperty(value="readerConfig") ParquetReaderConfig readerConfig, @JsonProperty(value="filter") LogicalExpression filter, @JsonProperty(value="schema") TupleMetadata schema) {
        this(userName, (DeltaFormatPlugin)registry.resolveFormat(storageConfig, formatPluginConfig, DeltaFormatPlugin.class), rowGroupReadEntries, columns, partitions, readerConfig, filter, schema);
    }

    public DeltaRowGroupScan(String userName, DeltaFormatPlugin formatPlugin, List<RowGroupReadEntry> rowGroupReadEntries, List<SchemaPath> columns, Map<Path, Map<String, String>> partitions, ParquetReaderConfig readerConfig, LogicalExpression filter, TupleMetadata schema) {
        super(userName, rowGroupReadEntries, columns, readerConfig, filter, null, schema);
        this.formatPlugin = formatPlugin;
        this.formatPluginConfig = formatPlugin.getConfig();
        this.partitions = partitions;
    }

    @JsonProperty
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty
    public DeltaFormatPluginConfig getFormatPluginConfig() {
        return this.formatPluginConfig;
    }

    @JsonProperty
    public Map<Path, Map<String, String>> getPartitions() {
        return this.partitions;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new DeltaRowGroupScan(this.getUserName(), this.formatPlugin, this.rowGroupReadEntries, this.columns, this.partitions, this.readerConfig, this.filter, this.schema);
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public AbstractParquetRowGroupScan copy(List<SchemaPath> columns) {
        return new DeltaRowGroupScan(this.getUserName(), this.formatPlugin, this.rowGroupReadEntries, columns, this.partitions, this.readerConfig, this.filter, this.schema);
    }

    public Configuration getFsConf(RowGroupReadEntry rowGroupReadEntry) {
        return this.formatPlugin.getFsConf();
    }

    public boolean supportsFileImplicitColumns() {
        return true;
    }

    public List<String> getPartitionValues(RowGroupReadEntry rowGroupReadEntry) {
        return Collections.emptyList();
    }

    public Map<String, String> getPartitions(RowGroupReadEntry rowGroupReadEntry) {
        return this.partitions.get(rowGroupReadEntry.getPath());
    }

    public boolean isImplicitColumn(SchemaPath path, String partitionColumnLabel) {
        return this.partitions.values().stream().anyMatch(map -> map.containsKey(path.getAsUnescapedPath()));
    }
}

