/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.DeltaScan;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.data.CloseableIterator;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.StatisticsProvider;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScanWithMetadata;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.delta.DeltaParquetTableMetadataProvider;
import org.apache.drill.exec.store.delta.DeltaRowGroupScan;
import org.apache.drill.exec.store.delta.format.DeltaFormatPlugin;
import org.apache.drill.exec.store.delta.plan.DrillExprToDeltaTranslator;
import org.apache.drill.exec.store.delta.snapshot.DeltaSnapshotFactory;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.parquet.AbstractParquetGroupScan;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.metadata.Metadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="delta-scan")
public class DeltaGroupScan
extends AbstractParquetGroupScan {
    private final DeltaFormatPlugin formatPlugin;
    private final String path;
    private final TupleMetadata schema;
    private final LogicalExpression condition;
    private final DrillFileSystem fs;
    private List<AddFile> addFiles;
    private List<EndpointAffinity> endpointAffinities;
    private final Map<Path, Map<String, String>> partitionHolder;

    @JsonCreator
    public DeltaGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="entries") List<ReadEntryWithPath> entries, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="path") String path, @JsonProperty(value="readerConfig") ParquetReaderConfig readerConfig, @JsonProperty(value="condition") LogicalExpression condition, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="partitionHolder") Map<Path, Map<String, String>> partitionHolder, @JacksonInject StoragePluginRegistry pluginRegistry) throws IOException {
        super(ImpersonationUtil.resolveUserName((String)userName), columns, entries, readerConfig, condition);
        this.formatPlugin = (DeltaFormatPlugin)pluginRegistry.resolveFormat(storageConfig, formatConfig, DeltaFormatPlugin.class);
        this.columns = columns;
        this.path = path;
        this.schema = schema;
        this.condition = condition;
        this.limit = limit;
        this.fs = ImpersonationUtil.createFileSystem((String)ImpersonationUtil.resolveUserName((String)userName), (Configuration)this.formatPlugin.getFsConf());
        DeltaParquetTableMetadataProvider metadataProvider = ((DeltaParquetTableMetadataProvider.Builder)((DeltaParquetTableMetadataProvider.Builder)((DeltaParquetTableMetadataProvider.Builder)this.defaultTableMetadataProviderBuilder((MetadataProviderManager)new FileSystemMetadataProviderManager()).withEntries(entries)).withFormatPlugin(this.formatPlugin).withReaderConfig(readerConfig)).withSchema(schema)).build();
        this.metadataProvider = metadataProvider;
        this.entries = metadataProvider.getEntries();
        this.partitionHolder = partitionHolder;
        this.fileSet = metadataProvider.getFileSet();
        this.init();
    }

    private DeltaGroupScan(DeltaGroupScanBuilder builder) throws IOException {
        super(ImpersonationUtil.resolveUserName((String)builder.userName), builder.columns, builder.entries, builder.readerConfig, builder.condition);
        this.formatPlugin = builder.formatPlugin;
        this.columns = builder.columns;
        this.path = builder.path;
        this.schema = builder.schema;
        this.condition = builder.condition;
        this.limit = builder.limit;
        this.fs = ImpersonationUtil.createFileSystem((String)ImpersonationUtil.resolveUserName((String)this.userName), (Configuration)this.formatPlugin.getFsConf());
        DeltaParquetTableMetadataProvider metadataProvider = ((DeltaParquetTableMetadataProvider.Builder)((DeltaParquetTableMetadataProvider.Builder)((DeltaParquetTableMetadataProvider.Builder)this.defaultTableMetadataProviderBuilder((MetadataProviderManager)new FileSystemMetadataProviderManager()).withEntries(this.entries)).withFormatPlugin(this.formatPlugin).withReaderConfig(this.readerConfig)).withSchema(this.schema)).build();
        this.metadataProvider = metadataProvider;
        this.entries = metadataProvider.getEntries();
        this.partitionHolder = builder.partitionValues;
        this.fileSet = metadataProvider.getFileSet();
        this.init();
    }

    private DeltaGroupScan(DeltaGroupScan that) {
        super((AbstractParquetGroupScan)that);
        this.columns = that.columns;
        this.formatPlugin = that.formatPlugin;
        this.path = that.path;
        this.condition = that.condition;
        this.schema = that.schema;
        this.mappings = that.mappings;
        this.fs = that.fs;
        this.limit = that.limit;
        this.addFiles = that.addFiles;
        this.endpointAffinities = that.endpointAffinities;
        this.partitionHolder = that.partitionHolder;
    }

    protected DeltaParquetTableMetadataProvider.Builder tableMetadataProviderBuilder(MetadataProviderManager source) {
        return this.defaultTableMetadataProviderBuilder(source);
    }

    protected DeltaParquetTableMetadataProvider.Builder defaultTableMetadataProviderBuilder(MetadataProviderManager source) {
        return new DeltaParquetTableMetadataProvider.Builder(source);
    }

    public static DeltaGroupScanBuilder builder() {
        return new DeltaGroupScanBuilder();
    }

    public DeltaGroupScan clone(List<SchemaPath> columns) {
        DeltaGroupScan groupScan = new DeltaGroupScan(this);
        groupScan.columns = columns;
        return groupScan;
    }

    public DeltaGroupScan applyLimit(int maxRecords) {
        DeltaGroupScan clone = new DeltaGroupScan(this);
        clone.limit = maxRecords;
        return clone;
    }

    public SubScan getSpecificScan(int minorFragmentId) {
        List readEntries = this.getReadEntries(minorFragmentId);
        HashMap<Path, Map<String, String>> subPartitionHolder = new HashMap<Path, Map<String, String>>();
        for (RowGroupReadEntry readEntry : readEntries) {
            Map<String, String> values = this.partitionHolder.get(readEntry.getPath());
            subPartitionHolder.put(readEntry.getPath(), values);
        }
        return new DeltaRowGroupScan(this.getUserName(), this.formatPlugin, readEntries, this.columns, subPartitionHolder, this.readerConfig, this.filter, this.getTableMetadata().getSchema());
    }

    public DeltaGroupScan clone(FileSelection selection) throws IOException {
        DeltaGroupScan newScan = new DeltaGroupScan(this);
        newScan.modifyFileSelection(selection);
        newScan.init();
        return newScan;
    }

    protected AbstractParquetGroupScan.RowGroupScanFilterer<?> getFilterer() {
        return new DeltaParquetScanFilterer(this);
    }

    protected Collection<CoordinationProtos.DrillbitEndpoint> getDrillbits() {
        return this.formatPlugin.getContext().getBits();
    }

    protected AbstractParquetGroupScan cloneWithFileSelection(Collection<Path> filePaths) throws IOException {
        FileSelection newSelection = new FileSelection(null, new ArrayList<Path>(filePaths), null, null, false);
        return this.clone(newSelection);
    }

    protected boolean supportsFileImplicitColumns() {
        return false;
    }

    protected List<String> getPartitionValues(LocationProvider locationProvider) {
        return Collections.emptyList();
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new DeltaGroupScan(this);
    }

    public boolean supportsLimitPushdown() {
        return false;
    }

    @JsonProperty(value="schema")
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="condition")
    public LogicalExpression getCondition() {
        return this.condition;
    }

    @JsonProperty(value="partitionHolder")
    public Map<Path, Map<String, String>> getPartitionHolder() {
        return this.partitionHolder;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("path", this.path).field("entries", (Object)this.entries).field("schema", (Object)this.schema).field("columns", (Object)this.columns).field("addFiles", this.addFiles).field("limit", this.limit).field("numFiles", this.getEntries().size()).toString();
    }

    public static class DeltaGroupScanBuilder {
        private String userName;
        private DeltaFormatPlugin formatPlugin;
        private TupleMetadata schema;
        private String path;
        private LogicalExpression condition;
        private List<SchemaPath> columns;
        private int limit;
        private List<ReadEntryWithPath> entries;
        private ParquetReaderConfig readerConfig = ParquetReaderConfig.getDefaultInstance();
        private Map<Path, Map<String, String>> partitionValues;

        public DeltaGroupScanBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public DeltaGroupScanBuilder formatPlugin(DeltaFormatPlugin formatPlugin) {
            this.formatPlugin = formatPlugin;
            return this;
        }

        public DeltaGroupScanBuilder schema(TupleMetadata schema) {
            this.schema = schema;
            return this;
        }

        public DeltaGroupScanBuilder path(String path) {
            this.path = path;
            return this;
        }

        public DeltaGroupScanBuilder condition(LogicalExpression condition) {
            this.condition = condition;
            return this;
        }

        public DeltaGroupScanBuilder columns(List<SchemaPath> columns) {
            this.columns = columns;
            return this;
        }

        public DeltaGroupScanBuilder limit(int maxRecords) {
            this.limit = maxRecords;
            return this;
        }

        public DeltaGroupScanBuilder readerConfig(ParquetReaderConfig readerConfig) {
            this.readerConfig = readerConfig;
            return this;
        }

        public DeltaGroupScan build() throws IOException {
            DeltaLog log = DeltaLog.forTable((Configuration)this.formatPlugin.getFsConf(), (String)this.path);
            DeltaSnapshotFactory.SnapshotContext context = DeltaSnapshotFactory.SnapshotContext.builder().snapshotAsOfTimestamp(this.formatPlugin.getConfig().getTimestamp()).snapshotAsOfVersion(this.formatPlugin.getConfig().getVersion()).build();
            Snapshot snapshot = DeltaSnapshotFactory.INSTANCE.create(context).apply(log);
            StructType structType = snapshot.getMetadata().getSchema();
            this.schema = this.toSchema(structType);
            DeltaScan scan = Optional.ofNullable(this.condition).map(c -> (Expression)c.accept((ExprVisitor)new DrillExprToDeltaTranslator(structType), null)).map(arg_0 -> ((Snapshot)snapshot).scan(arg_0)).orElse(snapshot.scan());
            try {
                CloseableIterator files = scan.getFiles();
                ArrayList addFiles = Lists.newArrayList(() -> files);
                this.entries = addFiles.stream().map(addFile -> new ReadEntryWithPath(new Path(URI.create(this.path).getPath(), URI.create(addFile.getPath()).getPath()))).collect(Collectors.toList());
                this.partitionValues = addFiles.stream().collect(Collectors.toMap(addFile -> new Path(URI.create(this.path).getPath(), URI.create(addFile.getPath()).getPath()), addFile -> this.collectPartitionedValues(snapshot, (AddFile)addFile)));
                files.close();
            }
            catch (IOException e) {
                throw new DrillRuntimeException((Throwable)e);
            }
            return new DeltaGroupScan(this);
        }

        private Map<String, String> collectPartitionedValues(Snapshot snapshot, AddFile addFile) {
            LinkedHashMap<String, String> partitionValues = new LinkedHashMap<String, String>();
            snapshot.getMetadata().getPartitionColumns().stream().map(col -> Pair.of((Object)col, (Object)((String)addFile.getPartitionValues().get(col)))).forEach(pair -> partitionValues.put((String)pair.getKey(), (String)pair.getValue()));
            return partitionValues;
        }

        private TupleMetadata toSchema(StructType structType) {
            TupleBuilder tupleBuilder = new TupleBuilder();
            for (StructField field : structType.getFields()) {
                tupleBuilder.addColumn(this.toColumnMetadata(field));
            }
            return tupleBuilder.schema();
        }

        private ColumnMetadata toColumnMetadata(StructField field) {
            DataType dataType = field.getDataType();
            if (dataType instanceof ArrayType) {
                DataType elementType = ((ArrayType)dataType).getElementType();
                if (elementType instanceof ArrayType) {
                    return MetadataUtils.newRepeatedList((String)field.getName(), (ColumnMetadata)this.toColumnMetadata(new StructField(field.getName(), ((ArrayType)elementType).getElementType(), false)));
                }
                if (elementType instanceof StructType) {
                    return MetadataUtils.newMapArray((String)field.getName(), (TupleMetadata)this.toSchema((StructType)elementType));
                }
                return MetadataUtils.newScalar((String)field.getName(), (TypeProtos.MinorType)this.toMinorType(elementType), (TypeProtos.DataMode)TypeProtos.DataMode.REPEATED);
            }
            if (dataType instanceof StructType) {
                return MetadataUtils.newMap((String)field.getName(), (TupleMetadata)this.toSchema((StructType)dataType));
            }
            return MetadataUtils.newScalar((String)field.getName(), (TypeProtos.MinorType)this.toMinorType(field.getDataType()), (TypeProtos.DataMode)(field.isNullable() ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED));
        }

        private TypeProtos.MinorType toMinorType(DataType dataType) {
            if (dataType instanceof BinaryType) {
                return TypeProtos.MinorType.VARBINARY;
            }
            if (dataType instanceof BooleanType) {
                return TypeProtos.MinorType.BIT;
            }
            if (dataType instanceof ByteType) {
                return TypeProtos.MinorType.TINYINT;
            }
            if (dataType instanceof DateType) {
                return TypeProtos.MinorType.DATE;
            }
            if (dataType instanceof DecimalType) {
                return TypeProtos.MinorType.VARDECIMAL;
            }
            if (dataType instanceof DoubleType) {
                return TypeProtos.MinorType.FLOAT8;
            }
            if (dataType instanceof FloatType) {
                return TypeProtos.MinorType.FLOAT4;
            }
            if (dataType instanceof IntegerType) {
                return TypeProtos.MinorType.INT;
            }
            if (dataType instanceof LongType) {
                return TypeProtos.MinorType.BIGINT;
            }
            if (dataType instanceof ShortType) {
                return TypeProtos.MinorType.SMALLINT;
            }
            if (dataType instanceof StringType) {
                return TypeProtos.MinorType.VARCHAR;
            }
            if (dataType instanceof TimestampType) {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            throw new DrillRuntimeException("Unsupported data type: " + String.valueOf(dataType));
        }
    }

    private static class DeltaParquetScanFilterer
    extends AbstractParquetGroupScan.RowGroupScanFilterer<DeltaParquetScanFilterer> {
        public DeltaParquetScanFilterer(DeltaGroupScan source) {
            super((AbstractGroupScanWithMetadata)source);
        }

        protected AbstractParquetGroupScan getNewScan() {
            return new DeltaGroupScan((DeltaGroupScan)this.source);
        }

        protected DeltaParquetScanFilterer self() {
            return this;
        }

        protected <T extends Metadata> Map<SchemaPath, ColumnStatistics<?>> getImplicitColumnStatistics(OptionManager optionManager, T metadata, Map<SchemaPath, ColumnStatistics<?>> columnsStatistics) {
            if (metadata instanceof LocationProvider && optionManager != null) {
                LocationProvider locationProvider = (LocationProvider)metadata;
                columnsStatistics = new HashMap(columnsStatistics);
                Map<String, String> partitions = ((DeltaGroupScan)this.source).getPartitionHolder().get(locationProvider.getPath());
                for (Map.Entry<String, String> partitionValue : partitions.entrySet()) {
                    TypeProtos.MinorType minorType = this.tableSchema.column(partitionValue.getKey()).getType().getMinorType();
                    String value = partitionValue.getValue();
                    if (value != null) {
                        columnsStatistics.put(SchemaPath.getCompoundPath((String[])new String[]{partitionValue.getKey()}), StatisticsProvider.getConstantColumnStatistics((Object)this.castPartitionValue(value, minorType), (TypeProtos.MinorType)minorType));
                        continue;
                    }
                    Long rowCount = (Long)TableStatisticsKind.ROW_COUNT.getValue(metadata);
                    columnsStatistics.put(SchemaPath.getCompoundPath((String[])new String[]{partitionValue.getKey()}), StatisticsProvider.getColumnStatistics(null, null, (long)rowCount, (TypeProtos.MinorType)minorType));
                }
            }
            return columnsStatistics;
        }

        private Object castPartitionValue(String value, TypeProtos.MinorType type) {
            switch (type) {
                case BIT: {
                    return Boolean.parseBoolean(value);
                }
                case TINYINT: {
                    return Byte.parseByte(value);
                }
                case SMALLINT: {
                    return Short.parseShort(value);
                }
                case INT: {
                    return Integer.parseInt(value);
                }
                case BIGINT: {
                    return Long.parseLong(value);
                }
                case FLOAT4: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case FLOAT8: {
                    return Double.parseDouble(value);
                }
                case DATE: {
                    return DateUtility.parseLocalDate((String)value);
                }
                case TIME: {
                    return DateUtility.parseLocalTime((String)value);
                }
                case TIMESTAMP: {
                    return DateUtility.parseBest((String)value);
                }
                case VARCHAR: {
                    return value;
                }
                case VARDECIMAL: {
                    return new BigDecimal(value);
                }
            }
            throw new UnsupportedOperationException("Unsupported partition type: " + String.valueOf(type));
        }
    }
}

