/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.SQLException;
import sqlline.AbstractOutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

public class JsonOutputFormat
extends AbstractOutputFormat {
    private int[] columnTypes;

    public JsonOutputFormat(SqlLine sqlLine) {
        super(sqlLine);
    }

    @Override
    void printHeader(Rows.Row header) {
        this.sqlLine.output("{\"resultset\":[");
    }

    @Override
    void printFooter(Rows.Row header) {
        this.sqlLine.output("]}");
        this.columnTypes = null;
    }

    @Override
    void printRow(Rows rows, Rows.Row header, Rows.Row row) {
        String[] head = header.values;
        String[] vals = row.values;
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < head.length && i < vals.length; ++i) {
            if (this.columnTypes == null) {
                this.initColumnTypes(rows, header);
            }
            sb.append("\"").append(head[i]).append("\":");
            this.setJsonValue(sb, vals[i], this.columnTypes[i]);
            sb.append(i < head.length - 1 && i < vals.length - 1 ? "," : "");
        }
        sb.append(rows.hasNext() ? "}," : "}");
        this.sqlLine.output(sb.toString());
    }

    private void setJsonValue(StringBuilder sb, String value, int columnTypeId) {
        if (value == null) {
            sb.append(value);
            return;
        }
        switch (columnTypeId) {
            case -6: 
            case -5: 
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                sb.append(value);
                return;
            }
            case 16: {
                sb.append(value.equalsIgnoreCase("TRUE"));
                return;
            }
        }
        sb.append("\"");
        for (int i = 0; i < value.length(); ++i) {
            if (Rows.ESCAPING_MAP.get(Character.valueOf(value.charAt(i))) != null) {
                sb.append(Rows.ESCAPING_MAP.get(Character.valueOf(value.charAt(i))));
                continue;
            }
            sb.append(value.charAt(i));
        }
        sb.append("\"");
    }

    private void initColumnTypes(Rows rows, Rows.Row header) {
        this.columnTypes = new int[header.values.length];
        for (int j = 0; j < header.values.length; ++j) {
            try {
                this.columnTypes[j] = rows.rsMeta.getColumnType(j + 1);
                continue;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

