/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import oadd.org.apache.calcite.avatica.AvaticaResultSet;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillStatement;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillRemoteStatement;

public class DrillStatementImpl
extends AvaticaStatement
implements DrillStatement,
DrillRemoteStatement {
    private final DrillConnectionImpl connection;

    DrillStatementImpl(DrillConnectionImpl connection, Meta.StatementHandle h2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, h2, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.connection = connection;
        connection.openStatementsRegistry.addStatement(this);
    }

    @Override
    protected void checkOpen() throws AlreadyClosedSqlException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Statement is already closed.");
        }
    }

    @Override
    public DrillConnectionImpl getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return super.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return super.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return super.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return super.executeUpdate(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return super.executeUpdate(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void cleanUp() {
        this.connection.openStatementsRegistry.removeStatement(this);
    }

    @Override
    public boolean isClosed() {
        try {
            return super.isClosed();
        }
        catch (SQLException e) {
            throw new DrillRuntimeException("Unexpected exception from " + String.valueOf(this.getClass().getSuperclass()) + ".isClosed(): " + String.valueOf(e), e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            super.setEscapeProcessing(enable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            super.setCursorName(name);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return super.getMoreResults();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            super.addBatch(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            super.clearBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        try {
            return super.executeBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            return super.getMoreResults(current);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return super.getGeneratedKeys();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return super.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return super.execute(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return super.execute(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return super.execute(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        try {
            super.setPoolable(poolable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setResultSet(AvaticaResultSet resultSet) {
        this.openResultSet = resultSet;
    }

    @Override
    public void setUpdateCount(int value) {
        this.updateCount = value;
    }

    @Override
    public void setLargeMaxRows(long maxRowCount) throws SQLException {
        super.setLargeMaxRows(maxRowCount);
        this.execute("ALTER SESSION SET `exec.query.max_rows`=" + maxRowCount);
    }
}

