/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.reflections.serializers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oadd.com.google.common.base.Supplier;
import oadd.com.google.common.collect.Multimap;
import oadd.com.google.common.collect.Multimaps;
import oadd.com.google.common.collect.SetMultimap;
import oadd.com.google.common.collect.Sets;
import oadd.com.google.common.io.Files;
import oadd.com.google.gson.Gson;
import oadd.com.google.gson.GsonBuilder;
import oadd.com.google.gson.JsonArray;
import oadd.com.google.gson.JsonDeserializationContext;
import oadd.com.google.gson.JsonDeserializer;
import oadd.com.google.gson.JsonElement;
import oadd.com.google.gson.JsonObject;
import oadd.com.google.gson.JsonParseException;
import oadd.com.google.gson.JsonSerializationContext;
import oadd.org.reflections.Reflections;
import oadd.org.reflections.serializers.Serializer;
import oadd.org.reflections.util.Utils;

public class JsonSerializer
implements Serializer {
    private Gson gson;

    public Reflections read(InputStream inputStream) {
        return this.getGson().fromJson((Reader)new InputStreamReader(inputStream), Reflections.class);
    }

    public File save(Reflections reflections, String filename) {
        try {
            File file = Utils.prepareFile(filename);
            Files.write(this.toString(reflections), file, Charset.defaultCharset());
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(Reflections reflections) {
        return this.getGson().toJson(reflections);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Multimap.class), new oadd.com.google.gson.JsonSerializer<Multimap>(){

                @Override
                public JsonElement serialize(Multimap multimap, Type type, JsonSerializationContext jsonSerializationContext) {
                    return jsonSerializationContext.serialize(multimap.asMap());
                }
            }).registerTypeAdapter((Type)((Object)Multimap.class), new JsonDeserializer<Multimap>(){

                @Override
                public Multimap deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    SetMultimap map = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                        @Override
                        public Set<String> get() {
                            return Sets.newHashSet();
                        }
                    });
                    for (Map.Entry<String, JsonElement> entry : ((JsonObject)jsonElement).entrySet()) {
                        for (JsonElement element : (JsonArray)entry.getValue()) {
                            map.get(entry.getKey()).add(element.getAsString());
                        }
                    }
                    return map;
                }
            }).setPrettyPrinting().create();
        }
        return this.gson;
    }
}

