/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.util.Shell;
import oadd.org.apache.hadoop.util.SysInfoLinux;
import oadd.org.apache.hadoop.util.SysInfoWindows;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SysInfo {
    public static SysInfo newInstance() {
        if (Shell.LINUX) {
            return new SysInfoLinux();
        }
        if (Shell.WINDOWS) {
            return new SysInfoWindows();
        }
        throw new UnsupportedOperationException("Could not determine OS");
    }

    public abstract long getVirtualMemorySize();

    public abstract long getPhysicalMemorySize();

    public abstract long getAvailableVirtualMemorySize();

    public abstract long getAvailablePhysicalMemorySize();

    public abstract int getNumProcessors();

    public abstract int getNumCores();

    public abstract long getCpuFrequency();

    public abstract long getCumulativeCpuTime();

    public abstract float getCpuUsagePercentage();

    public abstract float getNumVCoresUsed();

    public abstract long getNetworkBytesRead();

    public abstract long getNetworkBytesWritten();

    public abstract long getStorageBytesRead();

    public abstract long getStorageBytesWritten();
}

