/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.authentication.util;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class JaasConfiguration
extends Configuration {
    private final Configuration baseConfig = Configuration.getConfiguration();
    private final AppConfigurationEntry[] entry;
    private final String entryName;

    public JaasConfiguration(String entryName, String principal, String keytab) {
        this.entryName = entryName;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("keyTab", keytab);
        options.put("principal", principal);
        options.put("useKeyTab", "true");
        options.put("storeKey", "true");
        options.put("useTicketCache", "false");
        options.put("refreshKrb5Config", "true");
        String jaasEnvVar = System.getenv("HADOOP_JAAS_DEBUG");
        if ("true".equalsIgnoreCase(jaasEnvVar)) {
            options.put("debug", "true");
        }
        this.entry = new AppConfigurationEntry[]{new AppConfigurationEntry(this.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return this.entryName.equals(name) ? this.entry : (this.baseConfig != null ? this.baseConfig.getAppConfigurationEntry(name) : null);
    }

    private String getKrb5LoginModuleName() {
        String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        return krb5LoginModuleName;
    }
}

